/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit.api;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import org.jetbrains.annotations.ApiStatus;
import red.jackf.whereisit.WhereIsIt;
import red.jackf.whereisit.api.criteria.Criterion;
import red.jackf.whereisit.api.criteria.builtin.AllOfCriterion;
import red.jackf.whereisit.api.search.NestedItemsGrabber;
import red.jackf.whereisit.config.WhereIsItConfig;

public class SearchRequest
implements Consumer<Criterion> {
    public static final Codec<SearchRequest> CODEC = Criterion.CODEC.listOf().xmap(SearchRequest::new, req -> req.criteria);
    public static final String ID = "Id";
    private final List<Criterion> criteria;

    public SearchRequest() {
        this.criteria = new ArrayList<Criterion>();
    }

    public SearchRequest(List<Criterion> criteria) {
        this.criteria = Lists.newArrayList(criteria);
    }

    public static boolean check(class_1799 stack, SearchRequest request) {
        if (request.test(stack)) {
            return true;
        }
        if (((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getCommon().doNestedSearch) {
            Stream<class_1799> nested = NestedItemsGrabber.get(stack);
            return nested.anyMatch(request::test);
        }
        return false;
    }

    public boolean hasCriteria() {
        return !this.criteria.isEmpty();
    }

    @Override
    public void accept(Criterion criterion) {
        if (criterion.valid()) {
            if (criterion instanceof AllOfCriterion) {
                AllOfCriterion allOfCriterion = (AllOfCriterion)criterion;
                this.criteria.addAll(allOfCriterion.criteria);
            } else {
                this.criteria.add(criterion);
            }
        } else {
            WhereIsIt.LOGGER.warn("Invalid criterion: " + String.valueOf(criterion));
        }
    }

    public class_2499 toTag() {
        class_2520 tag;
        DataResult encoded = CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this);
        if (encoded.isSuccess() && (tag = (class_2520)encoded.getOrThrow()) instanceof class_2499) {
            class_2499 listTag = (class_2499)tag;
            return listTag;
        }
        return new class_2499();
    }

    @ApiStatus.Internal
    private boolean test(class_1799 stack) {
        for (Criterion criterion : this.criteria) {
            if (criterion.test(stack)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "SearchRequest[" + this.criteria.stream().map((Function<Criterion, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lred/jackf/whereisit/api/criteria/Criterion;)Ljava/lang/String;)()).collect(Collectors.joining(", ")) + "]";
    }
}

