/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit.client;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import red.jackf.jackfredlib.api.colour.Colour;
import red.jackf.jackfredlib.api.colour.Colours;
import red.jackf.jackfredlib.api.colour.Gradient;
import red.jackf.jackfredlib.client.api.colour.GradientUtils;
import red.jackf.whereisit.WhereIsIt;
import red.jackf.whereisit.client.render.CurrentGradientHolder;
import red.jackf.whereisit.config.ColourScheme;
import red.jackf.whereisit.config.WhereIsItConfig;

@Environment(value=EnvType.CLIENT)
public class WhereIsItConfigScreenBuilder {
    private static final class_2960 COLOUR_PREVIEW_BORDER = WhereIsIt.id("colour_preview_border");

    public static class_437 build(class_437 parent) {
        ConfigClassHandler<WhereIsItConfig> instance = WhereIsItConfig.INSTANCE;
        return YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"whereisit.config.title")).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"whereisit.config.title")).group(WhereIsItConfigScreenBuilder.makeClientGroup((WhereIsItConfig)instance.defaults(), (WhereIsItConfig)instance.instance())).build()).save(() -> {
            instance.save();
            CurrentGradientHolder.refreshColourScheme();
        }).build().generateScreen(parent);
    }

    private static OptionGroup makeClientGroup(WhereIsItConfig defaults, WhereIsItConfig config) {
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"whereisit.config.client")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"whereisit.config.client.searchUsingItemInHand")).binding((Object)defaults.getClient().searchUsingItemInHand, () -> config.getClient().searchUsingItemInHand, b -> {
            config.getClient().searchUsingItemInHand = b;
        }).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"whereisit.config.client.searchUsingItemInHand.description")})).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).yesNoFormatter()).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"whereisit.config.client.playSoundOnRequest")).binding((Object)defaults.getClient().playSoundOnRequest, () -> config.getClient().playSoundOnRequest, b -> {
            config.getClient().playSoundOnRequest = b;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).yesNoFormatter()).build()).options(WhereIsItConfigScreenBuilder.makeLabelOptions(defaults, config)).options(WhereIsItConfigScreenBuilder.makeColourOptions(defaults, config)).build();
    }

    private static Collection<? extends Option<?>> makeLabelOptions(WhereIsItConfig defaults, WhereIsItConfig config) {
        Option nameSizeOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"whereisit.config.client.containerNameLabelScale")).description(f -> OptionDescription.createBuilder().customImage(CompletableFuture.supplyAsync(() -> WhereIsItConfigScreenBuilder.getLabelImage(() -> f))).build()).binding((Object)Float.valueOf(defaults.getClient().containerNameLabelScale), () -> Float.valueOf(config.getClient().containerNameLabelScale), f -> {
            config.getClient().containerNameLabelScale = f.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).formatValue(f -> class_2561.method_43469((String)"mco.download.percent", (Object[])new Object[]{(int)(f.floatValue() * 100.0f)}))).range((Number)Float.valueOf(0.25f), (Number)Float.valueOf(2.0f))).step((Number)Float.valueOf(0.01f))).build();
        Option showNameToggle = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"whereisit.config.client.showContainerNamesInResults")).description(b -> OptionDescription.createBuilder().customImage(CompletableFuture.supplyAsync(() -> WhereIsItConfigScreenBuilder.getLabelImage(() -> Float.valueOf(b != false ? ((Float)nameSizeOption.pendingValue()).floatValue() : 0.0f)))).build()).binding((Object)defaults.getClient().showContainerNamesInResults, () -> config.getClient().showContainerNamesInResults, b -> {
            config.getClient().showContainerNamesInResults = b;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).yesNoFormatter()).build();
        return List.of(showNameToggle, nameSizeOption);
    }

    private static Optional<ImageRenderer> getLabelImage(final Supplier<Float> scaleGetter) {
        return Optional.of(new ImageRenderer(){
            private static final int IMAGE_WIDTH = 700;
            private static final int IMAGE_HEIGHT = 536;
            private static final int LABEL_MID_X = 340;
            private static final int LABEL_MID_Y = 146;
            private static final int LABEL_REF_WIDTH = 136;
            private static final int LABEL_REF_HEIGHT = 54;

            public int render(class_332 graphics, int x, int y, int renderWidth, float tickDelta) {
                float ratio = (float)renderWidth / 700.0f;
                int height = (int)(536.0f * ratio);
                graphics.method_51448().translate((float)x, (float)y);
                graphics.method_51448().scale(ratio, ratio);
                graphics.method_70845(WhereIsIt.id("textures/gui/config/show_container_names_example.png"), 0, 0, 0, 0, 700.0f, 536.0f, 700.0f, 536.0f);
                float f = ((Float)scaleGetter.get()).floatValue();
                if (f == 0.0f) {
                    return height;
                }
                int halfWidth = (int)(68.0f * f);
                int halfHeight = (int)(27.0f * f);
                int bgColour = (int)(class_310.method_1551().field_1690.method_19343(0.25f) * 255.0f) << 24;
                graphics.method_25294(340 - halfWidth, 146 - halfHeight, 340 + halfWidth, 146 + halfHeight, bgColour);
                graphics.method_51448().translate(340.0f, 146.0f);
                graphics.method_51448().scale(f * 5.0f, f * 5.0f);
                class_327 font = class_310.method_1551().field_1772;
                int textWidth = font.method_1727("Tools");
                int n = -textWidth / 2;
                Objects.requireNonNull(font);
                graphics.method_51433(font, "Tools", n, -9 / 2, -1, false);
                return height;
            }

            public void close() {
            }
        });
    }

    private static Collection<? extends Option<?>> makeColourOptions(WhereIsItConfig defaults, WhereIsItConfig config) {
        Option solidColourOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"whereisit.config.client.solidColour")).binding((Object)defaults.getClient().solidColour, () -> config.getClient().solidColour, c -> {
            config.getClient().solidColour = c;
        }).controller(opt -> ColorControllerBuilder.create((Option)opt).allowAlpha(false)).description(color -> OptionDescription.createBuilder().customImage(CompletableFuture.supplyAsync(() -> WhereIsItConfigScreenBuilder.getGradientPreview(ColourScheme.SOLID, color))).build()).build();
        Option colourSchemeOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"whereisit.config.client.colourScheme")).binding((Object)defaults.getClient().colourScheme, () -> config.getClient().colourScheme, c -> {
            config.getClient().colourScheme = c;
        }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(ColourScheme.class)).description(colourScheme -> OptionDescription.createBuilder().customImage(CompletableFuture.supplyAsync(() -> WhereIsItConfigScreenBuilder.getGradientPreview(colourScheme, (Color)solidColourOption.pendingValue()))).build()).build();
        return List.of(colourSchemeOption, solidColourOption);
    }

    private static Optional<ImageRenderer> getGradientPreview(final ColourScheme scheme, final Color solidColour) {
        return Optional.of(new ImageRenderer(){

            public int render(class_332 graphics, int x, int y, int renderWidth, float tickDelta) {
                int borderThickness = 8;
                int renderHeight = 64;
                int width = renderWidth - 2 * borderThickness;
                int height = renderHeight - 2 * borderThickness;
                graphics.method_51448().translate((float)x, (float)y);
                graphics.method_70845(COLOUR_PREVIEW_BORDER, 0, 0, 0, 0, (float)renderWidth, (float)renderHeight, 256.0f, 256.0f);
                Colour solid = Colour.fromInt((int)solidColour.getRGB());
                Object previewScheme = scheme == ColourScheme.SOLID ? solid : (scheme == ColourScheme.FLASHING ? Gradient.of((Colour[])new Colour[]{solid, Colours.BLACK, solid}).repeat(2) : scheme.getGradient());
                GradientUtils.drawHorizontalGradient((class_332)graphics, (int)borderThickness, (int)borderThickness, (int)width, (int)height, (Gradient)previewScheme, (float)0.0f, (float)1.0f);
                return renderHeight;
            }

            public void close() {
            }
        });
    }
}

