/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit.client.compat.recipeviewers;

import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import red.jackf.whereisit.WhereIsIt;
import red.jackf.whereisit.api.SearchRequest;
import red.jackf.whereisit.api.criteria.builtin.FluidCriterion;
import red.jackf.whereisit.api.criteria.builtin.ItemCriterion;
import red.jackf.whereisit.client.WhereIsItClient;
import red.jackf.whereisit.client.api.events.SearchRequestPopulator;
import red.jackf.whereisit.client.api.events.ShouldIgnoreKey;
import red.jackf.whereisit.client.compat.CompatUtils;
import red.jackf.whereisit.config.WhereIsItConfig;

@Environment(value=EnvType.CLIENT)
public final class WhereIsItJEIPlugin
implements IModPlugin {
    private boolean hasErrored = false;
    private boolean setup = false;
    private IJeiRuntime runtime = null;

    @NotNull
    public class_2960 getPluginUid() {
        return WhereIsIt.id("stack_grabber");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        if (FabricLoader.getInstance().isModLoaded("emi")) {
            return;
        }
        if (!this.setup) {
            WhereIsItClient.LOGGER.info("Hooking into JEI");
            SearchRequestPopulator.EVENT.register((request, screen, mouseX, mouseY) -> {
                if (!((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getClient().compatibility.jeiSupport) {
                    return;
                }
                if (this.hasErrored) {
                    return;
                }
                try {
                    if (this.runtime != null) {
                        boolean ingredientsStack = this.parseIngredient(request, arg_0 -> ((IIngredientListOverlay)this.runtime.getIngredientListOverlay()).getIngredientUnderMouse(arg_0), SearchRequestPopulator.Context.overlay());
                        if (ingredientsStack) {
                            return;
                        }
                        boolean bookmarkStack = this.parseIngredient(request, arg_0 -> ((IBookmarkOverlay)this.runtime.getBookmarkOverlay()).getIngredientUnderMouse(arg_0), SearchRequestPopulator.Context.FAVOURITE);
                        if (bookmarkStack) {
                            return;
                        }
                        this.getRecipeStack(request, this.runtime.getRecipesGui());
                    }
                }
                catch (Exception ex) {
                    CompatUtils.LOGGER.error("Error in JEI handler, disabling", (Throwable)ex);
                    this.hasErrored = true;
                }
            });
            ShouldIgnoreKey.EVENT.register(() -> {
                if (this.runtime != null) {
                    return this.runtime.getIngredientListOverlay().hasKeyboardFocus();
                }
                return false;
            });
            this.setup = true;
        }
        this.runtime = jeiRuntime;
    }

    private void getRecipeStack(SearchRequest request, IRecipesGui recipe) {
        Optional stack = recipe.getIngredientUnderMouse((IIngredientType)VanillaTypes.ITEM_STACK);
        if (stack.isPresent()) {
            request.accept(new ItemCriterion(((class_1799)stack.get()).method_7909()));
            return;
        }
        Optional fluid = recipe.getIngredientUnderMouse((IIngredientType)FabricTypes.FLUID_STACK);
        fluid.ifPresent(fluidIngredient -> request.accept(new FluidCriterion(fluidIngredient.getFluid())));
    }

    private boolean parseIngredient(SearchRequest request, OverlayGetter getter, SearchRequestPopulator.Context context) {
        class_1799 stack = (class_1799)getter.get(VanillaTypes.ITEM_STACK);
        if (stack != null) {
            SearchRequestPopulator.addItemStack(request, stack, context);
            return true;
        }
        IJeiFluidIngredient fluidIngredient = (IJeiFluidIngredient)getter.get(FabricTypes.FLUID_STACK);
        if (fluidIngredient != null) {
            request.accept(new FluidCriterion(fluidIngredient.getFluid()));
            return true;
        }
        return false;
    }

    public void onRuntimeUnavailable() {
        this.runtime = null;
    }

    @Environment(value=EnvType.CLIENT)
    private static interface OverlayGetter {
        public <I> I get(IIngredientType<I> var1);
    }
}

