/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit.client.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.InvalidateRenderStateCallback;
import net.minecraft.class_1735;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.lwjgl.opengl.GL11;
import red.jackf.whereisit.api.SearchRequest;
import red.jackf.whereisit.api.SearchResult;
import red.jackf.whereisit.client.render.CurrentGradientHolder;
import red.jackf.whereisit.config.WhereIsItConfig;

@Environment(value=EnvType.CLIENT)
public class Rendering {
    private static final Map<class_2338, SearchResult> results = new HashMap<class_2338, SearchResult>();
    private static final Map<class_2338, SearchResult> namedResults = new HashMap<class_2338, SearchResult>();
    private static final List<ScheduledLabel> scheduledLabels = new ArrayList<ScheduledLabel>();
    private static long ticksSinceSearch = 0L;
    @Nullable
    private static SearchRequest lastRequest = null;

    public static void setup() {
        HudRenderCallback.EVENT.register((guiGraphics, tickDelta) -> {
            if (!Rendering.shouldBeRendering() || !((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getClient().showContainerNamesInResults) {
                return;
            }
            for (SearchResult value : namedResults.values()) {
                Rendering.scheduleLabel(value.pos().method_46558().method_1019(value.nameOffset()), value.name(), ((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getCommon().debug.labelsAreSeeThrough);
            }
        });
        InvalidateRenderStateCallback.EVENT.register(scheduledLabels::clear);
    }

    public static boolean shouldBeRendering() {
        return ticksSinceSearch <= (long)((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getCommon().fadeoutTimeTicks;
    }

    public static void addResults(Collection<SearchResult> newResults) {
        for (SearchResult result : newResults) {
            results.put(result.pos(), result);
            if (result.name() == null) continue;
            namedResults.put(result.pos(), result);
        }
    }

    public static void clearResults() {
        lastRequest = null;
        results.clear();
        namedResults.clear();
    }

    public static void setLastRequest(@Nullable SearchRequest request) {
        lastRequest = request;
    }

    public static long getTicksSinceSearch() {
        return ticksSinceSearch;
    }

    public static void incrementTicksSinceSearch() {
        ++ticksSinceSearch;
    }

    public static void resetSearchTime() {
        ticksSinceSearch = 0L;
    }

    public static Map<class_2338, SearchResult> getResults() {
        return results;
    }

    public static Map<class_2338, SearchResult> getNamedResults() {
        return namedResults;
    }

    public static void renderSlotHighlight(class_465<?> screen, class_332 graphics, int mouseX, int mouseY, float tickDelta) {
        if (!Rendering.shouldBeRendering() || lastRequest == null) {
            return;
        }
        float time = Rendering.getBaseProgress(ticksSinceSearch, tickDelta);
        for (class_1735 slot : screen.method_17577().field_7761) {
            if (!slot.method_7682() || !slot.method_7681() || !SearchRequest.check(slot.method_7677(), lastRequest)) continue;
            int x = slot.field_7873;
            int y = slot.field_7872;
            float progress = time;
            int colour = CurrentGradientHolder.getColour(progress += (float)slot.field_7873 / 256.0f * ((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getClient().slotHighlightXFactor);
            graphics.method_25294(x, y, x + 16, y + 16, colour);
        }
    }

    public static void scheduleLabel(class_243 pos, class_2561 name, boolean seeThrough) {
        if (pos == null || name == null) {
            return;
        }
        scheduledLabels.add(new ScheduledLabel(pos, name, seeThrough));
    }

    public static void renderLabels(class_4587 poseStack, class_4184 camera, class_4597 consumers) {
        scheduledLabels.stream().sorted(Comparator.comparingDouble(label -> -camera.method_19326().method_1025(label.position))).forEach(label -> Rendering.renderLabel(label, poseStack, camera, consumers));
        scheduledLabels.clear();
    }

    private static void renderLabel(ScheduledLabel label, class_4587 pose, class_4184 camera, class_4597 consumers) {
        pose.method_22903();
        class_243 pos = label.position.method_1020(camera.method_19326());
        pose.method_22904(pos.field_1352, pos.field_1351, pos.field_1350);
        pose.method_22907((Quaternionfc)camera.method_23767());
        float factor = 0.025f * ((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getClient().containerNameLabelScale;
        pose.method_22905(factor, -factor, factor);
        Matrix4f matrix = pose.method_23760().method_23761();
        int width = class_310.method_1551().field_1772.method_27525((class_5348)label.text);
        float x = (float)(-width) / 2.0f;
        class_4588 bgBuffer = consumers.method_73477(class_1921.method_49046());
        int bgColour = (int)(class_310.method_1551().field_1690.method_19343(0.25f) * 255.0f) << 24;
        bgBuffer.method_22918(matrix, x - 1.0f, -1.0f, 0.0f).method_39415(bgColour).method_60803(0xF000F0);
        bgBuffer.method_22918(matrix, x - 1.0f, 10.0f, 0.0f).method_39415(bgColour).method_60803(0xF000F0);
        bgBuffer.method_22918(matrix, x + (float)width, 10.0f, 0.0f).method_39415(bgColour).method_60803(0xF000F0);
        bgBuffer.method_22918(matrix, x + (float)width, -1.0f, 0.0f).method_39415(bgColour).method_60803(0xF000F0);
        GL11.glDisable((int)2929);
        GL11.glDepthFunc((int)519);
        class_327.class_6415 mode = label.seeThrough ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993;
        class_310.method_1551().field_1772.method_27522(label.text, x, 0.0f, -1, false, matrix, consumers, mode, 0, 0xF000F0);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)2929);
        pose.method_22909();
    }

    public static void renderBoxes(class_4587 poseStack, class_4597.class_4598 bufferSource, class_4184 camera, float tickDelta) {
        if (results.isEmpty()) {
            return;
        }
        class_243 camPos = camera.method_19326();
        class_4587 pose = new class_4587();
        pose.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(camera.method_19329()));
        pose.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(camera.method_19330() - 180.0f));
        class_4588 consumer = bufferSource.method_73477(class_1921.method_49042());
        float progress = Rendering.getRenderingProgress(tickDelta);
        int rgbColor = CurrentGradientHolder.getColour(Rendering.getBaseProgress(ticksSinceSearch, tickDelta));
        float r = (float)class_9848.method_61327((int)rgbColor) / 255.0f;
        float g = (float)class_9848.method_61329((int)rgbColor) / 255.0f;
        float b = (float)class_9848.method_61331((int)rgbColor) / 255.0f;
        float baseAlpha = 0.4f;
        float alpha = baseAlpha - progress * baseAlpha / 2.0f;
        float scale = Rendering.easingFunc(progress);
        for (SearchResult result : Rendering.getResults().values()) {
            Rendering.renderBox(camPos, result.pos(), consumer, pose, r, g, b, alpha, scale);
            for (class_2338 otherPos : result.otherPositions()) {
                Rendering.renderBox(camPos, otherPos, consumer, pose, r, g, b, alpha, scale);
            }
        }
        bufferSource.method_22994(class_1921.method_49042());
    }

    private static float getRenderingProgress(float tickDelta) {
        return Math.min(((float)Rendering.getTicksSinceSearch() + tickDelta) / (float)((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getCommon().fadeoutTimeTicks, 1.0f);
    }

    private static float getBaseProgress(long ticks, float delta) {
        float base = (float)ticks + delta;
        return (base *= ((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getClient().highlightTimeFactor) % 80.0f / 80.0f;
    }

    private static float easingFunc(float progress) {
        float power = 32.0f;
        return (float)((1.0 - Math.pow(progress, power)) * (1.0 - Math.pow(1.0f - progress, power)) * (double)(1.0f - progress / 4.0f));
    }

    private static void renderBox(class_243 cameraPos, class_2338 pos, class_4588 consumer, class_4587 pose, float r, float g, float b, float a, float scale) {
        pose.method_22903();
        double xOffset = (double)pos.method_10263() + (0.5 - cameraPos.field_1352);
        double yOffset = (double)pos.method_10264() + (0.5 - cameraPos.field_1351);
        double zOffset = (double)pos.method_10260() + (0.5 - cameraPos.field_1350);
        pose.method_22904(xOffset, yOffset, zOffset);
        pose.method_22905(scale * 0.5f, scale * 0.5f, scale * 0.5f);
        Matrix4f matrix = pose.method_23760().method_23761();
        int color = class_9848.method_61324((int)((int)(a * 255.0f)), (int)((int)(r * 255.0f)), (int)((int)(g * 255.0f)), (int)((int)(b * 255.0f)));
        consumer.method_22918(matrix, -1.0f, -1.0f, -1.0f).method_39415(color);
        consumer.method_22918(matrix, -1.0f, 1.0f, -1.0f).method_39415(color);
        consumer.method_22918(matrix, 1.0f, 1.0f, -1.0f).method_39415(color);
        consumer.method_22918(matrix, 1.0f, -1.0f, -1.0f).method_39415(color);
        consumer.method_22918(matrix, -1.0f, -1.0f, 1.0f).method_39415(color);
        consumer.method_22918(matrix, 1.0f, -1.0f, 1.0f).method_39415(color);
        consumer.method_22918(matrix, 1.0f, 1.0f, 1.0f).method_39415(color);
        consumer.method_22918(matrix, -1.0f, 1.0f, 1.0f).method_39415(color);
        consumer.method_22918(matrix, -1.0f, -1.0f, -1.0f).method_39415(color);
        consumer.method_22918(matrix, 1.0f, -1.0f, -1.0f).method_39415(color);
        consumer.method_22918(matrix, 1.0f, -1.0f, 1.0f).method_39415(color);
        consumer.method_22918(matrix, -1.0f, -1.0f, 1.0f).method_39415(color);
        consumer.method_22918(matrix, -1.0f, 1.0f, -1.0f).method_39415(color);
        consumer.method_22918(matrix, -1.0f, 1.0f, 1.0f).method_39415(color);
        consumer.method_22918(matrix, 1.0f, 1.0f, 1.0f).method_39415(color);
        consumer.method_22918(matrix, 1.0f, 1.0f, -1.0f).method_39415(color);
        consumer.method_22918(matrix, -1.0f, -1.0f, -1.0f).method_39415(color);
        consumer.method_22918(matrix, -1.0f, -1.0f, 1.0f).method_39415(color);
        consumer.method_22918(matrix, -1.0f, 1.0f, 1.0f).method_39415(color);
        consumer.method_22918(matrix, -1.0f, 1.0f, -1.0f).method_39415(color);
        consumer.method_22918(matrix, 1.0f, -1.0f, -1.0f).method_39415(color);
        consumer.method_22918(matrix, 1.0f, 1.0f, -1.0f).method_39415(color);
        consumer.method_22918(matrix, 1.0f, 1.0f, 1.0f).method_39415(color);
        consumer.method_22918(matrix, 1.0f, -1.0f, 1.0f).method_39415(color);
        pose.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    private record ScheduledLabel(class_243 position, class_2561 text, boolean seeThrough) {
    }
}

