/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.packets.input.teleport;

import ac.boar.anticheat.data.input.PredictionData;
import ac.boar.anticheat.data.input.TickData;
import ac.boar.anticheat.packets.input.legacy.LegacyAuthInputPackets;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.prediction.PredictionRunner;
import ac.boar.anticheat.teleport.data.TeleportCache;
import ac.boar.anticheat.util.math.Vec3;
import java.util.Queue;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;

public class TeleportHandler {
    protected void processQueuedTeleports(BoarPlayer player, PlayerAuthInputPacket packet) {
        TeleportCache cache;
        Queue<TeleportCache> queuedTeleports = player.getTeleportUtil().getQueuedTeleports();
        if (queuedTeleports.isEmpty()) {
            return;
        }
        while ((cache = queuedTeleports.peek()) != null && player.receivedStackId.get() >= cache.getStackId()) {
            queuedTeleports.poll();
            TeleportCache peek = queuedTeleports.peek();
            if (peek != null && player.receivedStackId.get() < peek.getStackId()) continue;
            if (cache instanceof TeleportCache.Normal) {
                TeleportCache.Normal normal = (TeleportCache.Normal)cache;
                this.processTeleport(player, normal, packet);
                continue;
            }
            if (cache instanceof TeleportCache.DimensionSwitch) {
                TeleportCache.DimensionSwitch dimension = (TeleportCache.DimensionSwitch)cache;
                this.processDimensionSwitch(player, dimension, packet);
                continue;
            }
            if (cache instanceof TeleportCache.Rewind) {
                TeleportCache.Rewind rewind = (TeleportCache.Rewind)cache;
                this.processRewind(player, rewind, packet);
                continue;
            }
            throw new RuntimeException("Failed to process queued teleports, invalid teleport=" + String.valueOf(cache));
        }
    }

    private void processDimensionSwitch(BoarPlayer player, TeleportCache.DimensionSwitch dimension, PlayerAuthInputPacket packet) {
        if (packet.getPosition().distance(dimension.getPosition().toVector3f()) <= 0.001f) {
            player.setPos(new Vec3(packet.getPosition().sub(0.0f, player.getYOffset(), 0.0f)));
            player.unvalidatedPosition = player.prevUnvalidatedPosition = player.position.clone();
            player.velocity = Vec3.ZERO.clone();
            player.predictionResult = new PredictionData(Vec3.ZERO, Vec3.ZERO, Vec3.ZERO);
        }
    }

    private void processTeleport(BoarPlayer player, TeleportCache.Normal normal, PlayerAuthInputPacket packet) {
        double distance = packet.getPosition().distance(normal.getPosition().toVector3f());
        if (packet.getInputData().contains(PlayerAuthInputData.HANDLE_TELEPORT) && distance <= (double)0.001f) {
            player.setPos(new Vec3(packet.getPosition().sub(0.0f, player.getYOffset(), 0.0f)));
            player.unvalidatedPosition = player.prevUnvalidatedPosition = player.position.clone();
            player.velocity = Vec3.ZERO.clone();
            player.predictionResult = new PredictionData(Vec3.ZERO, Vec3.ZERO, Vec3.ZERO);
            player.onGround = false;
        } else if (!player.getTeleportUtil().isTeleporting()) {
            player.getTeleportUtil().teleportTo(normal);
        }
    }

    private void processRewind(BoarPlayer player, TeleportCache.Rewind rewind, PlayerAuthInputPacket packet) {
        if (player.isMovementExempted()) {
            return;
        }
        player.onGround = rewind.isOnGround();
        player.velocity = rewind.getTickEnd();
        player.setPos(rewind.getPosition().subtract(0.0f, player.getYOffset(), 0.0f));
        player.prevUnvalidatedPosition = player.unvalidatedPosition = player.position.clone();
        player.getTeleportUtil().cachePosition(rewind.getTick(), rewind.getPosition().toVector3f());
        long currentTick = rewind.getTick();
        while (currentTick != player.tick) {
            if (currentTick != rewind.getTick() && (double)player.position.distanceTo(player.unvalidatedPosition) > player.getMaxOffset()) {
                player.unvalidatedPosition = player.position.clone();
            }
            if (++currentTick == player.tick) {
                LegacyAuthInputPackets.processAuthInput(player, packet, true);
                LegacyAuthInputPackets.updateUnvalidatedPosition(player, packet);
            } else if (player.getTeleportUtil().getAuthInputHistory().containsKey(currentTick)) {
                TickData data = player.getTeleportUtil().getAuthInputHistory().get(currentTick);
                LegacyAuthInputPackets.processAuthInput(player, data.packet(), false);
                LegacyAuthInputPackets.updateUnvalidatedPosition(player, packet);
                player.getFlagTracker().set(data.flags(), false);
            } else {
                throw new RuntimeException("Failed find auth input history for rewind.");
            }
            new PredictionRunner(player).run();
        }
    }
}

