/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.compensated.cache.container;

import ac.boar.anticheat.compensated.CompensatedInventory;
import ac.boar.anticheat.data.inventory.ItemCache;
import java.util.Arrays;
import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;

public class ContainerCache {
    protected final CompensatedInventory inventory;
    private final byte id;
    private final ContainerType type;
    private final Vector3i blockPosition;
    private final long uniqueEntityId;
    private final int containerSize;
    private final int offset;
    private final ItemCache[] contents;

    public ContainerCache(CompensatedInventory inventory, byte id, ContainerType type, Vector3i blockPosition, long uniqueEntityId) {
        this.inventory = inventory;
        this.id = id;
        this.type = type;
        this.blockPosition = blockPosition;
        this.uniqueEntityId = uniqueEntityId;
        this.offset = switch (type) {
            case ContainerType.ENCHANTMENT -> 14;
            case ContainerType.LOOM -> 9;
            case ContainerType.WORKBENCH -> 32;
            case ContainerType.BEACON -> 27;
            case ContainerType.ANVIL -> 1;
            case ContainerType.STONECUTTER -> 3;
            case ContainerType.CARTOGRAPHY -> 12;
            case ContainerType.SMITHING_TABLE -> 51;
            case ContainerType.GRINDSTONE -> 16;
            case ContainerType.TRADE -> 4;
            default -> 0;
        };
        switch (type) {
            case LOOM: 
            case SMITHING_TABLE: 
            case FURNACE: 
            case BLAST_FURNACE: 
            case SMOKER: {
                int n = 3;
                break;
            }
            case BREWING_STAND: 
            case HOPPER: 
            case MINECART_HOPPER: {
                int n = 5;
                break;
            }
            case WORKBENCH: 
            case DROPPER: 
            case DISPENSER: 
            case CRAFTER: {
                int n = 9;
                break;
            }
            case ENCHANTMENT: 
            case ANVIL: 
            case CARTOGRAPHY: 
            case GRINDSTONE: 
            case HORSE: {
                int n = 2;
                break;
            }
            case BEACON: 
            case STONECUTTER: {
                int n = 1;
                break;
            }
            case STRUCTURE_EDITOR: 
            case COMMAND_BLOCK: {
                int n = 0;
                break;
            }
            case MINECART_CHEST: 
            case CHEST_BOAT: {
                int n = 26;
                break;
            }
            case CONTAINER: {
                int n = 56;
                break;
            }
            case TRADE: {
                int n = 2;
                break;
            }
            case ARMOR: {
                int n = 4;
                break;
            }
            default: {
                int n = this.containerSize = 36;
            }
        }
        if (this.containerSize > 0) {
            this.contents = new ItemCache[this.containerSize];
            Arrays.fill(this.contents, ItemCache.AIR);
        } else {
            this.contents = null;
        }
    }

    public int getContainerSize() {
        return this.containerSize + this.offset;
    }

    public ItemCache get(int slot) {
        ItemCache cache = this.contents[slot - this.offset];
        return cache == null ? ItemCache.AIR : cache;
    }

    public void set(int slot, ItemData raw) {
        this.set(slot, raw, true);
    }

    public void set(int slot, ItemCache raw) {
        this.set(slot, raw, true);
    }

    public void set(int slot, ItemData raw, boolean offset) {
        this.set(slot, ItemCache.build(this.inventory, raw), offset);
    }

    public void set(int slot, ItemCache cache, boolean offset) {
        this.contents[offset ? slot - this.offset : slot] = cache;
    }

    @Generated
    public byte getId() {
        return this.id;
    }

    @Generated
    public ContainerType getType() {
        return this.type;
    }

    @Generated
    public Vector3i getBlockPosition() {
        return this.blockPosition;
    }

    @Generated
    public long getUniqueEntityId() {
        return this.uniqueEntityId;
    }

    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Generated
    public ItemCache[] getContents() {
        return this.contents;
    }
}

