/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.util.geyser;

import ac.boar.anticheat.util.MathUtil;
import ac.boar.anticheat.util.geyser.BlockStorage;
import org.cloudburstmc.protocol.common.util.Preconditions;

public record BoarChunkSection(BlockStorage[] storage) {
    public BoarChunkSection(int initialBlockId) {
        this(new BlockStorage[]{new BlockStorage(initialBlockId), new BlockStorage(initialBlockId)});
    }

    public int getFullBlock(int x, int y, int z, int layer) {
        if (layer < 0 || layer >= this.storage.length) {
            return Integer.MIN_VALUE;
        }
        BoarChunkSection.checkBounds(x, y, z);
        return this.storage[layer].getFullBlock(MathUtil.blockPosition(x, y, z));
    }

    public void setFullBlock(int x, int y, int z, int layer, int block) {
        if (layer < 0 || layer >= this.storage.length) {
            return;
        }
        BoarChunkSection.checkBounds(x, y, z);
        this.storage[layer].setFullBlock(MathUtil.blockPosition(x, y, z), block);
    }

    private static void checkBounds(int x, int y, int z) {
        Preconditions.checkArgument((x >= 0 && x < 16 ? 1 : 0) != 0, (String)"x (%s) is not between 0 and 15", (int)x);
        Preconditions.checkArgument((y >= 0 && y < 16 ? 1 : 0) != 0, (String)"y (%s) is not between 0 and 15", (int)y);
        Preconditions.checkArgument((z >= 0 && z < 16 ? 1 : 0) != 0, (String)"z (%s) is not between 0 and 15", (int)z);
    }
}

