/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.targets.impl;

import ac.boar.shaded.asm.Type;
import ac.boar.shaded.asm.tree.AbstractInsnNode;
import ac.boar.shaded.asm.tree.LdcInsnNode;
import ac.boar.shaded.asm.tree.MethodNode;
import ac.boar.shaded.classtransform.annotations.CSlice;
import ac.boar.shaded.classtransform.annotations.CTarget;
import ac.boar.shaded.classtransform.targets.IInjectionTarget;
import ac.boar.shaded.classtransform.utils.ASMUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ConstantTarget
implements IInjectionTarget {
    @Override
    public List<AbstractInsnNode> getTargets(Map<String, IInjectionTarget> injectionTargets, MethodNode method, CTarget target, @Nullable CSlice slice) {
        ArrayList<AbstractInsnNode> targets = new ArrayList<AbstractInsnNode>();
        List<AbstractInsnNode> instructions = this.getSlice(injectionTargets, method, slice);
        if (target.target().equalsIgnoreCase("null")) {
            this.findNull(targets, instructions);
        } else if (target.target().toLowerCase(Locale.ROOT).startsWith("int")) {
            this.findInt(targets, instructions, target.target());
        } else if (target.target().toLowerCase(Locale.ROOT).startsWith("long")) {
            this.findLong(targets, instructions, target.target());
        } else if (target.target().toLowerCase(Locale.ROOT).startsWith("float")) {
            this.findFloat(targets, instructions, target.target());
        } else if (target.target().toLowerCase(Locale.ROOT).startsWith("double")) {
            this.findDouble(targets, instructions, target.target());
        } else if (target.target().toLowerCase(Locale.ROOT).startsWith("string")) {
            this.findString(targets, instructions, target.target());
        } else if (target.target().toLowerCase(Locale.ROOT).startsWith("type")) {
            this.findType(targets, instructions, target.target());
        } else {
            throw new IllegalArgumentException("Unknown constant type '" + target.target() + "'");
        }
        if (target.ordinal() != -1) {
            if (target.ordinal() < 0 || target.ordinal() >= targets.size()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(targets.get(target.ordinal()));
        }
        return targets;
    }

    private void findNull(List<AbstractInsnNode> targets, List<AbstractInsnNode> instructions) {
        for (AbstractInsnNode instruction : instructions) {
            if (instruction.getOpcode() != 1) continue;
            targets.add(instruction);
        }
    }

    private void findInt(List<AbstractInsnNode> targets, List<AbstractInsnNode> instructions, String value) {
        int val = this.parse(value, "int", len -> len == 2, Integer::parseInt);
        for (AbstractInsnNode instruction : instructions) {
            Number number = ASMUtils.getNumber(instruction);
            if (!(number instanceof Byte) && !(number instanceof Short) && !(number instanceof Integer) || number.intValue() != val) continue;
            targets.add(instruction);
        }
    }

    private void findLong(List<AbstractInsnNode> targets, List<AbstractInsnNode> instructions, String value) {
        long val = this.parse(value, "long", len -> len == 2, Long::parseLong);
        for (AbstractInsnNode instruction : instructions) {
            Number number = ASMUtils.getNumber(instruction);
            if (!(number instanceof Long) || number.longValue() != val) continue;
            targets.add(instruction);
        }
    }

    private void findFloat(List<AbstractInsnNode> targets, List<AbstractInsnNode> instructions, String value) {
        float val = this.parse(value, "float", len -> len == 2, Float::parseFloat).floatValue();
        for (AbstractInsnNode instruction : instructions) {
            Number number = ASMUtils.getNumber(instruction);
            if (!(number instanceof Float) || number.floatValue() != val) continue;
            targets.add(instruction);
        }
    }

    private void findDouble(List<AbstractInsnNode> targets, List<AbstractInsnNode> instructions, String value) {
        double val = this.parse(value, "double", len -> len == 2, Double::parseDouble);
        for (AbstractInsnNode instruction : instructions) {
            Number number = ASMUtils.getNumber(instruction);
            if (!(number instanceof Double) || number.doubleValue() != val) continue;
            targets.add(instruction);
        }
    }

    private void findString(List<AbstractInsnNode> targets, List<AbstractInsnNode> instructions, String value) {
        String val = this.parse(value, "String", len -> len >= 2, s -> s);
        for (AbstractInsnNode instruction : instructions) {
            if (!(instruction instanceof LdcInsnNode) || !val.equals(((LdcInsnNode)instruction).cst)) continue;
            targets.add(instruction);
        }
    }

    private void findType(List<AbstractInsnNode> targets, List<AbstractInsnNode> instructions, String value) {
        Type val = this.parse(value, "type", len -> len == 2, Type::getType);
        for (AbstractInsnNode instruction : instructions) {
            if (!(instruction instanceof LdcInsnNode) || !val.equals(((LdcInsnNode)instruction).cst)) continue;
            targets.add(instruction);
        }
    }

    private <T> T parse(String value, String constantName, Function<Integer, Boolean> sizeChecker, Function<String, T> parser) {
        T val;
        String[] parts = value.split(" ");
        if (!sizeChecker.apply(parts.length).booleanValue()) {
            throw new IllegalArgumentException(constantName + " constant does not have " + this.getAorAN(constantName) + " " + constantName + " as argument");
        }
        String unparsedVal = value.substring(parts[0].length() + 1);
        try {
            val = parser.apply(unparsedVal);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(constantName + " constant value can not be parsed as " + this.getAorAN(constantName) + " " + constantName);
        }
        return val;
    }

    private String getAorAN(String s) {
        char c = s.toUpperCase().charAt(0);
        if (c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U') {
            return "an";
        }
        return "a";
    }
}

