/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.jackson.databind.ser.std;

import ac.boar.shaded.jackson.core.JsonGenerator;
import ac.boar.shaded.jackson.core.JsonToken;
import ac.boar.shaded.jackson.core.type.WritableTypeId;
import ac.boar.shaded.jackson.databind.JavaType;
import ac.boar.shaded.jackson.databind.JsonMappingException;
import ac.boar.shaded.jackson.databind.JsonNode;
import ac.boar.shaded.jackson.databind.SerializerProvider;
import ac.boar.shaded.jackson.databind.annotation.JacksonStdImpl;
import ac.boar.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import ac.boar.shaded.jackson.databind.jsontype.TypeSerializer;
import ac.boar.shaded.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ToEmptyObjectSerializer
extends StdSerializer<Object> {
    protected ToEmptyObjectSerializer(Class<?> raw) {
        super(raw, false);
    }

    public ToEmptyObjectSerializer(JavaType type) {
        super(type);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider ctxt) throws IOException {
        gen.writeStartObject(value, 0);
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.START_OBJECT));
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value) {
        return true;
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectObjectFormat(typeHint);
    }
}

