/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.player.data;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.compensated.CompensatedInventory;
import ac.boar.anticheat.data.EntityDimensions;
import ac.boar.anticheat.data.input.PredictionData;
import ac.boar.anticheat.data.input.VelocityData;
import ac.boar.anticheat.data.vanilla.AttributeInstance;
import ac.boar.anticheat.data.vanilla.StatusEffect;
import ac.boar.anticheat.player.data.VehicleData;
import ac.boar.anticheat.player.data.tracker.FlagTracker;
import ac.boar.anticheat.prediction.engine.data.Vector;
import ac.boar.anticheat.util.math.Box;
import ac.boar.anticheat.util.math.Vec3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.Ability;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.cloudburstmc.protocol.bedrock.data.InputMode;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.data.attribute.AttributeModifierData;
import org.cloudburstmc.protocol.bedrock.data.attribute.AttributeOperation;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.inventory.item.BedrockEnchantment;
import org.geysermc.geyser.level.block.Fluid;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;

public class PlayerData {
    private static final AttributeModifierData SPRINTING_SPEED_BOOST = new AttributeModifierData("D208FC00-42AA-4AAD-9276-D5446530DE43", "Sprinting speed boost", 0.3f, AttributeOperation.MULTIPLY_TOTAL, 2, false);
    public static final float JUMP_HEIGHT = 0.42f;
    public static final float STEP_HEIGHT = 0.6f;
    public static final float GRAVITY = 0.08f;
    public int BEDROCK_AIR = -1;
    public List<Integer> AIR_IDS = new ArrayList<Integer>();
    public final Map<Integer, Integer> bedrockBlockToJava = new HashMap<Integer, Integer>();
    private Set<PlayerAuthInputData> inputData = new HashSet<PlayerAuthInputData>();
    public long tick = -1L;
    public long sinceAuthInput = System.currentTimeMillis();
    public Integer currentLoadingScreen = null;
    public boolean inLoadingScreen;
    public int sinceLoadingScreen;
    public int sinceChunkUnloaded;
    public GameType gameType = GameType.DEFAULT;
    public InputMode inputMode = InputMode.UNDEFINED;
    public float yaw;
    public float pitch;
    public float prevYaw;
    public float prevPitch;
    public Vec3 unvalidatedPosition = Vec3.ZERO;
    public Vec3 prevUnvalidatedPosition = Vec3.ZERO;
    public Vector2f interactRotation = Vector2f.ZERO;
    public Vec3 position = Vec3.ZERO;
    public Vec3 prevPosition = Vec3.ZERO;
    public Vector3f rotation = Vector3f.ZERO;
    private final FlagTracker flagTracker = new FlagTracker();
    public int glideBoostTicks;
    public int ticksSinceSwimming;
    public int ticksSinceCrawling;
    public boolean doingInventoryAction;
    public AtomicLong desyncedFlag = new AtomicLong(-1L);
    private final Map<Effect, StatusEffect> activeEffects = new ConcurrentHashMap<Effect, StatusEffect>();
    public Vec3 input = Vec3.ZERO;
    public Vec3 unvalidatedTickEnd = Vec3.ZERO;
    public final Map<Long, VelocityData> queuedVelocities = Collections.synchronizedMap(new TreeMap());
    public final Map<String, AttributeInstance> attributes = new HashMap<String, AttributeInstance>();
    public final Set<Ability> abilities = new HashSet<Ability>();
    public boolean dirtyRiptide;
    public boolean dirtySpinStop;
    public boolean thisTickSpinAttack;
    public boolean thisTickOnGroundSpinAttack;
    public int autoSpinAttackTicks;
    public int sinceTridentUse;
    public ItemData riptideItem = ItemData.AIR;
    public EntityDimensions dimensions = EntityDimensions.changing(0.6f, 1.8f).withEyeHeight(1.62f);
    public Box boundingBox = Box.EMPTY;
    public Vec3 velocity = Vec3.ZERO;
    public Vec3 lastTickFinalVelocity = Vec3.ZERO;
    public PredictionData predictionResult = new PredictionData(Vec3.ZERO, Vec3.ZERO, Vec3.ZERO);
    public Vector bestPossibility = Vector.NONE;
    public Vec3 beforeCollision = Vec3.ZERO;
    public Vec3 afterCollision = Vec3.ZERO;
    public boolean onGround;
    public Vec3 stuckSpeedMultiplier = Vec3.ZERO;
    public float fallDistance = 0.0f;
    public boolean hasDepthStrider;
    public boolean touchingWater;
    public boolean horizontalCollision;
    public boolean verticalCollision;
    public boolean soulSandBelow;
    public boolean nearBamboo;
    public boolean beingPushByLava;
    public final Map<Fluid, Float> fluidHeight = new HashMap<Fluid, Float>();
    public BlockState inBlockState;
    public boolean scaffoldDescend;
    public VehicleData vehicleData = null;
    public int tickSinceBlockResync;

    public boolean hasEffect(Effect effect) {
        return this.activeEffects.containsKey(effect);
    }

    public StatusEffect getEffect(Effect effect) {
        return this.activeEffects.get(effect);
    }

    public void setDirtyRiptide(int j, ItemData data) {
        if (j < 10 || !CompensatedInventory.getEnchantments(data).containsKey(BedrockEnchantment.RIPTIDE)) {
            return;
        }
        this.riptideItem = data;
        this.dirtyRiptide = true;
    }

    public void stopRiptide() {
        this.dirtySpinStop = false;
        this.dirtyRiptide = false;
        this.autoSpinAttackTicks = 0;
        this.riptideItem = ItemData.AIR;
        this.getFlagTracker().set(EntityFlag.DAMAGE_NEARBY_MOBS, false);
    }

    public float getFluidHeight(Fluid tagKey) {
        return this.fluidHeight.getOrDefault(tagKey, Float.valueOf(0.0f)).floatValue();
    }

    public final float getMaxOffset() {
        return Boar.getConfig().acceptanceThreshold();
    }

    public final void setSprinting(boolean sprinting) {
        this.getFlagTracker().set(EntityFlag.SPRINTING, sprinting);
        AttributeInstance lv = this.attributes.get(GeyserAttributeType.MOVEMENT_SPEED.getBedrockIdentifier());
        if (lv == null) {
            return;
        }
        lv.removeModifier(SPRINTING_SPEED_BOOST.getId());
        if (sprinting) {
            lv.addTemporaryModifier(SPRINTING_SPEED_BOOST);
        }
    }

    public boolean isInLava() {
        return this.tick != 1L && (double)this.fluidHeight.getOrDefault(Fluid.LAVA, Float.valueOf(0.0f)).floatValue() != 0.0;
    }

    public final float getEffectiveGravity(Vec3 vec3) {
        return (double)vec3.y < 0.0 && this.hasEffect(Effect.SLOW_FALLING) ? Math.min(0.08f, 0.01f) : 0.08f;
    }

    public final float getEffectiveGravity() {
        return this.getEffectiveGravity(this.velocity);
    }

    public float getSpeed() {
        return this.attributes.get(GeyserAttributeType.MOVEMENT_SPEED.getBedrockIdentifier()).getValue();
    }

    public final void setPos(Vec3 vec3) {
        this.setPos(vec3, true);
    }

    public final void setPos(Vec3 vec3, boolean prev) {
        if (prev) {
            this.prevPosition = this.position;
        }
        this.position = vec3;
        if (this.vehicleData != null) {
            return;
        }
        this.setBoundingBox(vec3);
        this.inBlockState = null;
    }

    public final void setBoundingBox(Vec3 vec3) {
        this.boundingBox = this.dimensions.getBoxAt(vec3.x, vec3.y, vec3.z);
    }

    @Generated
    public Set<PlayerAuthInputData> getInputData() {
        return this.inputData;
    }

    @Generated
    public void setInputData(Set<PlayerAuthInputData> inputData) {
        this.inputData = inputData;
    }

    @Generated
    public FlagTracker getFlagTracker() {
        return this.flagTracker;
    }

    @Generated
    public Map<Effect, StatusEffect> getActiveEffects() {
        return this.activeEffects;
    }
}

