/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.util.reach;

import ac.boar.anticheat.compensated.cache.entity.state.CachedEntityState;
import ac.boar.anticheat.util.math.Vec3;
import lombok.Generated;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;

public class PositionInterpolator
implements Cloneable {
    private final CachedEntityState entity;
    private final int lerpDuration;
    private Vec3 targetPos;
    private int step;

    public PositionInterpolator(CachedEntityState entity) {
        this.entity = entity;
        this.lerpDuration = entity.getEntity() == null ? 3 : (entity.getEntity().getType() == EntityType.PLAYER ? 3 : 6);
    }

    public void refreshPositionAndAngles(Vec3 pow) {
        if (this.lerpDuration == 0) {
            this.entity.setPos(pow);
            this.clear();
            return;
        }
        this.targetPos = pow;
        this.step = this.lerpDuration;
    }

    public boolean isInterpolating() {
        return this.step > 0;
    }

    public void tick() {
        if (!this.isInterpolating()) {
            this.clear();
            return;
        }
        if (this.step > 0 && this.targetPos != null) {
            float x = this.entity.getPos().getX() + (this.targetPos.getX() - this.entity.getPos().getX()) / (float)this.step;
            float y = this.entity.getPos().getY() + (this.targetPos.getY() - this.entity.getPos().getY()) / (float)this.step;
            float z = this.entity.getPos().getZ() + (this.targetPos.getZ() - this.entity.getPos().getZ()) / (float)this.step;
            this.entity.setPos(new Vec3(x, y, z));
            --this.step;
        }
    }

    private void clear() {
        this.step = 0;
        this.targetPos = null;
    }

    public PositionInterpolator clone() {
        PositionInterpolator clone = new PositionInterpolator(this.entity);
        clone.targetPos = this.targetPos;
        clone.step = this.step;
        return clone;
    }

    @Generated
    public Vec3 getTargetPos() {
        return this.targetPos;
    }

    @Generated
    public int getStep() {
        return this.step;
    }
}

