/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.validator.blockbreak;

import ac.boar.anticheat.data.BreakingData;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.MathUtil;
import ac.boar.anticheat.util.block.BlockUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.PlayerActionType;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.data.PlayerBlockActionData;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.Direction;

public class ServerBreakBlockValidator {
    private static final List<PlayerActionType> ALLOWED_ACTIONS = List.of(PlayerActionType.START_BREAK, PlayerActionType.ABORT_BREAK, PlayerActionType.BLOCK_PREDICT_DESTROY, PlayerActionType.BLOCK_CONTINUE_DESTROY);
    private final BoarPlayer player;
    private BreakingData breakingData;

    public void handle(PlayerAuthInputPacket packet) {
        if (!packet.getInputData().contains(PlayerAuthInputData.PERFORM_BLOCK_ACTIONS)) {
            return;
        }
        ArrayList<PlayerBlockActionData> validActions = new ArrayList<PlayerBlockActionData>();
        block5: for (PlayerBlockActionData action : packet.getPlayerActions()) {
            PlayerActionType actionType = action.getAction();
            int face = action.getFace();
            if (!ALLOWED_ACTIONS.contains(actionType) || action.getBlockPosition() == null || !MathUtil.isValid(action.getBlockPosition()) || actionType != PlayerActionType.ABORT_BREAK && (face < 0 || face >= Direction.VALUES.length)) continue;
            Vector3i blockPosition = action.getBlockPosition();
            if (blockPosition.distance(this.player.position.toVector3i()) > 12.0f) {
                BlockUtil.restoreCorrectBlock(this.player.getSession(), blockPosition);
                continue;
            }
            BlockState state = this.player.compensatedWorld.getBlockState(blockPosition, 0).getState();
            if (!BlockUtil.determineCanBreak(this.player, state)) continue;
            switch (actionType) {
                case START_BREAK: 
                case BLOCK_CONTINUE_DESTROY: {
                    if (this.breakingData == null) {
                        this.breakingData = new BreakingData(PlayerActionType.START_BREAK, action.getBlockPosition(), face);
                    } else {
                        this.breakingData.setState(PlayerActionType.BLOCK_CONTINUE_DESTROY);
                    }
                    if (!Objects.equals(blockPosition, this.breakingData.getPosition())) {
                        BlockUtil.restoreCorrectBlock(this.player.getSession(), this.breakingData.getPosition());
                        this.breakingData = new BreakingData(PlayerActionType.START_BREAK, action.getBlockPosition(), face);
                    }
                    this.breakingData.setBreakingProcess(1.0f);
                    break;
                }
                case ABORT_BREAK: {
                    this.breakingData = null;
                    break;
                }
                case BLOCK_PREDICT_DESTROY: {
                    if (this.breakingData == null || !Objects.equals(blockPosition, this.breakingData.getPosition()) || !(this.breakingData.getBreakingProcess() >= 1.0f)) continue block5;
                    this.player.compensatedWorld.updateBlock(this.breakingData.getPosition(), 0, this.player.BEDROCK_AIR);
                    this.breakingData = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(action));
                }
            }
            validActions.add(action);
        }
        packet.getPlayerActions().clear();
        packet.getPlayerActions().addAll(validActions);
        if (packet.getPlayerActions().isEmpty()) {
            packet.getInputData().remove(PlayerAuthInputData.PERFORM_BLOCK_ACTIONS);
        }
    }

    @Generated
    public ServerBreakBlockValidator(BoarPlayer player) {
        this.player = player;
    }
}

