/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.geyser;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.acks.BoarAcknowledgement;
import ac.boar.anticheat.alert.AlertManager;
import ac.boar.anticheat.config.Config;
import ac.boar.anticheat.config.ConfigLoader;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.injector.BoarInjector;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.cloudburstmc.netty.channel.raknet.RakChildChannel;
import org.cloudburstmc.netty.handler.codec.raknet.common.RakSessionCodec;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.api.command.CommandSource;
import org.geysermc.geyser.api.event.bedrock.SessionDisconnectEvent;
import org.geysermc.geyser.api.event.bedrock.SessionLoginEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineCommandsEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserPostInitializeEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserRegisterPermissionsEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserShutdownEvent;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.extension.ExtensionLogger;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.session.GeyserSession;

public class GeyserBoar
implements Extension {
    private static ExtensionLogger logger;
    private static final Map<String, GeyserSession> nameToSessions;

    @Subscribe
    public void onSessionJoin(SessionLoginEvent event) {
        RakSessionCodec rakSessionCodec;
        BoarPlayer player = Boar.getInstance().getPlayerManager().add(event.connection());
        if (player == null) {
            return;
        }
        player.rakSessionCodec = rakSessionCodec = (RakSessionCodec)((RakChildChannel)player.getSession().getUpstream().getSession().getPeer().getChannel()).rakPipeline().get(RakSessionCodec.class);
        BoarAcknowledgement.getRakSessionToPlayer().put(player.rakSessionCodec, player);
        nameToSessions.put(event.connection().bedrockUsername(), (GeyserSession)event.connection());
    }

    @Subscribe
    public void onSessionLeave(SessionDisconnectEvent event) {
        BoarPlayer player = (BoarPlayer)Boar.getInstance().getPlayerManager().remove(event.connection());
        if (player == null) {
            return;
        }
        BoarAcknowledgement.getRakSessionToPlayer().remove(player.rakSessionCodec);
        nameToSessions.remove(event.connection().bedrockUsername());
    }

    @Subscribe
    public void onGeyserPostInitializeEvent(GeyserPostInitializeEvent event) {
        logger = this.logger();
        Boar.getInstance().init(this);
        if (Boar.getConfig().maxAcknowledgementTime() != -1L) {
            BoarInjector.injectToRak();
        }
    }

    @Subscribe
    public void onGeyserShutdown(GeyserShutdownEvent event) {
        Boar.getInstance().terminate(this);
    }

    @Subscribe
    public void onRegisterPermissions(GeyserRegisterPermissionsEvent event) {
        event.register("boar.exempt", TriState.FALSE);
        event.register("boar.alert", TriState.NOT_SET);
        event.register("boar.debug", TriState.NOT_SET);
        event.register("boar.reload", TriState.NOT_SET);
    }

    @Subscribe
    public void onDefineCommands(GeyserDefineCommandsEvent event) {
        event.register(Command.builder((Extension)this).source(CommandSource.class).name("reload").description("Reload the config for Boar.").permission("boar.reload").executor((source, cmd, args) -> {
            Boar.setConfig(ConfigLoader.load(this, GeyserBoar.class, Config.class, Config.DEFAULT_CONFIG));
            String prefix = Boar.getInstance().getAlertManager().getPrefix(source);
            source.sendMessage(prefix + "\u00a7fReloaded config! New config: " + String.valueOf(Boar.getConfig()));
        }).build());
        event.register(Command.builder((Extension)this).source(CommandSource.class).name("alert").description("Enable alert messages.").permission("boar.alert").executor((source, cmd, args) -> {
            AlertManager alertManager = Boar.getInstance().getAlertManager();
            String prefix = alertManager.getPrefix(source);
            if (alertManager.hasAlert(source)) {
                alertManager.removeAlert(source);
                source.sendMessage(prefix + "\u00a7fDisabled alerts.");
            } else {
                alertManager.addAlert(source);
                source.sendMessage(prefix + "\u00a7fEnabled alerts.");
            }
        }).build());
        event.register(Command.builder((Extension)this).source(CommandSource.class).name("debug").description("Enable prediction debug message.").permission("boar.debug").executor((source, cmd, args) -> {
            UUID uuid;
            if (args.length < 1) {
                return;
            }
            String prefix = Boar.getInstance().getAlertManager().getPrefix(source);
            GeyserSession session = nameToSessions.get(args[0]);
            BoarPlayer player = (BoarPlayer)Boar.getInstance().getPlayerManager().get(session);
            if (session == null || player == null) {
                source.sendMessage(prefix + "\u00a7cFailed to find player session.");
                return;
            }
            UUID uUID = uuid = source.isConsole() ? AlertManager.CONSOLE_UUID : source.playerUuid();
            if (player.getTrackedDebugPlayers().containsKey(uuid)) {
                player.getTrackedDebugPlayers().remove(uuid);
            } else {
                player.getTrackedDebugPlayers().put(uuid, source);
            }
        }).build());
    }

    @Generated
    public static ExtensionLogger getLogger() {
        return logger;
    }

    static {
        nameToSessions = new HashMap<String, GeyserSession>();
    }
}

