/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.utils.attributes;

import ac.boar.shaded.asm.Attribute;
import ac.boar.shaded.asm.ByteVector;
import ac.boar.shaded.asm.ClassWriter;
import ac.boar.shaded.asm.Type;
import ac.boar.shaded.classtransform.utils.attributes.AttributeAccessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class SharedVariableAttribute
extends Attribute {
    public static final String NAME = "ClassTransformSharedVariable";
    private final List<SharedVariable> variables = new ArrayList<SharedVariable>();

    public SharedVariableAttribute() {
        super(NAME);
    }

    public SharedVariableAttribute(Attribute attribute) throws IOException {
        this();
        Serializer.read(AttributeAccessor.getContent(attribute), this);
    }

    public SharedVariable addVariable(String transformer, String name, int index, Type type, boolean global) {
        SharedVariable sharedVariable = new SharedVariable(transformer, name, index, type, global);
        this.variables.add(sharedVariable);
        return sharedVariable;
    }

    @Nullable
    public SharedVariable getVariableIndex(String transformer, String name, boolean global) {
        for (SharedVariable variable : this.variables) {
            if (!variable.name.equals(name) || global != variable.global) continue;
            if (global) {
                return variable;
            }
            if (!variable.transformer.equals(transformer)) continue;
            return variable;
        }
        return null;
    }

    @Override
    protected ByteVector write(ClassWriter classWriter, byte[] code, int codeLength, int maxStack, int maxLocals) {
        return AttributeAccessor.newByteVector(Serializer.write(this));
    }

    private static class Serializer {
        private Serializer() {
        }

        public static byte[] write(SharedVariableAttribute attribute) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(attribute.variables.size());
            for (SharedVariable sharedVariable : attribute.variables) {
                dos.writeUTF(sharedVariable.getTransformer());
                dos.writeUTF(sharedVariable.getName());
                dos.writeInt(sharedVariable.getVariableIndex());
                dos.writeUTF(sharedVariable.getType().getInternalName());
                dos.writeBoolean(sharedVariable.isGlobal());
            }
            return baos.toByteArray();
        }

        public static SharedVariableAttribute read(byte[] data, SharedVariableAttribute attribute) throws IOException {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                String transformer = dis.readUTF();
                String name = dis.readUTF();
                int variableIndex = dis.readInt();
                Type type = Type.getObjectType(dis.readUTF());
                boolean global = dis.readBoolean();
                attribute.addVariable(transformer, name, variableIndex, type, global);
            }
            return attribute;
        }
    }

    public static class SharedVariable {
        private final String transformer;
        private final String name;
        private final int variableIndex;
        private final Type type;
        private final boolean global;

        private SharedVariable(String transformer, String name, int variableIndex, Type type, boolean global) {
            this.transformer = transformer;
            this.name = name;
            this.variableIndex = variableIndex;
            this.type = type;
            this.global = global;
        }

        public String getTransformer() {
            return this.transformer;
        }

        public String getName() {
            return this.name;
        }

        public int getVariableIndex() {
            return this.variableIndex;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isGlobal() {
            return this.global;
        }
    }
}

