/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.collision;

import ac.boar.anticheat.data.block.BoarBlockState;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.math.Box;
import java.util.ArrayList;
import java.util.List;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.ChestType;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.property.Property;
import org.geysermc.geyser.level.block.type.BedBlock;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.ChestBlock;
import org.geysermc.geyser.level.block.type.DoorBlock;
import org.geysermc.geyser.level.block.type.TrapDoorBlock;
import org.geysermc.geyser.level.physics.Axis;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.session.GeyserSession;

public class BedrockCollision {
    private static final List<Box> EMPTY_SHAPE = List.of();
    private static final List<Box> SOLID_SHAPE = List.of(new Box(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f));
    private static final List<Box> BED_SHAPE = List.of(new Box(0.0f, 0.0f, 0.0f, 1.0f, 0.5625f, 1.0f));
    private static final List<Box> HONEY_SHAPE = List.of(new Box(0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f));
    private static final List<Box> LECTERN_SHAPE = List.of(new Box(0.0f, 0.0f, 0.0f, 1.0f, 0.9f, 1.0f));
    private static final List<Box> CONDUIT_SHAPE = List.of(new Box(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f));
    private static final List<Box> CACTUS_SHAPE = List.of(new Box(0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f));
    private static final List<Box> SINGLE_CHEST_SHAPE = List.of(new Box(0.025f, 0.0f, 0.025f, 0.975f, 0.95f, 0.975f));
    private static final List<Box> NORTH_CHEST_SHAPE = List.of(new Box(0.025f, 0.0f, 0.0f, 0.975f, 0.95f, 0.975f));
    private static final List<Box> SOUTH_CHEST_SHAPE = List.of(new Box(0.025f, 0.0f, 0.025f, 0.975f, 0.95f, 1.0f));
    private static final List<Box> WEST_CHEST_SHAPE = List.of(new Box(0.0f, 0.0f, 0.025f, 0.975f, 0.95f, 0.975f));
    private static final List<Box> EAST_CHEST_SHAPE = List.of(new Box(0.025f, 0.0f, 0.025f, 1.0f, 0.95f, 0.975f));
    private static final List<Box> SCAFFOLDING_NORMAL_SHAPE;
    private static final List<Box> CAULDRON_SHAPE;
    private static final List<Box> TRAPDOOR_EAST_SHAPE;
    private static final List<Box> TRAPDOOR_WEST_SHAPE;
    private static final List<Box> TRAPDOOR_SOUTH_SHAPE;
    private static final List<Box> TRAPDOOR_NORTH_SHAPE;
    private static final List<Box> TRAPDOOR_OPEN_BOTTOM_SHAPE;
    private static final List<Box> TRAPDOOR_OPEN_TOP_SHAPE;
    private static final List<Box> DOOR_NORTH_SHAPE;
    private static final List<Box> DOOR_SOUTH_SHAPE;
    private static final List<Box> DOOR_EAST_SHAPE;
    private static final List<Box> DOOR_WEST_SHAPE;
    private static final List<Box> LANTERN_SHAPE;
    private static final List<Box> ANVIL_X_SHAPE;
    private static final List<Box> ANVIL_OTHER_SHAPE;
    private static final List<Box> FALLING_POWDER_SNOW_SNOW;

    public static List<Box> getCollisionBox(BoarPlayer player, Box box, Vector3i vector3i, BlockState state) {
        if (vector3i.getY() == player.compensatedWorld.getDimension().minY() - 41) {
            return SOLID_SHAPE;
        }
        if (state.is(Blocks.BAMBOO)) {
            Box baseShape;
            Box box2 = baseShape = ((String)((Object)state.getValue((Property)Properties.BAMBOO_LEAVES))).equalsIgnoreCase("small") ? new Box(0.0f, 0.0f, 0.0f, 0.125f, 1.0f, 0.125f) : new Box(0.0f, 0.0f, 0.0f, 0.1875f, 1.0f, 0.1875f);
            if (!GameProtocol.is1_21_80orHigher((GeyserSession)player.getSession())) {
                return List.of(baseShape.offset(new BoarBlockState(state, vector3i, 0).pre12180RandomOffset()));
            }
            if (!player.getInputData().contains(PlayerAuthInputData.VERTICAL_COLLISION) || box == null) {
                return EMPTY_SHAPE;
            }
            Box solidOffset = SOLID_SHAPE.get(0).offset(vector3i.getX(), vector3i.getY(), vector3i.getZ());
            boolean likelyYCollision = solidOffset.calculateMaxDistance(Axis.Y, player.boundingBox, player.velocity.y) != player.velocity.y;
            return likelyYCollision && solidOffset.intersects(box) ? SOLID_SHAPE : EMPTY_SHAPE;
        }
        if (state.is(Blocks.POWDER_SNOW)) {
            boolean leatherBoostOn;
            boolean bl = leatherBoostOn = player.compensatedInventory.translate(player.compensatedInventory.armorContainer.get(3).getData()).getId() == Items.LEATHER_BOOTS.javaId();
            if (leatherBoostOn && player.position.y > (float)(vector3i.getY() + 1) - 1.0E-5f && !player.getInputData().contains(PlayerAuthInputData.SNEAKING) && !player.getInputData().contains(PlayerAuthInputData.DESCEND_BLOCK)) {
                return SOLID_SHAPE;
            }
        }
        if (state.is(Blocks.ANVIL) || state.is(Blocks.DAMAGED_ANVIL) || state.is(Blocks.CHIPPED_ANVIL)) {
            Direction direction = (Direction)state.getValue((Property)Properties.HORIZONTAL_FACING);
            if (direction.getAxis() == Axis.X) {
                return ANVIL_X_SHAPE;
            }
            return ANVIL_OTHER_SHAPE;
        }
        if (state.is(Blocks.LANTERN) || state.is(Blocks.SOUL_LANTERN)) {
            return LANTERN_SHAPE;
        }
        if (state.is(Blocks.ENDER_CHEST)) {
            return SINGLE_CHEST_SHAPE;
        }
        if (state.is(Blocks.SEA_PICKLE)) {
            return EMPTY_SHAPE;
        }
        if (state.block() instanceof BedBlock) {
            return BED_SHAPE;
        }
        if (state.is(Blocks.HONEY_BLOCK)) {
            return HONEY_SHAPE;
        }
        if (state.is(Blocks.LECTERN)) {
            return LECTERN_SHAPE;
        }
        if (state.is(Blocks.CAULDRON) || state.is(Blocks.WATER_CAULDRON) || state.is(Blocks.LAVA_CAULDRON) || state.is(Blocks.POWDER_SNOW_CAULDRON)) {
            return CAULDRON_SHAPE;
        }
        if (state.is(Blocks.CONDUIT)) {
            return CONDUIT_SHAPE;
        }
        if (state.is(Blocks.CACTUS)) {
            return CACTUS_SHAPE;
        }
        if (state.block() instanceof ChestBlock) {
            ChestType type = (ChestType)state.getValue((Property)Properties.CHEST_TYPE);
            Direction facing = (Direction)state.getValue((Property)Properties.HORIZONTAL_FACING);
            if (type == ChestType.LEFT) {
                facing = switch (facing) {
                    case Direction.SOUTH -> Direction.WEST;
                    case Direction.WEST -> Direction.NORTH;
                    case Direction.EAST -> Direction.SOUTH;
                    default -> Direction.EAST;
                };
            } else {
                switch (facing) {
                    case SOUTH: {
                        Direction direction = Direction.EAST;
                        break;
                    }
                    case WEST: {
                        Direction direction = Direction.SOUTH;
                        break;
                    }
                    case EAST: {
                        Direction direction = Direction.NORTH;
                        break;
                    }
                    default: {
                        Direction direction = facing = Direction.WEST;
                    }
                }
            }
            if (type == ChestType.SINGLE) {
                return SINGLE_CHEST_SHAPE;
            }
            switch (facing) {
                case SOUTH: {
                    return SOUTH_CHEST_SHAPE;
                }
                case WEST: {
                    return WEST_CHEST_SHAPE;
                }
                case EAST: {
                    return EAST_CHEST_SHAPE;
                }
            }
            return NORTH_CHEST_SHAPE;
        }
        if (state.block() instanceof TrapDoorBlock) {
            if (!((Boolean)state.getValue((Property)Properties.OPEN)).booleanValue()) {
                return ((String)((Object)state.getValue((Property)Properties.HALF))).equalsIgnoreCase("top") ? TRAPDOOR_OPEN_TOP_SHAPE : TRAPDOOR_OPEN_BOTTOM_SHAPE;
            }
            switch ((Direction)state.getValue((Property)Properties.HORIZONTAL_FACING)) {
                case SOUTH: {
                    return TRAPDOOR_SOUTH_SHAPE;
                }
                case WEST: {
                    return TRAPDOOR_WEST_SHAPE;
                }
                case EAST: {
                    return TRAPDOOR_EAST_SHAPE;
                }
            }
            return TRAPDOOR_NORTH_SHAPE;
        }
        if (state.block() instanceof DoorBlock) {
            Direction direction = (Direction)state.getValue((Property)Properties.HORIZONTAL_FACING);
            boolean bl = (Boolean)state.getValue((Property)Properties.OPEN) == false;
            boolean bl2 = ((String)((Object)state.getValue((Property)Properties.DOOR_HINGE))).equalsIgnoreCase("right");
            switch (direction) {
                case SOUTH: {
                    return bl ? DOOR_NORTH_SHAPE : (bl2 ? DOOR_WEST_SHAPE : DOOR_EAST_SHAPE);
                }
                case WEST: {
                    return bl ? DOOR_EAST_SHAPE : (bl2 ? DOOR_NORTH_SHAPE : DOOR_SOUTH_SHAPE);
                }
                case NORTH: {
                    return bl ? DOOR_SOUTH_SHAPE : (bl2 ? DOOR_EAST_SHAPE : DOOR_WEST_SHAPE);
                }
            }
            return bl ? DOOR_WEST_SHAPE : (bl2 ? DOOR_SOUTH_SHAPE : DOOR_NORTH_SHAPE);
        }
        if (state.is(Blocks.SCAFFOLDING)) {
            boolean above;
            boolean bl = above = player.boundingBox.minY > (float)(vector3i.getY() + 1) - 1.0E-5f;
            if (above && !player.getInputData().contains(PlayerAuthInputData.WANT_DOWN)) {
                return SCAFFOLDING_NORMAL_SHAPE;
            }
            return EMPTY_SHAPE;
        }
        return null;
    }

    static {
        TRAPDOOR_EAST_SHAPE = List.of(new Box(0.0f, 0.0f, 0.0f, 0.1825f, 1.0f, 1.0f));
        TRAPDOOR_WEST_SHAPE = List.of(new Box(0.8175f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f));
        TRAPDOOR_SOUTH_SHAPE = List.of(new Box(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.1825f));
        TRAPDOOR_NORTH_SHAPE = List.of(new Box(0.0f, 0.0f, 0.8175f, 1.0f, 1.0f, 1.0f));
        TRAPDOOR_OPEN_BOTTOM_SHAPE = List.of(new Box(0.0f, 0.0f, 0.0f, 1.0f, 0.1825f, 1.0f));
        TRAPDOOR_OPEN_TOP_SHAPE = List.of(new Box(0.0f, 0.8175f, 0.0f, 1.0f, 1.0f, 1.0f));
        DOOR_NORTH_SHAPE = List.of(new Box(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.1825f));
        DOOR_SOUTH_SHAPE = List.of(new Box(0.0f, 0.0f, 0.8175f, 1.0f, 1.0f, 1.0f));
        DOOR_EAST_SHAPE = List.of(new Box(0.8175f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f));
        DOOR_WEST_SHAPE = List.of(new Box(0.0f, 0.0f, 0.0f, 0.1825f, 1.0f, 1.0f));
        LANTERN_SHAPE = List.of(new Box(0.3125f, 0.0f, 0.3125f, 0.6875f, 0.5f, 0.6875f));
        ANVIL_X_SHAPE = List.of(new Box(0.0f, 0.0f, 0.125f, 1.0f, 1.0f, 0.875f));
        ANVIL_OTHER_SHAPE = List.of(new Box(0.125f, 0.0f, 0.0f, 0.875f, 1.0f, 1.0f));
        FALLING_POWDER_SNOW_SNOW = List.of(new Box(0.0f, 0.0f, 0.0f, 0.0625f, 0.05625f, 0.0625f));
        Box lv = new Box(0.0f, 0.875f, 0.0f, 1.0f, 1.0f, 1.0f);
        Box lv2 = new Box(0.0f, 0.0f, 0.0f, 0.125f, 1.0f, 0.125f);
        Box lv3 = new Box(0.875f, 0.0f, 0.0f, 1.0f, 1.0f, 0.125f);
        Box lv4 = new Box(0.0f, 0.0f, 0.875f, 0.125f, 1.0f, 1.0f);
        Box lv5 = new Box(0.875f, 0.0f, 0.875f, 1.0f, 1.0f, 1.0f);
        SCAFFOLDING_NORMAL_SHAPE = List.of(lv, lv2, lv3, lv4, lv5);
        float f = 0.125f;
        ArrayList<Box> boxes = new ArrayList<Box>();
        boxes.add(new Box(0.0f, 0.0f, 0.0f, 1.0f, 0.3125f, 1.0f));
        boxes.add(new Box(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f));
        boxes.add(new Box(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f));
        boxes.add(new Box(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f));
        boxes.add(new Box(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f));
        CAULDRON_SHAPE = boxes;
    }
}

