/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.compensated.world;

import ac.boar.anticheat.collision.util.CuboidBlockIterator;
import ac.boar.anticheat.compensated.cache.entity.EntityCache;
import ac.boar.anticheat.compensated.world.base.CompensatedWorld;
import ac.boar.anticheat.data.FluidState;
import ac.boar.anticheat.data.block.BoarBlockState;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.math.Box;
import ac.boar.anticheat.util.math.Mutable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.Fluid;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.property.Property;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.session.GeyserSession;

public class CompensatedWorldImpl
extends CompensatedWorld {
    public CompensatedWorldImpl(BoarPlayer player) {
        super(player);
    }

    public boolean noCollision(Box aabb) {
        return this.collectColliders(this.getEntityCollisions(aabb), aabb).isEmpty();
    }

    public FluidState getFluidState(Vector3i vec3) {
        return this.getFluidState(vec3.getX(), vec3.getY(), vec3.getZ());
    }

    public FluidState getFluidState(Mutable mutable) {
        return this.getFluidState(mutable.getX(), mutable.getY(), mutable.getZ());
    }

    public FluidState getFluidState(int x, int y, int z) {
        if (this.getBlockState(x, y, z, 1).getState().is(Blocks.WATER)) {
            return new FluidState(Fluid.WATER, 0.8888889f, 8);
        }
        BlockState state = this.getBlockState(x, y, z, 0).getState();
        boolean water = state.is(Blocks.WATER);
        if (!water && !state.is(Blocks.LAVA)) {
            return new FluidState(Fluid.EMPTY, 0.0f, 0);
        }
        Fluid fluid = water ? Fluid.WATER : Fluid.LAVA;
        int rawLevel = (Integer)state.getValue((Property)Properties.LEVEL);
        if (rawLevel == 0 || rawLevel == 8) {
            return new FluidState(fluid, 0.8888889f, rawLevel);
        }
        return new FluidState(fluid, (float)(8 - rawLevel) / 9.0f, rawLevel);
    }

    public List<Box> collectColliders(List<Box> list, Box aABB) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(list.size() + 1));
        if (!list.isEmpty()) {
            builder.addAll(list);
        }
        boolean needToDoBambooHacks = GameProtocol.is1_21_80orHigher((GeyserSession)this.getPlayer().getSession());
        CuboidBlockIterator iterator = CuboidBlockIterator.iterator(aABB);
        while (iterator.step()) {
            int x = iterator.getX();
            int y = iterator.getY();
            int z = iterator.getZ();
            if (!this.isChunkLoaded(x, z)) continue;
            BoarBlockState state = this.getBlockState(x, y, z, 0);
            if (state.getState().is(Blocks.BAMBOO) && new Box(x, y, z, x + 1, y + 1, z + 1).intersects(aABB)) {
                this.getPlayer().nearBamboo = needToDoBambooHacks;
            }
            builder.addAll(state.findCollision(this.getPlayer(), Vector3i.from((int)x, (int)y, (int)z), aABB, true));
        }
        return builder.build();
    }

    public List<Box> getEntityCollisions(Box aABB) {
        ArrayList<Box> boxes = new ArrayList<Box>();
        aABB = aABB.expand(1.0E-7f);
        for (EntityCache cache : this.getEntities().values()) {
            if (cache.getMetadata().getFlags() == null || !cache.getMetadata().getFlags().contains(EntityFlag.COLLIDABLE) || !aABB.intersects(cache.getCurrent().getBoundingBox())) continue;
            boxes.add(cache.getCurrent().getBoundingBox());
        }
        return boxes;
    }

    public boolean hasChunksAt(int i, int j, int k, int l) {
        for (int q = i; q <= k; ++q) {
            for (int r = j; r <= l; ++r) {
                if (this.isChunkLoaded(q, r)) continue;
                return false;
            }
        }
        return true;
    }
}

