/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.config;

import ac.boar.anticheat.config.Config;
import ac.boar.shaded.jackson.databind.DeserializationFeature;
import ac.boar.shaded.jackson.databind.ObjectMapper;
import ac.boar.shaded.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import org.geysermc.geyser.api.extension.Extension;

public class ConfigLoader {
    public static <T> T load(Extension extension, Class<?> extensionClass, Class<T> configClass, T defaultConfig) {
        File configFile = extension.dataFolder().resolve("config.yml").toFile();
        if (!extension.dataFolder().toFile().exists() && !extension.dataFolder().toFile().mkdirs()) {
            extension.logger().error("Failed to create data folder");
            return defaultConfig;
        }
        if (!configFile.exists() && ConfigLoader.writeConfigFile(configFile, extensionClass, extension, null)) {
            return defaultConfig;
        }
        try {
            return new ObjectMapper(new YAMLFactory()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES).disable(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES).readValue(configFile, configClass);
        }
        catch (Exception e) {
            extension.logger().error("Failed to load config (possible update?), loading the default config...");
            return defaultConfig;
        }
    }

    public static void save(Extension extension, Class<?> extensionClass, Config config) {
        File configFile = extension.dataFolder().resolve("config.yml").toFile();
        ConfigLoader.writeConfigFile(configFile, extensionClass, extension, config);
    }

    private static boolean writeConfigFile(File configFile, Class<?> extensionClass, Extension extension, Config config) {
        try (FileWriter writer = new FileWriter(configFile);
             FileSystem fileSystem = FileSystems.newFileSystem(new File(extensionClass.getProtectionDomain().getCodeSource().getLocation().toURI()).toPath(), Collections.emptyMap());
             InputStream input = Files.newInputStream(fileSystem.getPath("config.yml", new String[0]), new OpenOption[0]);){
            byte[] bytes = new byte[input.available()];
            input.read(bytes);
            String s = new String(bytes);
            if (config != null) {
                s = s.replace("player-rewind-history-size-ticks: 20", "player-rewind-history-size-ticks: " + config.rewindHistory());
                s = s.replace("player-position-acceptance-threshold: 1.0E-4", "player-position-acceptance-threshold: " + config.acceptanceThreshold());
                s = s.replace("max-tolerance-compensated-reach: 3.005", "max-tolerance-compensated-reach: " + config.toleranceReach());
                s = s.replace("disabled-checks: []", "disabled-checks: " + Arrays.toString(config.disabledChecks().toArray(new String[0])));
                s = s.replace("ignore-ghost-block: false", "ignore-ghost-block: " + config.ignoreGhostBlock());
                s = s.replace("differ-till-alert: 0.0", "differ-till-alert: " + config.alertThreshold());
                s = s.replace("debug-mode: false", "debug-mode: " + config.debugMode());
                s = s.replace("force-reach-java-parity: \"bedrock\"", "force-reach-java-parity: \"" + config.reachJavaParityMode() + "\"");
                s = s.replace("max-acknowledgement-time: 500", "max-acknowledgement-time: " + config.maxAcknowledgementTime());
            }
            writer.write(s.toCharArray());
            writer.flush();
        }
        catch (IOException | URISyntaxException e) {
            extension.logger().error("Failed to create config", (Throwable)e);
            return false;
        }
        return true;
    }
}

