/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.data;

import ac.boar.anticheat.player.BoarPlayer;
import lombok.Generated;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.item.Items;

public class ItemUseTracker {
    private final BoarPlayer player;
    private ItemData usedItem = ItemData.AIR;
    private int javaItemId = -1;
    private boolean dirtyUsing;

    public void preTick() {
        if (!this.player.getFlagTracker().has(EntityFlag.USING_ITEM)) {
            return;
        }
        if (this.javaItemId == Items.TRIDENT.javaId()) {
            ++this.player.sinceTridentUse;
        }
    }

    public void postTick() {
        if (!this.player.getFlagTracker().has(EntityFlag.USING_ITEM)) {
            if (this.usedItem != ItemData.AIR || this.javaItemId != -1) {
                this.release();
            }
            return;
        }
        if (this.usedItem == ItemData.AIR || this.javaItemId == -1) {
            this.release();
            return;
        }
        if (!this.player.compensatedInventory.inventoryContainer.getHeldItemData().equals(this.usedItem, false, false, false)) {
            this.release();
        }
    }

    public void release() {
        this.usedItem = ItemData.AIR;
        this.javaItemId = -1;
        this.player.sinceTridentUse = 0;
        this.player.getFlagTracker().set(EntityFlag.USING_ITEM, false);
    }

    public void use(ItemData usedItem, int itemId) {
        if (!this.canBeUse(usedItem, itemId)) {
            return;
        }
        this.usedItem = usedItem;
        this.javaItemId = itemId;
        this.dirtyUsing = true;
        this.player.sinceTridentUse = 0;
    }

    private boolean canBeUse(ItemData usedItem, int itemId) {
        try {
            NbtMap map = usedItem.getDefinition().getComponentData();
            if (map != null) {
                NbtMap components = map.getCompound("components");
                if (components == null) {
                    return true;
                }
                if (components.containsKey((Object)"minecraft:use_duration")) {
                    return true;
                }
                NbtMap itemProperties = components.getCompound("item_properties");
                if (itemProperties.containsKey((Object)"use_duration")) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return itemId == Items.BOW.javaId() || itemId == Items.CROSSBOW.javaId() || itemId == Items.TRIDENT.javaId() || itemId == Items.ENDER_EYE.javaId() || itemId == Items.SPYGLASS.javaId();
    }

    @Generated
    public ItemUseTracker(BoarPlayer player) {
        this.player = player;
    }

    @Generated
    public BoarPlayer getPlayer() {
        return this.player;
    }

    @Generated
    public ItemData getUsedItem() {
        return this.usedItem;
    }

    @Generated
    public int getJavaItemId() {
        return this.javaItemId;
    }

    @Generated
    public boolean isDirtyUsing() {
        return this.dirtyUsing;
    }

    @Generated
    public void setUsedItem(ItemData usedItem) {
        this.usedItem = usedItem;
    }

    @Generated
    public void setJavaItemId(int javaItemId) {
        this.javaItemId = javaItemId;
    }

    @Generated
    public void setDirtyUsing(boolean dirtyUsing) {
        this.dirtyUsing = dirtyUsing;
    }
}

