/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.packets.input.legacy;

import ac.boar.anticheat.check.api.Check;
import ac.boar.anticheat.check.api.impl.OffsetHandlerCheck;
import ac.boar.anticheat.collision.Collider;
import ac.boar.anticheat.compensated.cache.container.ContainerCache;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.prediction.UncertainRunner;
import ac.boar.anticheat.prediction.engine.data.VectorType;
import ac.boar.anticheat.util.InputUtil;
import ac.boar.anticheat.util.MathUtil;
import ac.boar.anticheat.util.math.Box;
import ac.boar.anticheat.util.math.Vec3;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cloudburstmc.protocol.bedrock.data.Ability;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.geyser.item.Items;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class LegacyAuthInputPackets {
    public static void updateUnvalidatedPosition(BoarPlayer player, PlayerAuthInputPacket packet) {
        player.prevUnvalidatedPosition = player.unvalidatedPosition.clone();
        player.unvalidatedPosition = new Vec3(packet.getPosition().sub(0.0f, player.getYOffset(), 0.0f));
        player.unvalidatedTickEnd = new Vec3(packet.getDelta());
    }

    public static void doPostPrediction(BoarPlayer player, PlayerAuthInputPacket packet) {
        List<Box> collisions;
        player.postTick();
        player.getTeleportUtil().cachePosition(player.tick, player.position.add(0.0f, player.getYOffset(), 0.0f).toVector3f());
        UncertainRunner uncertainRunner = new UncertainRunner(player);
        float offset = player.position.distanceTo(player.unvalidatedPosition);
        float extraOffset = uncertainRunner.extraOffset(offset);
        offset -= extraOffset;
        offset -= uncertainRunner.extraOffsetNonTickEnd(offset);
        for (Map.Entry entry : player.getCheckHolder().entrySet()) {
            Check v = (Check)entry.getValue();
            if (!(v instanceof OffsetHandlerCheck)) continue;
            OffsetHandlerCheck check = (OffsetHandlerCheck)v;
            check.onPredictionComplete(offset);
        }
        if (player.velocity.distanceTo(player.unvalidatedTickEnd) - extraOffset < player.getMaxOffset()) {
            player.velocity = player.unvalidatedTickEnd.clone();
        }
        LegacyAuthInputPackets.correctInputData(player, packet);
        if (offset < player.getMaxOffset()) {
            player.setPos(player.unvalidatedPosition.clone(), false);
        }
        if (!(collisions = player.compensatedWorld.collectColliders(new ArrayList<Box>(), player.boundingBox)).isEmpty()) {
            Vec3 offsetVec = Collider.moveOutOfBlocks(player.boundingBox.clone(), collisions);
            float offsetX = Math.min(0.01f, Math.abs(offsetVec.x)) * MathUtil.sign(offsetVec.x);
            float offsetY = Math.min(0.01f, Math.abs(offsetVec.y)) * MathUtil.sign(offsetVec.y);
            float offsetZ = Math.min(0.01f, Math.abs(offsetVec.z)) * MathUtil.sign(offsetVec.z);
            player.setPos(player.position.add(offsetX, offsetY, offsetZ), false);
        }
        if (player.bestPossibility.getType() == VectorType.VELOCITY) {
            Map.Entry entry;
            Iterator iterator = player.queuedVelocities.entrySet().iterator();
            while (iterator.hasNext() && (entry = iterator.next()) != null && (Long)entry.getKey() <= player.bestPossibility.getStackId()) {
                iterator.remove();
            }
        }
        player.prevPosition = player.position;
    }

    public static void correctInputData(BoarPlayer player, PlayerAuthInputPacket packet) {
        if (player.isMovementExempted()) {
            return;
        }
        packet.getInputData().remove(PlayerAuthInputData.HORIZONTAL_COLLISION);
        packet.getInputData().remove(PlayerAuthInputData.VERTICAL_COLLISION);
        if (player.horizontalCollision) {
            packet.getInputData().add(PlayerAuthInputData.HORIZONTAL_COLLISION);
        }
        if (player.verticalCollision) {
            packet.getInputData().add(PlayerAuthInputData.VERTICAL_COLLISION);
        }
        packet.setDelta(player.velocity.toVector3f());
    }

    public static void processAuthInput(BoarPlayer player, PlayerAuthInputPacket packet, boolean processInputData) {
        player.setInputData(packet.getInputData());
        InputUtil.processInput(player, packet);
        player.prevYaw = player.yaw;
        player.prevPitch = player.pitch;
        player.yaw = packet.getRotation().getY();
        player.pitch = packet.getRotation().getX();
        player.rotation = packet.getRotation();
        player.interactRotation = packet.getInteractRotation().clone();
        player.inputMode = packet.getInputMode();
        if (processInputData) {
            LegacyAuthInputPackets.processInputData(player);
            if (player.input.z <= 0.0f && player.getFlagTracker().has(EntityFlag.SPRINTING) && player.desyncedFlag.get() == -1L) {
                player.getFlagTracker().set(EntityFlag.SPRINTING, false);
                packet.getInputData().add(PlayerAuthInputData.STOP_SPRINTING);
            }
        }
    }

    public static void processInputData(BoarPlayer player) {
        if (!player.getFlagTracker().has(EntityFlag.USING_ITEM)) {
            player.sinceTridentUse = 0;
        }
        for (PlayerAuthInputData input : player.getInputData()) {
            switch (input) {
                case START_GLIDING: {
                    ContainerCache cache = player.compensatedInventory.armorContainer;
                    player.getFlagTracker().set(EntityFlag.GLIDING, player.compensatedInventory.translate(cache.get(1).getData()).getId() == Items.ELYTRA.javaId());
                    break;
                }
                case STOP_GLIDING: {
                    player.getFlagTracker().set(EntityFlag.GLIDING, false);
                    break;
                }
                case START_SPRINTING: {
                    player.setSprinting(player.input.getZ() > 0.0f);
                    break;
                }
                case STOP_SPRINTING: {
                    player.setSprinting(false);
                    break;
                }
                case START_SNEAKING: {
                    player.getFlagTracker().set(EntityFlag.SNEAKING, true);
                    break;
                }
                case STOP_SNEAKING: {
                    player.getFlagTracker().set(EntityFlag.SNEAKING, false);
                    break;
                }
                case START_SWIMMING: {
                    player.getFlagTracker().set(EntityFlag.SWIMMING, true);
                    break;
                }
                case STOP_SWIMMING: {
                    player.getFlagTracker().set(EntityFlag.SWIMMING, false);
                    break;
                }
                case START_FLYING: {
                    player.getFlagTracker().setFlying(player.abilities.contains(Ability.MAY_FLY) || player.abilities.contains(Ability.FLYING));
                    break;
                }
                case STOP_FLYING: {
                    player.getFlagTracker().setFlying(false);
                    break;
                }
                case STOP_SPIN_ATTACK: {
                    if (!player.dirtySpinStop) break;
                    player.stopRiptide();
                    player.velocity = player.velocity.multiply(-0.2f);
                    break;
                }
                case START_USING_ITEM: {
                    ItemData itemData = player.compensatedInventory.inventoryContainer.getHeldItemData();
                    ItemStack item = player.compensatedInventory.translate(itemData);
                    player.getFlagTracker().set(EntityFlag.USING_ITEM, true);
                    player.getItemUseTracker().use(itemData, item.getId());
                    player.getItemUseTracker().setDirtyUsing(false);
                    break;
                }
                case START_CRAWLING: {
                    player.getFlagTracker().set(EntityFlag.CRAWLING, true);
                    break;
                }
                case STOP_CRAWLING: {
                    player.getFlagTracker().set(EntityFlag.CRAWLING, false);
                }
            }
        }
        if (player.getItemUseTracker().isDirtyUsing()) {
            player.getItemUseTracker().setDirtyUsing(false);
            player.getSession().releaseItem();
        }
        player.dirtySpinStop = false;
    }
}

