/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.packets.server;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.compensated.world.CompensatedWorldImpl;
import ac.boar.anticheat.compensated.world.base.CompensatedWorld;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.DimensionUtil;
import ac.boar.anticheat.util.geyser.BlockStorage;
import ac.boar.anticheat.util.geyser.BoarChunkSection;
import ac.boar.protocol.event.CloudburstPacketEvent;
import ac.boar.protocol.listener.PacketListener;
import ac.boar.shaded.fastutil.ints.IntArrayList;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.protocol.bedrock.data.ServerboundLoadingScreenPacketType;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelChunkPacket;
import org.cloudburstmc.protocol.bedrock.packet.ServerboundLoadingScreenPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.cloudburstmc.protocol.common.util.VarInts;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.chunk.bitarray.BitArray;
import org.geysermc.geyser.level.chunk.bitarray.BitArrayVersion;
import org.geysermc.geyser.level.chunk.bitarray.SingletonBitArray;

public class ServerChunkPackets
implements PacketListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPacketSend(CloudburstPacketEvent event, boolean immediate) {
        BedrockPacket sectionCount2;
        LevelChunkPacket packet;
        BoarPlayer player = event.getPlayer();
        CompensatedWorldImpl world = player.compensatedWorld;
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof LevelChunkPacket) {
            packet = (LevelChunkPacket)bedrockPacket;
            int sectionCount2 = packet.getSubChunksLength();
            if (sectionCount2 == -2) {
                return;
            }
            if (sectionCount2 == 0) {
                return;
            }
            int dimensionId = packet.getDimension();
            if (dimensionId < 0 || dimensionId > 2) {
                return;
            }
            int yOffset = world.getMinY() >> 4;
            int chunkSize = world.getHeightY() >> 4;
            BedrockDimension dimension = DimensionUtil.dimensionFromId(dimensionId);
            int dimensionOffset = dimension.minY() >> 4;
            BoarChunkSection[] sections = new BoarChunkSection[dimension.height() >> 4];
            ByteBuf buffer = packet.getData().copy();
            try {
                for (int i = 0; i < sectionCount2; ++i) {
                    int n;
                    buffer.readByte();
                    int storageLength = buffer.readUnsignedByte();
                    short subChunkIndex = buffer.readUnsignedByte();
                    BlockStorage[] storages = new BlockStorage[Math.max(storageLength, 2)];
                    for (n = 0; n < storageLength; ++n) {
                        storages[n] = this.readStorage(buffer, player.BEDROCK_AIR);
                    }
                    for (n = 0; n < storages.length; ++n) {
                        if (storages[n] != null) continue;
                        if (n == 1) {
                            IntArrayList list = new IntArrayList(1);
                            list.add(player.BEDROCK_AIR);
                            storages[n] = new BlockStorage(BitArrayVersion.V0.createArray(4096, null), list);
                            continue;
                        }
                        storages[n] = new BlockStorage(player.BEDROCK_AIR, BitArrayVersion.V2);
                    }
                    sections[i] = new BoarChunkSection(storages, (int)subChunkIndex);
                }
                int biomeCount = dimension.height() >> 4;
                for (int i = 0; i < biomeCount; ++i) {
                    int biomeYOffset = dimensionOffset + i;
                    if (biomeYOffset < yOffset) {
                        buffer.skipBytes(1);
                        continue;
                    }
                    if (biomeYOffset >= chunkSize + yOffset) {
                        buffer.skipBytes(1);
                        continue;
                    }
                    this.readStorage(buffer, player.BEDROCK_AIR);
                }
                buffer.skipBytes(1);
            }
            catch (Exception exception) {
            }
            finally {
                buffer.release();
            }
            player.sendLatencyStack(immediate);
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> {
                if (dimension != world.getDimension()) {
                    return;
                }
                world.addToCache(packet.getChunkX(), packet.getChunkZ(), sections);
            });
        }
        if ((sectionCount2 = event.getPacket()) instanceof UpdateBlockPacket) {
            packet = (UpdateBlockPacket)sectionCount2;
            if (packet.getDataLayer() == 0 && Boar.getConfig().ignoreGhostBlock() && !player.inLoadingScreen && player.sinceLoadingScreen >= 2) {
                int distance;
                boolean newBlockIsAir;
                BlockState state = BlockState.of((int)player.bedrockBlockToJava.getOrDefault(packet.getDefinition().getRuntimeId(), Blocks.AIR.javaId()));
                boolean bl = newBlockIsAir = state.is(Blocks.AIR) || state.is(Blocks.CAVE_AIR) || state.is(Blocks.VOID_AIR);
                if (newBlockIsAir && !player.compensatedWorld.getBlockState(packet.getBlockPosition(), packet.getDataLayer()).isAir() && (distance = Math.abs(packet.getBlockPosition().getY() - GenericMath.floor((float)(player.position.y - 1.0f)))) <= 1) {
                    player.tickSinceBlockResync = 5;
                    world.updateBlock(packet.getBlockPosition(), packet.getDataLayer(), packet.getDefinition().getRuntimeId());
                }
            }
            player.sendLatencyStack(immediate);
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> ServerChunkPackets.lambda$onPacketSend$1(world, (UpdateBlockPacket)packet));
        }
    }

    @Override
    public void onPacketReceived(CloudburstPacketEvent event) {
        ServerboundLoadingScreenPacket packet;
        BoarPlayer player = event.getPlayer();
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof ServerboundLoadingScreenPacket && (packet = (ServerboundLoadingScreenPacket)bedrockPacket).getType() == ServerboundLoadingScreenPacketType.END_LOADING_SCREEN && Objects.equals(player.currentLoadingScreen, packet.getLoadingScreenId())) {
            player.currentLoadingScreen = null;
            player.inLoadingScreen = false;
            player.sinceLoadingScreen = 0;
        }
    }

    private BlockStorage readStorage(ByteBuf buffer, int airId) {
        short header = buffer.readUnsignedByte();
        int bitArrayVersion = header >> 1;
        if (bitArrayVersion == 127) {
            return null;
        }
        BitArray bitArray = bitArrayVersion == 0 ? BitArrayVersion.get((int)bitArrayVersion, (boolean)true).createArray(4096, null) : BitArrayVersion.get((int)bitArrayVersion, (boolean)true).createArray(4096);
        if (!(bitArray instanceof SingletonBitArray)) {
            for (int i = 0; i < bitArray.getWords().length; ++i) {
                bitArray.getWords()[i] = buffer.readIntLE();
            }
        }
        int size = bitArray instanceof SingletonBitArray ? 1 : VarInts.readInt((ByteBuf)buffer);
        IntArrayList palette = new IntArrayList(size);
        for (int i = 0; i < size; ++i) {
            palette.add(VarInts.readInt((ByteBuf)buffer));
        }
        if (palette.isEmpty()) {
            palette.add(airId);
        }
        return new BlockStorage(bitArray, palette);
    }

    private static /* synthetic */ void lambda$onPacketSend$1(CompensatedWorld world, UpdateBlockPacket packet) {
        world.updateBlock(packet.getBlockPosition(), packet.getDataLayer(), packet.getDefinition().getRuntimeId());
    }
}

