/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.prediction.engine.impl;

import ac.boar.anticheat.data.vanilla.StatusEffect;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.prediction.engine.base.PredictionEngine;
import ac.boar.anticheat.prediction.engine.data.VectorType;
import ac.boar.anticheat.util.block.specific.PowderSnowBlock;
import ac.boar.anticheat.util.math.Vec3;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;

public class GroundAndAirPredictionEngine
extends PredictionEngine {
    private float prevSlipperiness = 0.6f;

    public GroundAndAirPredictionEngine(BoarPlayer player) {
        super(player);
    }

    @Override
    public Vec3 travel(Vec3 vec3) {
        Vector3i blockPos = this.player.getBlockPosBelowThatAffectsMyMovement();
        this.prevSlipperiness = this.player.onGround ? this.player.compensatedWorld.getBlockState(blockPos, 0).getFriction() : 1.0f;
        return this.halfRelativeMovementCalculate(vec3, this.prevSlipperiness);
    }

    @Override
    public void finalizeMovement() {
        if (!this.player.scaffoldDescend) {
            StatusEffect effect = this.player.getEffect(Effect.LEVITATION);
            this.player.velocity.y = effect != null ? (this.player.velocity.y += (0.05f * (float)(effect.getAmplifier() + 1) - this.player.velocity.y) * 0.2f) : (this.player.compensatedWorld.isChunkLoaded((int)this.player.position.x, (int)this.player.position.z) ? (this.player.velocity.y -= this.player.getEffectiveGravity()) : 0.0f);
        }
        this.player.velocity.y *= 0.98f;
        if (this.player.horizontalCollision && (this.player.onClimbable() || this.player.getInBlockState().is(Blocks.POWDER_SNOW) && PowderSnowBlock.canEntityWalkOnPowderSnow(this.player))) {
            this.player.velocity.y = 0.2f;
        }
        float g = this.prevSlipperiness * 0.91f;
        this.player.velocity = this.player.velocity.multiply(g, 1.0f, g);
    }

    private Vec3 halfRelativeMovementCalculate(Vec3 vec3, float f) {
        boolean collidedOrJumping;
        vec3 = this.moveRelative(vec3, this.player.getFrictionInfluencedSpeed(f));
        boolean bl = collidedOrJumping = this.player.horizontalCollision || this.player.getInputData().contains(PlayerAuthInputData.JUMPING);
        if (collidedOrJumping && (this.player.onClimbable() || this.player.getInBlockState().is(Blocks.POWDER_SNOW) && PowderSnowBlock.canEntityWalkOnPowderSnow(this.player))) {
            vec3.y = this.player.bestPossibility.getType() == VectorType.VELOCITY ? vec3.y : 0.2f;
        }
        return this.applyClimbingSpeed(vec3);
    }
}

