/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.util;

import ac.boar.anticheat.check.api.Check;
import ac.boar.anticheat.check.api.impl.PingBasedCheck;
import ac.boar.anticheat.player.BoarPlayer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;

public final class LatencyUtil {
    private final BoarPlayer player;
    private final List<Long> sentStackLatency = new CopyOnWriteArrayList<Long>();
    private final Map<Long, Long> idToSentTime = new ConcurrentHashMap<Long, Long>();
    private final Map<Long, List<Runnable>> idToTasks = new ConcurrentHashMap<Long, List<Runnable>>();
    private long prevReceivedSentTime = -1L;

    public long getLastSentTime() {
        return this.prevReceivedSentTime;
    }

    public boolean hasId(long id) {
        return this.sentStackLatency.contains(id);
    }

    public void addLatencyToQueue(long id) {
        this.sentStackLatency.add(id);
        this.idToSentTime.put(id, System.currentTimeMillis());
        this.onLatencySend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskToQueue(long id, Runnable runnable) {
        if (id <= this.player.receivedStackId.get()) {
            runnable.run();
            return;
        }
        LatencyUtil latencyUtil = this;
        synchronized (latencyUtil) {
            if (!this.idToTasks.containsKey(id)) {
                this.idToTasks.put(id, new ArrayList());
            }
            this.idToTasks.get(id).add(runnable);
        }
    }

    public void confirmByTime(long time) {
        long next;
        Long sentTime;
        if (time < this.prevReceivedSentTime) {
            return;
        }
        ArrayList<Long> removeIds = new ArrayList<Long>();
        long lastId = -1L;
        Iterator<Long> iterator = this.sentStackLatency.iterator();
        while (iterator.hasNext() && (sentTime = this.idToSentTime.get(next = iterator.next().longValue())) <= time) {
            this.idToSentTime.remove(next);
            this.prevReceivedSentTime = Math.max(this.prevReceivedSentTime, sentTime);
            List<Runnable> tasks = this.idToTasks.remove(next);
            if (tasks != null) {
                tasks.forEach(Runnable::run);
            }
            this.onLatencyAccepted(next, sentTime);
            removeIds.add(next);
            lastId = next;
        }
        this.sentStackLatency.removeAll(removeIds);
        if (lastId == -1L || lastId < this.player.receivedStackId.get()) {
            return;
        }
        this.player.receivedStackId.set(lastId);
    }

    public boolean confirmStackId(long id) {
        long next;
        if (!this.hasId(id) || id <= this.player.receivedStackId.get()) {
            return false;
        }
        ArrayList<Long> removeIds = new ArrayList<Long>();
        Iterator<Long> iterator = this.sentStackLatency.iterator();
        while (iterator.hasNext() && (next = iterator.next().longValue()) <= id) {
            Long sentTime;
            List<Runnable> tasks = this.idToTasks.remove(next);
            if (tasks != null) {
                tasks.forEach(Runnable::run);
            }
            if ((sentTime = this.idToSentTime.remove(next)) != null) {
                this.prevReceivedSentTime = Math.max(this.prevReceivedSentTime, sentTime);
                this.onLatencyAccepted(next, sentTime);
            }
            removeIds.add(next);
        }
        this.sentStackLatency.removeAll(removeIds);
        this.player.receivedStackId.set(id);
        return true;
    }

    private void onLatencySend() {
        for (Check check : this.player.getCheckHolder().values()) {
            if (!(check instanceof PingBasedCheck)) continue;
            PingBasedCheck pingBasedCheck = (PingBasedCheck)check;
            pingBasedCheck.onLatencySend(this.player.sentStackId.get());
        }
    }

    private void onLatencyAccepted(long id, long time) {
        for (Check check : this.player.getCheckHolder().values()) {
            if (!(check instanceof PingBasedCheck)) continue;
            PingBasedCheck pingBasedCheck = (PingBasedCheck)check;
            pingBasedCheck.onLatencyAccepted(id, time);
        }
    }

    @Generated
    public LatencyUtil(BoarPlayer player) {
        this.player = player;
    }
}

