/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.reflect.bytecode.impl.asm;

import ac.boar.shaded.reflect.JavaBypass;
import ac.boar.shaded.reflect.bytecode.builder.BytecodeBuilder;
import ac.boar.shaded.reflect.bytecode.builder.ClassBuilder;
import ac.boar.shaded.reflect.bytecode.impl.asm.ASMBuiltClass;
import ac.boar.shaded.reflect.bytecode.impl.asm.ASMClassBuilder;
import ac.boar.shaded.reflect.bytecode.wrapper.BuiltClass;
import ac.boar.shaded.reflect.bytecode.wrapper.BytecodeLabel;
import ac.boar.shaded.reflect.bytecode.wrapper.BytecodeType;
import ac.boar.shaded.reflect.stream.RStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class ASMBuilder
implements BytecodeBuilder {
    public static final Class<?> CLASS_Opcodes;
    public static final Class<?> CLASS_ClassWriter;
    public static final Class<?> CLASS_FieldVisitor;
    public static final Class<?> CLASS_MethodVisitor;
    public static final Class<?> CLASS_Label;
    public static final Class<?> CLASS_type;
    private static final Map<String, Integer> opcodes;

    ASMBuilder() {
    }

    private static Class<?> forName(String ... names) {
        for (String name : names) {
            try {
                return Class.forName(name);
            }
            catch (Throwable throwable) {
            }
        }
        throw new IllegalStateException("Could not find any of the classes: " + String.join((CharSequence)", ", names));
    }

    @Override
    public BuiltClass class_(int access, String name, String signature, String superName, String[] interfaces, Consumer<ClassBuilder> consumer) {
        MethodHandle constructor = JavaBypass.TRUSTED_LOOKUP.findConstructor(CLASS_ClassWriter, MethodType.methodType(Void.TYPE, Integer.TYPE));
        MethodHandle visit = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_ClassWriter, "visit", MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE, String.class, String.class, String.class, String[].class));
        MethodHandle visitEnd = JavaBypass.TRUSTED_LOOKUP.findVirtual(CLASS_ClassWriter, "visitEnd", MethodType.methodType(Void.TYPE));
        Object classWriter = constructor.invoke(2);
        visit.invoke(classWriter, this.opcode("V1_8"), access, name, signature, superName, interfaces);
        ASMClassBuilder builder = new ASMClassBuilder(classWriter, name);
        consumer.accept(builder);
        visitEnd.invoke(classWriter);
        return new ASMBuiltClass(classWriter, name);
    }

    @Override
    public BytecodeLabel label() {
        MethodHandle constructor = JavaBypass.TRUSTED_LOOKUP.findConstructor(CLASS_Label, MethodType.methodType(Void.TYPE));
        return new BytecodeLabel(constructor.invoke());
    }

    @Override
    public BytecodeType type(String descriptor) {
        MethodHandle method = JavaBypass.TRUSTED_LOOKUP.findStatic(CLASS_type, "getType", MethodType.methodType(CLASS_type, String.class));
        return new BytecodeType(method.invoke(descriptor));
    }

    @Override
    public int opcode(String name) {
        return opcodes.get(name.toUpperCase(Locale.ROOT));
    }

    static {
        opcodes = new HashMap<String, Integer>();
        CLASS_Opcodes = ASMBuilder.forName("org.objectweb.asm.Opcodes", "jdk.internal.org.objectweb.asm.Opcodes");
        CLASS_ClassWriter = ASMBuilder.forName("org.objectweb.asm.ClassWriter", "jdk.internal.org.objectweb.asm.ClassWriter");
        CLASS_FieldVisitor = ASMBuilder.forName("org.objectweb.asm.FieldVisitor", "jdk.internal.org.objectweb.asm.FieldVisitor");
        CLASS_MethodVisitor = ASMBuilder.forName("org.objectweb.asm.MethodVisitor", "jdk.internal.org.objectweb.asm.MethodVisitor");
        CLASS_Label = ASMBuilder.forName("org.objectweb.asm.Label", "jdk.internal.org.objectweb.asm.Label");
        CLASS_type = ASMBuilder.forName("org.objectweb.asm.Type", "jdk.internal.org.objectweb.asm.Type");
        RStream.of(CLASS_Opcodes).fields().filter(true).filter(Integer.TYPE).forEach(f -> opcodes.put(f.name(), (Integer)f.get()));
    }
}

