/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.check.impl.prediction;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.check.api.Check;
import ac.boar.anticheat.check.api.annotations.CheckInfo;
import ac.boar.anticheat.check.api.impl.OffsetHandlerCheck;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.prediction.engine.data.VectorType;
import ac.boar.anticheat.util.MathUtil;
import ac.boar.anticheat.util.math.Vec3;
import java.util.HashMap;
import java.util.Map;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;

@CheckInfo(name="Prediction")
public class Prediction
extends OffsetHandlerCheck {
    private final Map<String, Check> checks = new HashMap<String, Check>();

    public Prediction(BoarPlayer player) {
        super(player);
        this.checks.put("Phase", new Check(player, "Phase", "", false));
        this.checks.put("Velocity", new Check(player, "Velocity", "", false));
        this.checks.put("Strafe", new Check(player, "Strafe", "", false));
        this.checks.put("Speed", new Check(player, "Speed", "", false));
        this.checks.put("Flight", new Check(player, "Flight", "", false));
        this.checks.put("Collisions", new Check(player, "Collisions", "", false));
    }

    @Override
    public void onPredictionComplete(float offset) {
        Vec3 predicted;
        Vec3 actual;
        if (this.player.tick < 10L || offset < this.player.getMaxOffset()) {
            return;
        }
        if (!this.shouldDoFail() || offset < Boar.getConfig().alertThreshold()) {
            this.player.getTeleportUtil().rewind(this.player.tick);
            return;
        }
        this.player.getTeleportUtil().rewind(this.player.tick);
        boolean claimedHorizontal = this.player.getInputData().contains(PlayerAuthInputData.HORIZONTAL_COLLISION);
        boolean claimedVertical = this.player.getInputData().contains(PlayerAuthInputData.VERTICAL_COLLISION);
        if (claimedVertical != this.player.verticalCollision || claimedHorizontal != this.player.horizontalCollision) {
            this.fail("Phase", "o: " + offset + ", expect: (" + this.player.horizontalCollision + "," + this.player.verticalCollision + "), actual: (" + claimedHorizontal + "," + claimedVertical + ")");
        }
        if (this.player.bestPossibility.getType() == VectorType.VELOCITY) {
            this.fail("Velocity", "o: " + offset);
            return;
        }
        if (this.player.unvalidatedTickEnd.distanceTo(this.player.velocity) < this.player.getMaxOffset()) {
            this.fail("Collisions", "o: " + offset);
        }
        if (!MathUtil.sameDirectionHorizontal(actual = this.player.unvalidatedPosition.subtract(this.player.prevUnvalidatedPosition), predicted = this.player.position.subtract(this.player.prevUnvalidatedPosition))) {
            this.fail("Strafe", "o: " + offset + ", expected direction: " + MathUtil.signAll(predicted).horizontalToString() + ", actual direction: " + MathUtil.signAll(actual).horizontalToString());
        }
        float squaredActual = actual.horizontalLengthSquared();
        float squaredPredicted = predicted.horizontalLengthSquared();
        if (actual.horizontalLengthSquared() > predicted.horizontalLengthSquared()) {
            this.fail("Speed", "o: " + offset + ", expected: " + squaredPredicted + ", actual: " + squaredActual);
        }
        if (Math.abs(this.player.position.y - this.player.unvalidatedPosition.y) > this.player.getMaxOffset()) {
            this.fail("Flight", "o: " + offset);
        }
    }

    public boolean shouldDoFail() {
        return this.player.tickSinceBlockResync <= 0 && !this.player.getTeleportUtil().isTeleporting() && this.player.sinceLoadingScreen > 5 && this.player.compensatedWorld.isChunkLoaded((int)this.player.position.x, (int)this.player.position.z);
    }

    public void fail(String name, String verbose) {
        if (Boar.getConfig().disabledChecks().contains(name)) {
            return;
        }
        this.checks.get(name).fail(verbose);
    }
}

