/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.packets.server;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.compensated.world.CompensatedWorldImpl;
import ac.boar.anticheat.compensated.world.base.CompensatedWorld;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.DimensionUtil;
import ac.boar.anticheat.util.geyser.BlockStorage;
import ac.boar.anticheat.util.geyser.BoarChunk;
import ac.boar.anticheat.util.geyser.BoarChunkSection;
import ac.boar.anticheat.util.math.Vec3;
import ac.boar.protocol.event.CloudburstPacketEvent;
import ac.boar.protocol.listener.PacketListener;
import ac.boar.shaded.fastutil.ints.IntArrayList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NBTInputStream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtUtils;
import org.cloudburstmc.protocol.bedrock.data.ServerboundLoadingScreenPacketType;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BlockEntityDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelChunkPacket;
import org.cloudburstmc.protocol.bedrock.packet.ServerboundLoadingScreenPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.cloudburstmc.protocol.common.util.VarInts;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.level.chunk.bitarray.BitArray;
import org.geysermc.geyser.level.chunk.bitarray.BitArrayVersion;
import org.geysermc.geyser.level.chunk.bitarray.SingletonBitArray;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityInfo;

public class ServerChunkPackets
implements PacketListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPacketSend(CloudburstPacketEvent event, boolean immediate) {
        BedrockPacket bedrockPacket;
        BedrockPacket sectionCount2;
        LevelChunkPacket packet;
        BoarPlayer player = event.getPlayer();
        CompensatedWorldImpl world = player.compensatedWorld;
        BedrockPacket bedrockPacket2 = event.getPacket();
        if (bedrockPacket2 instanceof LevelChunkPacket) {
            boolean send;
            packet = (LevelChunkPacket)bedrockPacket2;
            int sectionCount2 = packet.getSubChunksLength();
            if (sectionCount2 == -2) {
                return;
            }
            int chunkX = packet.getChunkX() << 4;
            int chunkZ = packet.getChunkZ() << 4;
            boolean bl = send = Math.abs(player.position.x - (float)chunkX) <= 16.0f || Math.abs(player.position.z - (float)chunkZ) <= 16.0f;
            if (send) {
                player.sendLatencyStack(immediate);
            }
            if (sectionCount2 == 0) {
                player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> world.removeFromCache(packet.getChunkX(), packet.getChunkZ()));
                return;
            }
            int dimensionId = packet.getDimension();
            if (dimensionId < 0 || dimensionId > 2) {
                return;
            }
            BedrockDimension dimension = DimensionUtil.dimensionFromId(dimensionId);
            BoarChunkSection[] sections = new BoarChunkSection[dimension.height() >> 4];
            int yOffset = world.getMinY() >> 4;
            int chunkSize = world.getHeightY() >> 4;
            int dimensionOffset = dimension.minY() >> 4;
            ArrayList<BlockEntityInfo> blockEntities = new ArrayList<BlockEntityInfo>();
            ByteBuf buffer = packet.getData().retainedDuplicate();
            try {
                for (int i = 0; i < sectionCount2; ++i) {
                    int n;
                    buffer.readByte();
                    int storageLength = buffer.readUnsignedByte();
                    short subChunkIndex = buffer.readUnsignedByte();
                    BlockStorage[] storages = new BlockStorage[Math.max(storageLength, 2)];
                    for (n = 0; n < storageLength; ++n) {
                        storages[n] = this.readStorage(buffer, player.BEDROCK_AIR);
                    }
                    for (n = 0; n < storages.length; ++n) {
                        if (storages[n] != null) continue;
                        if (n == 1) {
                            IntArrayList list = new IntArrayList(1);
                            list.add(player.BEDROCK_AIR);
                            storages[n] = new BlockStorage(BitArrayVersion.V0.createArray(4096, null), list);
                            continue;
                        }
                        storages[n] = new BlockStorage(player.BEDROCK_AIR, BitArrayVersion.V2);
                    }
                    sections[i] = new BoarChunkSection(storages, (int)subChunkIndex);
                }
                int biomeCount = dimension.height() >> 4;
                for (int i = 0; i < biomeCount; ++i) {
                    int biomeYOffset = dimensionOffset + i;
                    if (biomeYOffset < yOffset) {
                        buffer.skipBytes(1);
                        continue;
                    }
                    if (biomeYOffset >= chunkSize + yOffset) {
                        buffer.skipBytes(1);
                        continue;
                    }
                    this.readStorageAndSkip(buffer);
                }
                buffer.skipBytes(1);
                NBTInputStream nbtStream = NbtUtils.createNetworkReader((InputStream)new ByteBufInputStream(buffer));
                while (buffer.isReadable()) {
                    Object tag = nbtStream.readTag();
                    if (!(tag instanceof NbtMap)) continue;
                    NbtMap nbtTag = (NbtMap)tag;
                    int x = nbtTag.getInt("x", 0);
                    int y = nbtTag.getInt("y", 0);
                    int z = nbtTag.getInt("z", 0);
                    blockEntities.add(new BlockEntityInfo(x, y, z, null, nbtTag));
                }
            }
            catch (Exception exception) {
            }
            finally {
                buffer.release();
            }
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> {
                if (dimension != world.getDimension()) {
                    return;
                }
                world.addToCache(packet.getChunkX(), packet.getChunkZ(), sections, blockEntities);
            });
        }
        if ((sectionCount2 = event.getPacket()) instanceof UpdateBlockPacket) {
            boolean send;
            packet = (UpdateBlockPacket)sectionCount2;
            if (packet.getDataLayer() == 0 && Boar.getConfig().ignoreGhostBlock() && !player.inLoadingScreen && player.sinceLoadingScreen >= 2) {
                int distance;
                boolean newBlockIsAir = player.AIR_IDS.contains(packet.getDefinition().getRuntimeId());
                boolean oldBlockIsAir = player.AIR_IDS.contains(player.compensatedWorld.getRawBlockAt(packet.getBlockPosition().getX(), packet.getBlockPosition().getY(), packet.getBlockPosition().getZ(), 0));
                if (newBlockIsAir && !oldBlockIsAir && (distance = Math.abs(packet.getBlockPosition().getY() - GenericMath.floor((float)(player.position.y - 1.0f)))) <= 1) {
                    player.tickSinceBlockResync = 5;
                    world.updateBlock(packet.getBlockPosition(), packet.getDataLayer(), packet.getDefinition().getRuntimeId());
                }
            }
            boolean bl = send = player.position.distanceTo(new Vec3(packet.getBlockPosition())) <= 16.0f;
            if (send) {
                player.sendLatencyStack(immediate);
            }
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> ServerChunkPackets.lambda$onPacketSend$2(world, (UpdateBlockPacket)packet));
        }
        if ((bedrockPacket = event.getPacket()) instanceof BlockEntityDataPacket) {
            packet = (BlockEntityDataPacket)bedrockPacket;
            player.sendLatencyStack();
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> ServerChunkPackets.lambda$onPacketSend$4(player, (BlockEntityDataPacket)packet));
        }
    }

    @Override
    public void onPacketReceived(CloudburstPacketEvent event) {
        ServerboundLoadingScreenPacket packet;
        BoarPlayer player = event.getPlayer();
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof ServerboundLoadingScreenPacket && (packet = (ServerboundLoadingScreenPacket)bedrockPacket).getType() == ServerboundLoadingScreenPacketType.END_LOADING_SCREEN && Objects.equals(player.currentLoadingScreen, packet.getLoadingScreenId()) && player.inLoadingScreen) {
            player.currentLoadingScreen = null;
            player.inLoadingScreen = false;
            player.sinceLoadingScreen = 0;
        }
    }

    private void readStorageAndSkip(ByteBuf buffer) {
        short header = buffer.readUnsignedByte();
        int bitArrayVersion = header >> 1;
        if (bitArrayVersion == 127) {
            return;
        }
        BitArrayVersion version = BitArrayVersion.get((int)bitArrayVersion, (boolean)true);
        int words = MathUtils.ceil((float)(4096.0f / (float)Cache.values()[version.ordinal()].entriesPerWord));
        if (version != BitArrayVersion.V0) {
            for (int i = 0; i < words; ++i) {
                buffer.readIntLE();
            }
        }
        int size = version == BitArrayVersion.V0 ? 1 : VarInts.readInt((ByteBuf)buffer);
        for (int i = 0; i < size; ++i) {
            VarInts.readInt((ByteBuf)buffer);
        }
    }

    private BlockStorage readStorage(ByteBuf buffer, int airId) {
        short header = buffer.readUnsignedByte();
        int bitArrayVersion = header >> 1;
        if (bitArrayVersion == 127) {
            return null;
        }
        BitArray bitArray = bitArrayVersion == 0 ? BitArrayVersion.get((int)bitArrayVersion, (boolean)true).createArray(4096, null) : BitArrayVersion.get((int)bitArrayVersion, (boolean)true).createArray(4096);
        if (!(bitArray instanceof SingletonBitArray)) {
            for (int i = 0; i < bitArray.getWords().length; ++i) {
                bitArray.getWords()[i] = buffer.readIntLE();
            }
        }
        int size = bitArray instanceof SingletonBitArray ? 1 : VarInts.readInt((ByteBuf)buffer);
        IntArrayList palette = new IntArrayList(size);
        for (int i = 0; i < size; ++i) {
            palette.add(VarInts.readInt((ByteBuf)buffer));
        }
        if (palette.isEmpty()) {
            palette.add(airId);
        }
        return new BlockStorage(bitArray, palette);
    }

    private static /* synthetic */ void lambda$onPacketSend$4(BoarPlayer player, BlockEntityDataPacket packet) {
        BoarChunk chunk = player.compensatedWorld.getChunk(packet.getBlockPosition().getX() >> 4, packet.getBlockPosition().getZ() >> 4);
        if (chunk == null) {
            return;
        }
        Vector3i pos = packet.getBlockPosition();
        chunk.blockEntities().removeIf(block -> block.getX() == pos.getX() && block.getY() == pos.getY() && block.getZ() == pos.getZ());
        chunk.blockEntities().add(new BlockEntityInfo(pos.getX(), pos.getY(), pos.getZ(), null, packet.getData()));
    }

    private static /* synthetic */ void lambda$onPacketSend$2(CompensatedWorld world, UpdateBlockPacket packet) {
        world.updateBlock(packet.getBlockPosition(), packet.getDataLayer(), packet.getDefinition().getRuntimeId());
    }

    private static enum Cache {
        V16(16, 2),
        V8(8, 4),
        V6(6, 5),
        V5(5, 6),
        V4(4, 8),
        V3(3, 10),
        V2(2, 16),
        V1(1, 32),
        V0(0, 0);

        final byte bits;
        final byte entriesPerWord;
        final int maxEntryValue;

        private Cache(int bits, int entriesPerWord) {
            this.bits = (byte)bits;
            this.entriesPerWord = (byte)entriesPerWord;
            this.maxEntryValue = (1 << this.bits) - 1;
        }
    }
}

