/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.prediction;

import ac.boar.anticheat.collision.Collider;
import ac.boar.anticheat.data.input.PredictionData;
import ac.boar.anticheat.data.input.VelocityData;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.prediction.engine.base.PredictionEngine;
import ac.boar.anticheat.prediction.engine.data.Vector;
import ac.boar.anticheat.prediction.engine.data.VectorType;
import ac.boar.anticheat.prediction.engine.impl.GlidingPredictionEngine;
import ac.boar.anticheat.prediction.engine.impl.GroundAndAirPredictionEngine;
import ac.boar.anticheat.prediction.engine.impl.fluid.LavaPredictionEngine;
import ac.boar.anticheat.prediction.engine.impl.fluid.WaterPredictionEngine;
import ac.boar.anticheat.prediction.ticker.impl.PlayerTicker;
import ac.boar.anticheat.util.math.Vec3;
import java.util.ArrayList;
import java.util.Iterator;
import lombok.Generated;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.level.block.Fluid;

public class PredictionRunner {
    private final BoarPlayer player;

    public void run() {
        if (!this.findBestTickStartVelocity()) {
            return;
        }
        new PlayerTicker(this.player).tick();
        this.player.predictionResult = new PredictionData(this.player.beforeCollision.clone(), this.player.afterCollision.clone(), this.player.velocity.clone());
    }

    private boolean findBestTickStartVelocity() {
        Object data;
        PredictionEngine engine = this.player.touchingWater ? new WaterPredictionEngine(this.player) : (this.player.isInLava() ? new LavaPredictionEngine(this.player) : (this.player.getFlagTracker().has(EntityFlag.GLIDING) ? new GlidingPredictionEngine(this.player) : new GroundAndAirPredictionEngine(this.player)));
        ArrayList<Vector> possibleVelocities = new ArrayList<Vector>();
        boolean forceVelocity = false;
        VelocityData forcedVelocity = null;
        Iterator iterator = this.player.queuedVelocities.values().iterator();
        while (iterator.hasNext() && ((VelocityData)(data = (VelocityData)iterator.next())).stackId() <= this.player.receivedStackId.get()) {
            forcedVelocity = data;
            forceVelocity = true;
        }
        if (forceVelocity) {
            possibleVelocities.add(new Vector(VectorType.VELOCITY, forcedVelocity.velocity(), forcedVelocity.stackId()));
        } else {
            VelocityData data2;
            possibleVelocities.add(new Vector(VectorType.NORMAL, this.player.velocity.clone()));
            VelocityData nearestVelocity = null;
            data = this.player.queuedVelocities.values().iterator();
            while (data.hasNext() && (data2 = (VelocityData)data.next()).stackId() - 1L <= this.player.receivedStackId.get()) {
                nearestVelocity = data2;
            }
            if (nearestVelocity != null) {
                possibleVelocities.add(new Vector(VectorType.VELOCITY, nearestVelocity.velocity(), nearestVelocity.stackId()));
            }
        }
        float closetDistance = Float.MAX_VALUE;
        if (possibleVelocities.size() == 1) {
            this.player.bestPossibility = (Vector)possibleVelocities.get(0);
        } else {
            Vec3 oldInput = this.player.input.clone();
            for (Vector possibility : possibleVelocities) {
                float distance;
                boolean jumping;
                Vec3 vec3 = possibility.getVelocity().clone();
                boolean bl = jumping = this.player.getInputData().contains(PlayerAuthInputData.JUMPING) || this.player.getInputData().contains(PlayerAuthInputData.WANT_UP) || this.player.getInputData().contains(PlayerAuthInputData.START_JUMPING);
                if (jumping) {
                    float g;
                    float f = g = this.player.isInLava() ? this.player.getFluidHeight(Fluid.LAVA) : this.player.getFluidHeight(Fluid.WATER);
                    if (g != 0.0f) {
                        vec3 = vec3.add(0.0f, 0.04f, 0.0f);
                    } else if (this.player.onGround && this.player.getInputData().contains(PlayerAuthInputData.START_JUMPING)) {
                        vec3 = this.player.jumpFromGround(vec3);
                    }
                }
                vec3 = engine.travel(vec3);
                if ((double)this.player.stuckSpeedMultiplier.lengthSquared() > 1.0E-7) {
                    vec3 = vec3.multiply(this.player.stuckSpeedMultiplier);
                }
                if (!((distance = this.player.position.add(vec3 = Collider.collide(this.player, Collider.maybeBackOffFromEdge(this.player, vec3))).squaredDistanceTo(this.player.unvalidatedPosition)) <= closetDistance)) continue;
                closetDistance = distance;
                this.player.bestPossibility = possibility;
            }
            this.player.input = oldInput;
        }
        if (this.player.bestPossibility == null) {
            return false;
        }
        this.player.velocity = this.player.bestPossibility.getVelocity();
        return true;
    }

    @Generated
    public PredictionRunner(BoarPlayer player) {
        this.player = player;
    }
}

