/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.util.block;

import ac.boar.anticheat.data.block.BoarBlockState;
import ac.boar.anticheat.player.BoarPlayer;
import java.util.Locale;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.property.Property;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.cache.TagCache;
import org.geysermc.geyser.session.cache.tags.BlockTag;

public class BlockUtil {
    public static boolean determineCanBreak(BoarPlayer player, BlockState state) {
        if (state.is(Blocks.AIR) || state.is(Blocks.CAVE_AIR) || state.is(Blocks.VOID_AIR) || state.is(Blocks.LAVA) || state.is(Blocks.WATER)) {
            return false;
        }
        float destroyTime = state.block().destroyTime();
        return destroyTime != -1.0f || player.gameType == GameType.CREATIVE;
    }

    public static BlockState findFenceBlockState(BoarPlayer player, BlockState main, Vector3i position) {
        BoarBlockState blockState = player.compensatedWorld.getBlockState(position.north(), 0);
        BoarBlockState blockState2 = player.compensatedWorld.getBlockState(position.east(), 0);
        BoarBlockState blockState3 = player.compensatedWorld.getBlockState(position.south(), 0);
        BoarBlockState blockState4 = player.compensatedWorld.getBlockState(position.west(), 0);
        boolean north = BlockUtil.connectsTo(player, main, blockState.getState(), blockState.isFaceSturdy(player), Direction.SOUTH);
        boolean east = BlockUtil.connectsTo(player, main, blockState2.getState(), blockState2.isFaceSturdy(player), Direction.WEST);
        boolean south = BlockUtil.connectsTo(player, main, blockState3.getState(), blockState3.isFaceSturdy(player), Direction.NORTH);
        boolean west = BlockUtil.connectsTo(player, main, blockState4.getState(), blockState4.isFaceSturdy(player), Direction.EAST);
        String identifier = main.block().defaultBlockState().toString().intern();
        identifier = identifier.replace("north=true", "north=" + north);
        identifier = identifier.replace("east=true", "east=" + east);
        identifier = identifier.replace("south=true", "south=" + south);
        identifier = identifier.replace("west=true", "west=" + west);
        identifier = identifier.replace("waterlogged=true", "waterlogged=false");
        return BlockState.of((int)((Integer)BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.getOrDefault((Object)identifier, (Object)main.javaId())));
    }

    public static BlockState findIronBarsBlockState(BoarPlayer player, BlockState state, Vector3i position) {
        BoarBlockState blockState = player.compensatedWorld.getBlockState(position.north(), 0);
        BoarBlockState blockState2 = player.compensatedWorld.getBlockState(position.south(), 0);
        BoarBlockState blockState3 = player.compensatedWorld.getBlockState(position.west(), 0);
        BoarBlockState blockState4 = player.compensatedWorld.getBlockState(position.east(), 0);
        boolean north = BlockUtil.attachsTo(player, blockState.getState(), blockState.isFaceSturdy(player));
        boolean south = BlockUtil.attachsTo(player, blockState2.getState(), blockState2.isFaceSturdy(player));
        boolean west = BlockUtil.attachsTo(player, blockState3.getState(), blockState3.isFaceSturdy(player));
        boolean east = BlockUtil.attachsTo(player, blockState4.getState(), blockState4.isFaceSturdy(player));
        String identifier = state.block().defaultBlockState().toString().intern();
        identifier = identifier.replace("north=true", "north=" + north);
        identifier = identifier.replace("east=true", "east=" + east);
        identifier = identifier.replace("south=true", "south=" + south);
        identifier = identifier.replace("west=true", "west=" + west);
        identifier = identifier.replace("waterlogged=true", "waterlogged=false");
        return BlockState.of((int)((Integer)BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.getOrDefault((Object)identifier, (Object)state.javaId())));
    }

    private static boolean connectsTo(BoarPlayer player, BlockState blockState, BlockState neighbour, boolean bl, Direction direction) {
        TagCache tagCache = player.getSession().getTagCache();
        return !BlockUtil.isExceptionForConnection(tagCache, neighbour) && bl || BlockUtil.isSameFence(tagCache, neighbour, blockState) || BlockUtil.connectsToDirection(tagCache, neighbour, direction);
    }

    private static boolean attachsTo(BoarPlayer player, BlockState blockState, boolean bl) {
        TagCache tagCache = player.getSession().getTagCache();
        return !BlockUtil.isExceptionForConnection(tagCache, blockState) && bl || blockState.is(Blocks.IRON_BARS) || blockState.toString().toLowerCase(Locale.ROOT).contains("glass_pane") || tagCache.is(BlockTag.WALLS, (Object)blockState.block());
    }

    private static boolean isSameFence(TagCache tagCache, BlockState blockState, BlockState currentBlockState) {
        return tagCache.is(BlockTag.FENCES, (Object)blockState.block()) && tagCache.is(BlockTag.WOODEN_FENCES, (Object)blockState.block()) == tagCache.is(BlockTag.WOODEN_FENCES, (Object)currentBlockState.block());
    }

    public static boolean connectsToDirection(TagCache cache, BlockState blockState, Direction direction) {
        if (!cache.is(BlockTag.FENCE_GATES, (Object)blockState.block())) {
            return false;
        }
        return ((Direction)blockState.getValue((Property)Properties.HORIZONTAL_FACING)).getAxis() == BlockUtil.getClockWise(direction).getAxis();
    }

    public static boolean isExceptionForConnection(TagCache cache, BlockState blockState) {
        return cache.is(BlockTag.LEAVES, (Object)blockState.block()) || blockState.is(Blocks.BARRIER) || blockState.is(Blocks.CARVED_PUMPKIN) || blockState.is(Blocks.JACK_O_LANTERN) || blockState.is(Blocks.MELON) || blockState.is(Blocks.PUMPKIN) || cache.is(BlockTag.SHULKER_BOXES, (Object)blockState.block());
    }

    private static Direction getClockWise(Direction direction) {
        return switch (direction.ordinal()) {
            case 2 -> Direction.EAST;
            case 5 -> Direction.SOUTH;
            case 3 -> Direction.WEST;
            case 4 -> Direction.NORTH;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + String.valueOf(direction));
        };
    }
}

