/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.alert;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.geysermc.geyser.api.command.CommandSource;

public class AlertManager {
    private static final String PREFIX = "\u00a73Boar \u00a77>\u00a7r ";
    private static final String BEDROCK_PREFIX = "\u00a7sBoar \u00a7i>\u00a7r ";
    private final Map<UUID, CommandSource> sources = new ConcurrentHashMap<UUID, CommandSource>();

    public void alert(String verbose) {
        this.sources.values().forEach(source -> source.sendMessage(this.getPrefix((CommandSource)source) + "\u00a73" + verbose));
    }

    public String getPrefix(CommandSource source) {
        if (source.connection() != null) {
            return BEDROCK_PREFIX;
        }
        return PREFIX;
    }

    public boolean hasAlert(CommandSource source) {
        return this.sources.containsKey(source.playerUuid());
    }

    public void addAlert(CommandSource source) {
        this.sources.put(source.playerUuid(), source);
    }

    public void removeAlert(CommandSource source) {
        this.sources.remove(source.playerUuid());
    }
}

