/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.transformer.impl;

import ac.boar.shaded.classtransform.TransformerManager;
import ac.boar.shaded.classtransform.annotations.injection.CASM;
import ac.boar.shaded.classtransform.exceptions.MethodNotFoundException;
import ac.boar.shaded.classtransform.exceptions.TransformerException;
import ac.boar.shaded.classtransform.transformer.types.RemovingAnnotationHandler;
import ac.boar.shaded.classtransform.utils.ASMUtils;
import ac.boar.shaded.classtransform.utils.Types;
import ac.boar.shaded.classtransform.utils.annotations.ClassDefiner;
import ac.boar.shaded.classtransform.utils.mappings.Remapper;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

@ParametersAreNonnullByDefault
public class CASMAnnotationHandler
extends RemovingAnnotationHandler<CASM> {
    private final CASM.Shift shift;

    public CASMAnnotationHandler(CASM.Shift shift) {
        super(CASM.class);
        this.shift = shift;
    }

    @Override
    public void transform(CASM annotation, TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer, MethodNode transformerMethod) {
        if (!Modifier.isStatic(transformerMethod.access)) {
            throw TransformerException.wrongStaticAccess(transformerMethod, transformer, true);
        }
        Type[] args = Types.argumentTypes(transformerMethod.desc);
        Type returnType = Types.returnType(transformerMethod.desc);
        if (!returnType.equals(Type.VOID_TYPE)) {
            throw TransformerException.mustReturnVoid(transformerMethod, transformer);
        }
        if (annotation.value().length == 0) {
            if (args.length != 1 || !Types.type(ClassNode.class).equals(args[0])) {
                throw TransformerException.wrongArguments(transformerMethod, transformer, ClassNode.class);
            }
            ClassDefiner<?> classDefiner = this.isolateMethod(transformer, transformerMethod);
            try {
                Object instance = classDefiner.newInstance();
                Method isolatedMethod = classDefiner.getClazz().getDeclaredMethod(transformerMethod.name, ClassNode.class);
                isolatedMethod.setAccessible(true);
                isolatedMethod.invoke(instance, transformedClass);
            }
            catch (Throwable t) {
                throw new TransformerException(transformerMethod, transformer, "failed to call isolated method (ClassNode)").setCause(t);
            }
        } else {
            if (args.length != 1 || !Types.type(MethodNode.class).equals(args[0])) {
                throw TransformerException.wrongArguments(transformerMethod, transformer, MethodNode.class);
            }
            ClassDefiner<?> classDefiner = this.isolateMethod(transformer, transformerMethod);
            for (String targetCombi : annotation.value()) {
                List<MethodNode> targets = ASMUtils.getMethodsFromCombi(transformedClass, targetCombi);
                if (targets.isEmpty()) {
                    throw new MethodNotFoundException(transformedClass, transformer, targetCombi);
                }
                for (MethodNode target : targets) {
                    try {
                        Object instance = classDefiner.newInstance();
                        Method isolatedMethod = classDefiner.getClazz().getDeclaredMethod(transformerMethod.name, MethodNode.class);
                        isolatedMethod.setAccessible(true);
                        isolatedMethod.invoke(instance, target);
                    }
                    catch (Throwable t) {
                        throw new TransformerException(transformerMethod, transformer, "failed to call isolated method (MethodNode)").setCause(t);
                    }
                }
            }
        }
    }

    @Override
    public boolean shouldExecute(CASM annotation) {
        return annotation.shift().equals((Object)this.shift);
    }

    private ClassDefiner<?> isolateMethod(final ClassNode transformer, MethodNode transformerMethod) {
        try {
            ClassNode classNode = new ClassNode();
            classNode.visit(transformer.version, 1, ClassDefiner.generateClassName("IsolatedASMTransformer"), null, "java/lang/Object", null);
            MethodVisitor init = classNode.visitMethod(1, "<init>", Types.MD_Void, null, null);
            init.visitCode();
            init.visitVarInsn(25, 0);
            init.visitMethodInsn(183, Types.IN_Object, "<init>", Types.MD_Void, false);
            init.visitInsn(177);
            final ArrayList<MethodNode> methodsToCopy = new ArrayList<MethodNode>();
            methodsToCopy.add(transformerMethod);
            MethodVisitor methodVisitor = new MethodVisitor(589824){

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    if (owner.equals(transformer.name)) {
                        MethodNode method = ASMUtils.getMethod(transformer, name, desc);
                        if (method == null) {
                            throw new IllegalStateException("CASM transformer called method '" + name + "' not found");
                        }
                        methodsToCopy.add(method);
                    }
                }

                @Override
                public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                    if (owner.equals(transformer.name)) {
                        throw new IllegalStateException("CASM transformer must not access fields in the transformer class");
                    }
                }

                @Override
                public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                    if (bootstrapMethodHandle.getOwner().equals(Types.internalName(LambdaMetafactory.class))) {
                        throw new IllegalStateException("CASM transformer can not access LambdaMetafactory");
                    }
                }
            };
            while (!methodsToCopy.isEmpty()) {
                ArrayList methods = new ArrayList(methodsToCopy);
                methodsToCopy.clear();
                for (MethodNode methodNode : methods) {
                    Remapper.remapAndAdd(transformer, classNode, methodNode);
                    methodNode.accept(methodVisitor);
                }
            }
            return ClassDefiner.defineAnonymousClass(ASMUtils.toStacklessBytes(classNode));
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed to isolate method '" + transformerMethod.name + "' of transformer '" + transformer.name + "'", t);
        }
    }
}

