/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.prediction.ticker.base;

import ac.boar.anticheat.collision.Collider;
import ac.boar.anticheat.data.FluidState;
import ac.boar.anticheat.data.block.BoarBlockState;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.MathUtil;
import ac.boar.anticheat.util.math.Box;
import ac.boar.anticheat.util.math.Mutable;
import ac.boar.anticheat.util.math.Vec3;
import lombok.Generated;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.erosion.util.BlockPositionIterator;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.Fluid;

public class EntityTicker {
    protected final BoarPlayer player;

    public void tick() {
        this.baseTick();
    }

    public void baseTick() {
        this.player.inBlockState = null;
        this.updateWaterState();
        this.updateSwimming();
        this.player.soulSandBelow = this.player.compensatedWorld.getBlockState(this.player.getOnPos(0.001f), 0).getState().is(Blocks.SOUL_SAND);
    }

    private void updateSwimming() {
        if (this.player.getFlagTracker().has(EntityFlag.SWIMMING)) {
            this.player.getFlagTracker().set(EntityFlag.SWIMMING, this.player.touchingWater && this.player.vehicleData == null);
        }
    }

    private void updateWaterState() {
        this.player.fluidHeight.clear();
        this.checkWaterState();
        this.updateFluidHeightAndDoFluidPushing(0.007f, Fluid.LAVA);
    }

    void checkWaterState() {
        this.player.touchingWater = this.updateFluidHeightAndDoFluidPushing(0.014f, Fluid.WATER);
    }

    private boolean updateFluidHeightAndDoFluidPushing(float speed, Fluid tag) {
        if (this.player.isRegionUnloaded()) {
            return false;
        }
        Box box = this.player.boundingBox.expand(0.0f, -0.4f, 0.0f).contract(0.001f);
        int i = GenericMath.floor((float)box.minX);
        int j = GenericMath.floor((double)((double)box.maxX + 1.0));
        int k = GenericMath.floor((float)box.minY);
        int l = GenericMath.floor((double)((double)box.maxY + 1.0));
        int i1 = GenericMath.floor((float)box.minZ);
        int j1 = GenericMath.floor((double)((double)box.maxZ + 1.0));
        boolean found = false;
        Vec3 vec3 = new Vec3(0.0f, 0.0f, 0.0f);
        float maxFluidHeight = 0.0f;
        Mutable mutable = new Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    mutable.set(k1, l1, i2);
                    FluidState fluidState = this.player.compensatedWorld.getFluidState(mutable);
                    if (fluidState.fluid() != tag) continue;
                    float d0 = (float)(l1 + 1) - fluidState.height();
                    maxFluidHeight = Math.max(maxFluidHeight, d0);
                    if (!((float)l >= d0)) continue;
                    found = true;
                    vec3 = vec3.add(fluidState.getFlow(this.player, Vector3i.from((int)k1, (int)l1, (int)i2)));
                }
            }
        }
        if ((double)vec3.lengthSquared() > 0.0) {
            vec3 = vec3.normalize().multiply(speed);
            this.player.velocity = this.player.velocity.add(vec3);
        }
        if (tag == Fluid.LAVA) {
            this.player.beingPushByLava = (double)vec3.horizontalLengthSquared() > 1.0E-6;
        }
        this.player.fluidHeight.put(tag, Float.valueOf(maxFluidHeight));
        return found;
    }

    protected void applyEffectsFromBlocks() {
        if (this.player.onGround) {
            Vector3i lv = this.player.getOnPos(0.2f);
            this.player.compensatedWorld.getBlockState(lv, 0).onSteppedOn(this.player, lv);
        }
        BlockPositionIterator iterator = this.getBlockPositionIterator();
        Mutable mutable = new Mutable();
        iterator.reset();
        while (iterator.hasNext()) {
            mutable.set(iterator.getX(), iterator.getY(), iterator.getZ());
            this.player.compensatedWorld.getBlockState(iterator.getX(), iterator.getY(), iterator.getZ(), 0).entityInside(this.player, mutable);
            iterator.next();
        }
    }

    public final void doSelfMove(Vec3 vec3) {
        if ((double)this.player.stuckSpeedMultiplier.lengthSquared() > 1.0E-7) {
            vec3 = vec3.multiply(this.player.stuckSpeedMultiplier);
            this.player.stuckSpeedMultiplier = Vec3.ZERO;
            this.player.velocity = Vec3.ZERO.clone();
        }
        vec3 = Collider.maybeBackOffFromEdge(this.player, vec3);
        Vec3 vec32 = Collider.collide(this.player, vec3);
        this.player.setPos(this.player.position.add(vec32));
        boolean bl = !MathUtil.equal(vec3.x, vec32.x);
        boolean bl2 = !MathUtil.equal(vec3.z, vec32.z);
        this.player.horizontalCollision = bl || bl2;
        this.player.verticalCollision = vec3.y != vec32.y;
        boolean bl3 = this.player.onGround = this.player.verticalCollision && (double)vec3.y < 0.0;
        if (this.player.horizontalCollision) {
            this.player.velocity = new Vec3(bl ? 0.0f : this.player.velocity.x, this.player.velocity.y, bl2 ? 0.0f : this.player.velocity.z);
        }
        Vector3i blockPos = this.player.position.down(0.378f).toVector3i();
        BoarBlockState blockState = this.player.compensatedWorld.getBlockState(blockPos, 0);
        if (this.player.verticalCollision) {
            blockState.updateEntityMovementAfterFallOn(this.player, true);
        }
        this.player.beforeCollision = vec3.clone();
        this.player.afterCollision = vec32.clone();
    }

    private BlockPositionIterator getBlockPositionIterator() {
        Box box = this.player.boundingBox;
        return BlockPositionIterator.fromMinMax((int)Math.min(GenericMath.floor((double)((double)box.minX + 0.001)), GenericMath.floor((double)((double)box.minX - 0.001))), (int)Math.min(GenericMath.floor((double)((double)box.minY + 0.001)), GenericMath.floor((double)((double)box.minY - 0.001))), (int)Math.min(GenericMath.floor((double)((double)box.minZ + 0.001)), GenericMath.floor((double)((double)box.minZ - 0.001))), (int)GenericMath.floor((double)((double)box.maxX - 0.001)), (int)GenericMath.floor((double)((double)box.maxY - 0.001)), (int)GenericMath.floor((double)((double)box.maxZ - 0.001)));
    }

    @Generated
    public EntityTicker(BoarPlayer player) {
        this.player = player;
    }
}

