/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.compensated.cache.entity;

import ac.boar.anticheat.compensated.cache.entity.state.CachedEntityState;
import ac.boar.anticheat.data.EntityDimensions;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.math.Vec3;
import ac.boar.anticheat.util.reach.PositionInterpolator;
import lombok.Generated;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataMap;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;

public final class EntityCache {
    private final BoarPlayer player;
    private final EntityType type;
    private final EntityDefinition<?> definition;
    private final long stackId;
    private final long runtimeId;
    private EntityDimensions dimensions;
    private Vec3 serverPosition = Vec3.ZERO;
    private boolean inVehicle;
    private EntityDataMap metadata = new EntityDataMap();
    private CachedEntityState past;
    private CachedEntityState current;
    public boolean affectedByOffset;

    public void setMetadata(EntityDataMap metadata) {
        this.metadata = metadata;
        if (metadata.containsKey((Object)EntityDataTypes.WIDTH)) {
            this.dimensions = EntityDimensions.fixed(((Float)metadata.get(EntityDataTypes.WIDTH)).floatValue(), this.definition.height());
        }
        if (metadata.containsKey((Object)EntityDataTypes.HEIGHT)) {
            this.dimensions = EntityDimensions.fixed(this.definition.height(), ((Float)metadata.get(EntityDataTypes.HEIGHT)).floatValue());
        }
        if (this.definition.identifier().equalsIgnoreCase("minecraft:boat") || this.definition.identifier().equalsIgnoreCase("minecraft:chest_boat")) {
            this.dimensions = EntityDimensions.fixed(1.6f, 0.575f);
        }
        if (metadata.containsKey((Object)EntityDataTypes.SCALE)) {
            this.dimensions = this.dimensions.hardScaled(((Float)metadata.get(EntityDataTypes.SCALE)).floatValue());
        }
    }

    public float getYOffset() {
        if (this.affectedByOffset) {
            return this.definition.offset();
        }
        return 0.0f;
    }

    public void init() {
        this.current = new CachedEntityState(this.player, this);
    }

    public void interpolate(Vec3 pos, boolean lerp) {
        this.past = this.current.clone();
        if (!lerp) {
            this.current.setTeleportPos(pos);
        } else {
            PositionInterpolator lv = this.current.getInterpolator();
            if (lv != null) {
                lv.refreshPositionAndAngles(pos);
            }
        }
    }

    @Generated
    public String toString() {
        return "EntityCache(player=" + String.valueOf(this.getPlayer()) + ", type=" + String.valueOf(this.getType()) + ", definition=" + String.valueOf(this.getDefinition()) + ", stackId=" + this.getStackId() + ", runtimeId=" + this.getRuntimeId() + ", dimensions=" + String.valueOf(this.getDimensions()) + ", serverPosition=" + String.valueOf(this.getServerPosition()) + ", inVehicle=" + this.isInVehicle() + ", metadata=" + String.valueOf(this.getMetadata()) + ", past=" + String.valueOf(this.getPast()) + ", current=" + String.valueOf(this.getCurrent()) + ", affectedByOffset=" + this.isAffectedByOffset() + ")";
    }

    @Generated
    public EntityCache(BoarPlayer player, EntityType type, EntityDefinition<?> definition, long stackId, long runtimeId) {
        this.player = player;
        this.type = type;
        this.definition = definition;
        this.stackId = stackId;
        this.runtimeId = runtimeId;
    }

    @Generated
    public BoarPlayer getPlayer() {
        return this.player;
    }

    @Generated
    public EntityType getType() {
        return this.type;
    }

    @Generated
    public EntityDefinition<?> getDefinition() {
        return this.definition;
    }

    @Generated
    public long getStackId() {
        return this.stackId;
    }

    @Generated
    public long getRuntimeId() {
        return this.runtimeId;
    }

    @Generated
    public EntityDimensions getDimensions() {
        return this.dimensions;
    }

    @Generated
    public Vec3 getServerPosition() {
        return this.serverPosition;
    }

    @Generated
    public boolean isInVehicle() {
        return this.inVehicle;
    }

    @Generated
    public EntityDataMap getMetadata() {
        return this.metadata;
    }

    @Generated
    public CachedEntityState getPast() {
        return this.past;
    }

    @Generated
    public CachedEntityState getCurrent() {
        return this.current;
    }

    @Generated
    public boolean isAffectedByOffset() {
        return this.affectedByOffset;
    }

    @Generated
    public void setDimensions(EntityDimensions dimensions) {
        this.dimensions = dimensions;
    }

    @Generated
    public void setServerPosition(Vec3 serverPosition) {
        this.serverPosition = serverPosition;
    }

    @Generated
    public void setInVehicle(boolean inVehicle) {
        this.inVehicle = inVehicle;
    }

    @Generated
    public void setPast(CachedEntityState past) {
        this.past = past;
    }

    @Generated
    public void setCurrent(CachedEntityState current) {
        this.current = current;
    }

    @Generated
    public void setAffectedByOffset(boolean affectedByOffset) {
        this.affectedByOffset = affectedByOffset;
    }
}

