/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform;

import ac.boar.shaded.classtransform.TransformerDebugger;
import ac.boar.shaded.classtransform.annotations.CTransformer;
import ac.boar.shaded.classtransform.annotations.injection.CASM;
import ac.boar.shaded.classtransform.exceptions.TransformerLoadException;
import ac.boar.shaded.classtransform.mappings.AMapper;
import ac.boar.shaded.classtransform.mappings.impl.VoidMapper;
import ac.boar.shaded.classtransform.targets.IInjectionTarget;
import ac.boar.shaded.classtransform.targets.impl.ConstantTarget;
import ac.boar.shaded.classtransform.targets.impl.FieldTarget;
import ac.boar.shaded.classtransform.targets.impl.HeadTarget;
import ac.boar.shaded.classtransform.targets.impl.InvokeTarget;
import ac.boar.shaded.classtransform.targets.impl.NewTarget;
import ac.boar.shaded.classtransform.targets.impl.OpcodeTarget;
import ac.boar.shaded.classtransform.targets.impl.ReturnTarget;
import ac.boar.shaded.classtransform.targets.impl.TailTarget;
import ac.boar.shaded.classtransform.targets.impl.ThrowTarget;
import ac.boar.shaded.classtransform.transformer.AnnotationHandler;
import ac.boar.shaded.classtransform.transformer.HandlerPosition;
import ac.boar.shaded.classtransform.transformer.IAnnotationCoprocessor;
import ac.boar.shaded.classtransform.transformer.IAnnotationHandlerPreprocessor;
import ac.boar.shaded.classtransform.transformer.IBytecodeTransformer;
import ac.boar.shaded.classtransform.transformer.IPostTransformer;
import ac.boar.shaded.classtransform.transformer.IRawTransformer;
import ac.boar.shaded.classtransform.transformer.coprocessor.AnnotationCoprocessorList;
import ac.boar.shaded.classtransform.transformer.coprocessor.impl.CLocalVariableCoprocessor;
import ac.boar.shaded.classtransform.transformer.coprocessor.impl.CSharedCoprocessor;
import ac.boar.shaded.classtransform.transformer.impl.CASMAnnotationHandler;
import ac.boar.shaded.classtransform.transformer.impl.CInjectAnnotationHandler;
import ac.boar.shaded.classtransform.transformer.impl.CInlineAnnotationHandler;
import ac.boar.shaded.classtransform.transformer.impl.CModifyConstantAnnotationHandler;
import ac.boar.shaded.classtransform.transformer.impl.CModifyExpressionValueAnnotationHandler;
import ac.boar.shaded.classtransform.transformer.impl.COverrideAnnotationHandler;
import ac.boar.shaded.classtransform.transformer.impl.CRecordComponentAnnotationHandler;
import ac.boar.shaded.classtransform.transformer.impl.CRedirectAnnotationHandler;
import ac.boar.shaded.classtransform.transformer.impl.CReplaceCallbackAnnotationHandler;
import ac.boar.shaded.classtransform.transformer.impl.CShadowAnnotationHandler;
import ac.boar.shaded.classtransform.transformer.impl.CUpgradeAnnotationHandler;
import ac.boar.shaded.classtransform.transformer.impl.CWrapCatchAnnotationHandler;
import ac.boar.shaded.classtransform.transformer.impl.CWrapConditionAnnotationHandler;
import ac.boar.shaded.classtransform.transformer.impl.general.InnerClassGeneralHandler;
import ac.boar.shaded.classtransform.transformer.impl.general.MemberCopyGeneralHandler;
import ac.boar.shaded.classtransform.transformer.impl.general.SyntheticMethodGeneralHandler;
import ac.boar.shaded.classtransform.utils.ASMUtils;
import ac.boar.shaded.classtransform.utils.FailStrategy;
import ac.boar.shaded.classtransform.utils.HotswapClassLoader;
import ac.boar.shaded.classtransform.utils.annotations.AnnotationUtils;
import ac.boar.shaded.classtransform.utils.log.Logger;
import ac.boar.shaded.classtransform.utils.tree.ClassTree;
import ac.boar.shaded.classtransform.utils.tree.IClassProvider;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

@ParametersAreNonnullByDefault
public class TransformerManager
implements ClassFileTransformer {
    private final ClassTree classTree = new ClassTree(this);
    private final IClassProvider classProvider;
    private final AMapper mapper;
    private final List<AnnotationHandler> annotationHandler = new ArrayList<AnnotationHandler>();
    private final AnnotationCoprocessorList coprocessors = new AnnotationCoprocessorList();
    private final Map<String, IInjectionTarget> injectionTargets = new HashMap<String, IInjectionTarget>();
    private final TransformerDebugger debugger = new TransformerDebugger(this);
    private FailStrategy failStrategy = FailStrategy.EXIT;
    private Instrumentation instrumentation;
    private HotswapClassLoader hotswapClassLoader;
    private final List<IAnnotationHandlerPreprocessor> annotationHandlerPreprocessor = new ArrayList<IAnnotationHandlerPreprocessor>();
    final List<IBytecodeTransformer> bytecodeTransformer = new ArrayList<IBytecodeTransformer>();
    final Map<String, List<IRawTransformer>> rawTransformer = new HashMap<String, List<IRawTransformer>>();
    final Map<String, List<ClassNode>> transformer = new HashMap<String, List<ClassNode>>();
    final List<IPostTransformer> postTransformer = new ArrayList<IPostTransformer>();
    final Set<String> registeredTransformer = new HashSet<String>();
    final Set<String> transformedClasses = new HashSet<String>();

    public TransformerManager(IClassProvider classProvider) {
        this(classProvider, new VoidMapper());
    }

    public TransformerManager(IClassProvider classProvider, AMapper mapper) {
        this.classProvider = classProvider;
        this.mapper = mapper;
        this.mapper.load();
        this.annotationHandler.add(new CASMAnnotationHandler(CASM.Shift.TOP));
        this.annotationHandler.add(new InnerClassGeneralHandler());
        this.annotationHandler.add(new SyntheticMethodGeneralHandler());
        this.annotationHandler.add(new CShadowAnnotationHandler());
        this.annotationHandler.add(new CRecordComponentAnnotationHandler());
        this.annotationHandler.add(new MemberCopyGeneralHandler(true));
        this.annotationHandler.add(new COverrideAnnotationHandler());
        this.annotationHandler.add(new CWrapCatchAnnotationHandler());
        this.annotationHandler.add(new CInjectAnnotationHandler());
        this.annotationHandler.add(new CModifyExpressionValueAnnotationHandler());
        this.annotationHandler.add(new CModifyConstantAnnotationHandler());
        this.annotationHandler.add(new CWrapConditionAnnotationHandler());
        this.annotationHandler.add(new CRedirectAnnotationHandler());
        this.annotationHandler.add(new CUpgradeAnnotationHandler());
        this.annotationHandler.add(new MemberCopyGeneralHandler(false));
        this.annotationHandler.add(new CInlineAnnotationHandler());
        this.annotationHandler.add(new CReplaceCallbackAnnotationHandler());
        this.annotationHandler.add(new CASMAnnotationHandler(CASM.Shift.BOTTOM));
        this.coprocessors.add(CLocalVariableCoprocessor::new);
        this.coprocessors.add(CSharedCoprocessor::new);
        this.injectionTargets.put("HEAD", new HeadTarget());
        this.injectionTargets.put("RETURN", new ReturnTarget());
        this.injectionTargets.put("THROW", new ThrowTarget());
        this.injectionTargets.put("TAIL", new TailTarget());
        this.injectionTargets.put("INVOKE", new InvokeTarget());
        this.injectionTargets.put("FIELD", new FieldTarget());
        this.injectionTargets.put("GETFIELD", new FieldTarget(180, 178));
        this.injectionTargets.put("PUTFIELD", new FieldTarget(181, 179));
        this.injectionTargets.put("NEW", new NewTarget());
        this.injectionTargets.put("OPCODE", new OpcodeTarget());
        this.injectionTargets.put("CONSTANT", new ConstantTarget());
    }

    public ClassTree getClassTree() {
        return this.classTree;
    }

    public IClassProvider getClassProvider() {
        return this.classProvider;
    }

    public AMapper getMapper() {
        return this.mapper;
    }

    public Set<String> getRegisteredTransformer() {
        return Collections.unmodifiableSet(this.registeredTransformer);
    }

    public Set<String> getTransformedClasses() {
        return Collections.unmodifiableSet(this.transformedClasses);
    }

    public void addCoprocessor(Supplier<? extends IAnnotationCoprocessor> coprocessorSupplier) {
        this.coprocessors.add(coprocessorSupplier);
    }

    public AnnotationCoprocessorList getCoprocessors() {
        return this.coprocessors.build();
    }

    public Map<String, IInjectionTarget> getInjectionTargets() {
        return Collections.unmodifiableMap(this.injectionTargets);
    }

    public Optional<IInjectionTarget> getInjectionTarget(String name) {
        return Optional.ofNullable(this.injectionTargets.get(name.toUpperCase(Locale.ROOT)));
    }

    public TransformerDebugger getDebugger() {
        return this.debugger;
    }

    public void setFailStrategy(FailStrategy failStrategy) {
        this.failStrategy = failStrategy;
    }

    public FailStrategy getFailStrategy() {
        return this.failStrategy;
    }

    @Nullable
    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public void addTransformerPreprocessor(IAnnotationHandlerPreprocessor annotationHandlerPreprocessor) {
        this.annotationHandlerPreprocessor.add(annotationHandlerPreprocessor);
    }

    public void addBytecodeTransformer(IBytecodeTransformer bytecodeTransformer) {
        this.bytecodeTransformer.add(bytecodeTransformer);
    }

    public void addClassFileTransformer(final ClassLoader classLoader, final ClassFileTransformer classFileTransformer) {
        this.addBytecodeTransformer(new IBytecodeTransformer(){

            @Override
            public byte[] transform(String className, byte[] bytecode, boolean calculateStackMapFrames) {
                return classFileTransformer.transform(classLoader, ASMUtils.slash(className), null, null, bytecode);
            }
        });
    }

    public void addRawTransformer(String className, IRawTransformer rawTransformer) {
        this.rawTransformer.computeIfAbsent(className, n -> new ArrayList()).add(rawTransformer);
        this.transformedClasses.add(className);
        this.retransformClasses(Collections.singleton(className));
    }

    public void addTransformer(String transformer) {
        String packageName;
        ArrayList<byte[]> classes = new ArrayList<byte[]>();
        boolean wildcard = false;
        if (transformer.endsWith(".**")) {
            wildcard = true;
            packageName = transformer.substring(0, transformer.length() - 2);
            for (Map.Entry<String, Supplier<byte[]>> entry : this.classProvider.getAllClasses().entrySet()) {
                try {
                    if (!entry.getKey().startsWith(packageName)) continue;
                    classes.add(entry.getValue().get());
                }
                catch (Throwable t) {
                    throw new TransformerLoadException(entry.getKey(), t);
                }
            }
        } else if (transformer.endsWith(".*")) {
            wildcard = true;
            packageName = transformer.substring(0, transformer.length() - 1);
            for (Map.Entry<String, Supplier<byte[]>> entry : this.classProvider.getAllClasses().entrySet()) {
                if (!entry.getKey().startsWith(packageName)) continue;
                try {
                    String classPackage = entry.getKey().substring(0, entry.getKey().lastIndexOf(46) + 1);
                    if (!classPackage.equals(packageName)) continue;
                    classes.add(entry.getValue().get());
                }
                catch (Throwable t) {
                    throw new TransformerLoadException(entry.getKey(), t);
                }
            }
        } else {
            try {
                classes.add(this.classProvider.getClass(transformer));
            }
            catch (ClassNotFoundException e) {
                throw new TransformerLoadException(transformer, e);
            }
        }
        for (byte[] bytecode : classes) {
            String name = null;
            try {
                ClassNode classNode = ASMUtils.fromBytes(bytecode);
                name = classNode.name;
                Set<String> transformedClasses = this.addTransformer(classNode, !wildcard);
                if (!transformedClasses.isEmpty()) {
                    this.retransformClasses(transformedClasses);
                    continue;
                }
                if (wildcard) continue;
                Logger.warn("Transformer '{}' does not transform any classes", name);
            }
            catch (Throwable e) {
                if (name == null) {
                    throw new RuntimeException("Unable to parse transformer bytecode", e);
                }
                throw new TransformerLoadException(name, e);
            }
        }
    }

    public Set<String> addTransformer(ClassNode classNode) {
        return this.addTransformer(classNode, true);
    }

    public Set<String> addTransformer(ClassNode classNode, boolean requireAnnotation) {
        for (IAnnotationHandlerPreprocessor preprocessor : this.annotationHandlerPreprocessor) {
            preprocessor.process(classNode);
            classNode = preprocessor.replace(classNode);
        }
        Optional<AnnotationNode> opt = AnnotationUtils.findAnnotation(classNode, CTransformer.class);
        if (!opt.isPresent()) {
            if (requireAnnotation) {
                throw new IllegalStateException("Transformer does not have CTransformer annotation");
            }
            return Collections.emptySet();
        }
        List annotation = opt.map(a -> a.values).orElseGet(Collections::emptyList);
        HashSet<String> transformedClasses = new HashSet<String>();
        for (int i = 0; i < annotation.size(); i += 2) {
            List classesList;
            String key = (String)annotation.get(i);
            Object value = annotation.get(i + 1);
            if (key.equals("value")) {
                classesList = (List)value;
                for (Type type : classesList) {
                    this.addTransformer(transformedClasses, this.mapper.mapClassName(type.getClassName()), classNode);
                }
                continue;
            }
            if (!key.equals("name")) continue;
            classesList = (List)value;
            for (String className : classesList) {
                this.addTransformer(transformedClasses, this.mapper.mapClassName(className), classNode);
            }
        }
        this.transformedClasses.addAll(transformedClasses);
        String name = ASMUtils.dot(classNode.name);
        this.registeredTransformer.add(name);
        if (this.hotswapClassLoader != null) {
            this.hotswapClassLoader.defineHotswapClass(name);
        }
        return transformedClasses;
    }

    private void addTransformer(Set<String> transformedClasses, String className, ClassNode transformer) {
        List transformerList = this.transformer.computeIfAbsent(className, n -> new ArrayList());
        transformerList.removeIf(cn -> cn.name.equals(transformer.name));
        transformerList.add(transformer);
        transformedClasses.add(className);
    }

    public void addPostTransformConsumer(IPostTransformer postTransformer) {
        this.postTransformer.add(postTransformer);
    }

    public void addCustomAnnotationHandler(AnnotationHandler transformer, HandlerPosition handlerPosition) {
        handlerPosition.add(this.annotationHandler, transformer);
    }

    public void addInjectionTarget(String name, IInjectionTarget target) {
        this.injectionTargets.put(name.toUpperCase(Locale.ROOT), target);
    }

    @Nullable
    public byte[] transform(String name, byte[] bytecode) {
        return this.transform(name, bytecode, true);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public byte[] transform(String name, byte[] bytecode, boolean calculateStackMapFrames) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void hookInstrumentation(Instrumentation instrumentation) {
        this.hookInstrumentation(instrumentation, false);
    }

    public void hookInstrumentation(Instrumentation instrumentation, boolean hotswappable) {
        this.instrumentation = instrumentation;
        if (hotswappable) {
            this.hotswapClassLoader = new HotswapClassLoader();
            for (String transformerClass : this.registeredTransformer) {
                this.hotswapClassLoader.defineHotswapClass(transformerClass);
            }
        }
        instrumentation.addTransformer(this, instrumentation.isRetransformClassesSupported());
        this.retransformClasses(null);
    }

    private void retransformClasses(@Nullable Set<String> classesToRetransform) {
        block5: {
            if (this.instrumentation != null && this.instrumentation.isRetransformClassesSupported()) {
                ArrayList<Class> classes = new ArrayList<Class>();
                Set<String> classSet = classesToRetransform != null ? classesToRetransform : this.transformedClasses;
                for (Class loadedClass : this.instrumentation.getAllLoadedClasses()) {
                    if (loadedClass == null || !classSet.contains(loadedClass.getName())) continue;
                    classes.add(loadedClass);
                }
                if (!classes.isEmpty()) {
                    try {
                        this.instrumentation.retransformClasses(classes.toArray(new Class[0]));
                    }
                    catch (Throwable t) {
                        Logger.error("Failed to retransform classes '{}'", classes.stream().map(Class::getName).collect(Collectors.joining(", ")), t);
                        if (!FailStrategy.EXIT.equals((Object)this.failStrategy)) break block5;
                        System.exit(-1);
                    }
                }
            }
        }
    }

    private void redefineClasses(Set<String> classesToRedefine) throws UnmodifiableClassException, ClassNotFoundException {
        ArrayList<ClassDefinition> classDefinitions = new ArrayList<ClassDefinition>();
        for (Class loadedClass : this.instrumentation.getAllLoadedClasses()) {
            byte[] transformedBytecode;
            if (loadedClass == null || !classesToRedefine.contains(loadedClass.getName()) || (transformedBytecode = this.transform(loadedClass.getName(), this.classProvider.getClass(loadedClass.getName()))) == null) continue;
            classDefinitions.add(new ClassDefinition(loadedClass, transformedBytecode));
        }
        if (!classDefinitions.isEmpty()) {
            this.instrumentation.redefineClasses(classDefinitions.toArray(new ClassDefinition[0]));
        }
    }

    @Override
    @Nullable
    public byte[] transform(@Nullable ClassLoader loader, @Nullable String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        block7: {
            if (className == null) {
                return null;
            }
            try {
                className = ASMUtils.dot(className);
                if (this.hotswapClassLoader != null && this.registeredTransformer.contains(className)) {
                    try {
                        ClassNode transformer = ASMUtils.fromBytes(classfileBuffer);
                        Set<String> transformedClasses = this.addTransformer(transformer);
                        this.redefineClasses(transformedClasses);
                        return this.hotswapClassLoader.getHotswapClass(transformer.name);
                    }
                    catch (Throwable t) {
                        Logger.error("Failed to hotswap transformer '{}'", className, t);
                        return new byte[]{1};
                    }
                }
                byte[] newBytes = this.transform(className, classfileBuffer);
                if (newBytes != null) {
                    return newBytes;
                }
            }
            catch (Throwable t) {
                Logger.error("Failed to transform class '{}'", className, t);
                if (!FailStrategy.EXIT.equals((Object)this.failStrategy)) break block7;
                System.exit(-1);
            }
        }
        return null;
    }
}

