/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.check.impl.timer;

import ac.boar.anticheat.check.api.annotations.CheckInfo;
import ac.boar.anticheat.check.api.annotations.Experimental;
import ac.boar.anticheat.check.api.impl.PacketCheck;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.protocol.event.CloudburstPacketEvent;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.NetworkStackLatencyPacket;

@Experimental
@CheckInfo(name="Timer")
public final class Timer
extends PacketCheck {
    private static final long AVERAGE_DISTANCE = 50000000L;
    private long lastNS;
    private long balance;
    private long prevTick;
    private boolean sentBeforeInput = true;
    private long cachedLatencyId = -1L;
    private long lastLatencyTime;

    public Timer(BoarPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceived(CloudburstPacketEvent event) {
        BedrockPacket bedrockPacket;
        if (!event.isCancelled() || !((bedrockPacket = event.getPacket()) instanceof NetworkStackLatencyPacket)) {
            return;
        }
        NetworkStackLatencyPacket packet = (NetworkStackLatencyPacket)bedrockPacket;
        long id = Math.abs(packet.getTimestamp() / 1000000L);
        if (id >= this.cachedLatencyId) {
            this.cachedLatencyId = -1L;
            this.lastNS = Math.max(this.lastNS, this.player.getLatencyUtil().getLastSentTime());
        }
    }

    @Override
    public void onPacketSend(CloudburstPacketEvent event, boolean immediate) {
        BedrockPacket bedrockPacket = event.getPacket();
        if (!(bedrockPacket instanceof NetworkStackLatencyPacket)) {
            return;
        }
        NetworkStackLatencyPacket packet = (NetworkStackLatencyPacket)bedrockPacket;
        long absTimestamp = Math.abs(packet.getTimestamp());
        if (packet.getTimestamp() > 0L || !this.player.getLatencyUtil().hasId(absTimestamp) || !packet.isFromServer()) {
            return;
        }
        if (this.sentBeforeInput) {
            this.cachedLatencyId = absTimestamp;
            this.sentBeforeInput = false;
        }
    }

    public boolean isInvalid() {
        if (this.lastNS == 0L || this.player.inLoadingScreen || this.player.sinceLoadingScreen < 20) {
            this.lastNS = System.nanoTime();
            this.prevTick = this.player.tick;
            this.balance = 0L;
            this.sentBeforeInput = true;
            return false;
        }
        this.sentBeforeInput = true;
        boolean valid = true;
        long distance = System.nanoTime() - this.lastNS;
        long neededDistance = (this.player.tick - this.prevTick) * 50000000L;
        if ((double)this.balance > 6.3E7) {
            this.fail("balance=" + this.balance + ", player is ahead!");
            this.player.getTeleportUtil().teleportTo(this.player.getTeleportUtil().getLastKnowValid());
            this.balance -= 50000000L;
            valid = false;
        }
        this.balance -= distance - neededDistance;
        this.lastNS = System.nanoTime();
        this.prevTick = this.player.tick;
        return !valid;
    }
}

