/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.check.impl.reach;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.check.api.annotations.CheckInfo;
import ac.boar.anticheat.check.api.annotations.Experimental;
import ac.boar.anticheat.check.api.impl.PacketCheck;
import ac.boar.anticheat.compensated.cache.entity.EntityCache;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.MathUtil;
import ac.boar.anticheat.util.Pair;
import ac.boar.anticheat.util.math.ReachUtil;
import ac.boar.anticheat.util.math.Vec3;
import ac.boar.protocol.event.CloudburstPacketEvent;
import java.util.HashMap;
import java.util.Map;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.cloudburstmc.protocol.bedrock.data.InputMode;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.InventoryTransactionType;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.InteractPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventoryTransactionPacket;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;

@Experimental
@CheckInfo(name="Reach")
public final class Reach
extends PacketCheck {
    private final Map<Pair<Vec3, Vec3>, EntityCache> queuedHitAttacks = new HashMap<Pair<Vec3, Vec3>, EntityCache>();
    private boolean lastKnowHitWasValid;

    public Reach(BoarPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceived(CloudburstPacketEvent event) {
        InteractPacket packet;
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof InteractPacket && (packet = (InteractPacket)bedrockPacket).getAction() == InteractPacket.Action.DAMAGE) {
            event.setCancelled(true);
        }
        if (!((bedrockPacket = event.getPacket()) instanceof InventoryTransactionPacket) || (packet = (InventoryTransactionPacket)bedrockPacket).getActionType() != 1 || packet.getTransactionType() != InventoryTransactionType.ITEM_USE_ON_ENTITY) {
            return;
        }
        EntityCache entity = this.player.compensatedWorld.getEntity(packet.getRuntimeEntityId());
        if (entity == null || entity.isInVehicle()) {
            return;
        }
        if (this.player.gameType == GameType.CREATIVE || this.player.gameType == GameType.SPECTATOR) {
            return;
        }
        if (this.player.inputMode == InputMode.TOUCH && MathUtil.wrapDegrees(Math.abs(this.player.yaw - this.player.interactRotation.getY())) > 110.0f) {
            this.lastKnowHitWasValid = false;
            event.setCancelled(true);
            return;
        }
        Pair<Vec3, Vec3> pair = new Pair<Vec3, Vec3>(this.player.prevPosition, this.player.position);
        this.queuedHitAttacks.put(pair, entity);
        if (ReachUtil.calculateReach(this.player, pair, entity) > Boar.getConfig().toleranceReach()) {
            if (!this.lastKnowHitWasValid) {
                event.setCancelled(true);
            }
            this.lastKnowHitWasValid = false;
        } else {
            this.lastKnowHitWasValid = true;
        }
    }

    public void pollQueuedHits() {
        this.lastKnowHitWasValid = false;
        if (this.queuedHitAttacks.isEmpty()) {
            return;
        }
        float hitDistance = 0.0f;
        for (Map.Entry<Pair<Vec3, Vec3>, EntityCache> entry : this.queuedHitAttacks.entrySet()) {
            EntityCache entity = entry.getValue();
            if (entity == null || entity.getType() != EntityType.PLAYER) continue;
            Boar.debug("Step=" + entity.getCurrent().getInterpolator().getStep(), Boar.DebugMessage.INFO);
            Boar.debug("Prev=" + String.valueOf(entity.getCurrent().getPrevPos()) + ", current=" + String.valueOf(entity.getCurrent().getPos()) + ", lerpingTo=" + String.valueOf(entity.getCurrent().getInterpolator().getTargetPos()), Boar.DebugMessage.INFO);
            float newReachDistance = ReachUtil.calculateReach(this.player, entry.getKey(), entry.getValue());
            if (newReachDistance == Float.MAX_VALUE && entity.getCurrent().getInterpolator().getStep() > 1) continue;
            hitDistance = Math.max(newReachDistance, hitDistance);
        }
        if (hitDistance > Boar.getConfig().toleranceReach()) {
            if (hitDistance == Float.MAX_VALUE) {
                this.fail("failed to find entity in sight.");
            } else {
                this.fail("entity out of range, distance=" + hitDistance);
            }
        } else {
            Boar.debug("Valid hit distance=" + hitDistance, Boar.DebugMessage.INFO);
        }
        this.queuedHitAttacks.clear();
    }
}

