/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.packets.input;

import ac.boar.anticheat.check.impl.reach.Reach;
import ac.boar.anticheat.check.impl.timer.Timer;
import ac.boar.anticheat.data.input.PredictionData;
import ac.boar.anticheat.packets.input.legacy.LegacyAuthInputPackets;
import ac.boar.anticheat.packets.input.teleport.TeleportHandler;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.prediction.PredictionRunner;
import ac.boar.anticheat.prediction.engine.data.Vector;
import ac.boar.anticheat.teleport.data.TeleportCache;
import ac.boar.anticheat.util.DimensionUtil;
import ac.boar.anticheat.util.math.Vec3;
import ac.boar.protocol.event.CloudburstPacketEvent;
import ac.boar.protocol.listener.PacketListener;
import java.util.Iterator;
import java.util.Map;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ChangeDimensionPacket;
import org.cloudburstmc.protocol.bedrock.packet.MovePlayerPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.level.BedrockDimension;

public class AuthInputPackets
extends TeleportHandler
implements PacketListener {
    @Override
    public void onPacketReceived(CloudburstPacketEvent event) {
        if (event.isCancelled()) {
            return;
        }
        BoarPlayer player = event.getPlayer();
        BedrockPacket bedrockPacket = event.getPacket();
        if (!(bedrockPacket instanceof PlayerAuthInputPacket)) {
            return;
        }
        PlayerAuthInputPacket packet = (PlayerAuthInputPacket)bedrockPacket;
        ++player.sinceLoadingScreen;
        long claimedTick = packet.getTick();
        if (claimedTick < 0L || claimedTick <= player.tick) {
            player.kick("Impossible tick id=" + claimedTick);
            return;
        }
        long distanceSincePrev = System.currentTimeMillis() - player.sinceAuthInput;
        player.tick = distanceSincePrev < 50L ? ++player.tick : (player.tick += Math.min(claimedTick - player.tick, distanceSincePrev / 30L));
        player.sinceAuthInput = System.currentTimeMillis();
        if (player.tick != packet.getTick()) {
            player.kick("Invalid tick id, predicted=" + player.tick + ", actual=" + packet.getTick());
            return;
        }
        Timer timer = (Timer)player.getCheckHolder().get(Timer.class);
        if (timer != null && timer.isInvalid()) {
            event.setCancelled(true);
            return;
        }
        if (player.serverBreakBlockValidator != null) {
            player.serverBreakBlockValidator.handle(packet);
        }
        LegacyAuthInputPackets.processAuthInput(player, packet, true);
        LegacyAuthInputPackets.updateUnvalidatedPosition(player, packet);
        ((Reach)player.getCheckHolder().get(Reach.class)).pollQueuedHits();
        player.tick();
        if (player.vehicleData != null) {
            player.position = player.unvalidatedPosition;
            return;
        }
        if (player.getSession().getPlayerEntity().getBedPosition() != null) {
            return;
        }
        if (player.isMovementExempted()) {
            Map.Entry entry;
            player.setPos(player.unvalidatedPosition);
            Iterator iterator = player.queuedVelocities.entrySet().iterator();
            while (iterator.hasNext() && (entry = iterator.next()) != null && (Long)entry.getKey() < player.receivedStackId.get()) {
                iterator.remove();
            }
            player.predictionResult = new PredictionData(Vec3.ZERO, player.velocity.y < 0.0f && player.getInputData().contains(PlayerAuthInputData.VERTICAL_COLLISION) ? new Vec3(0.0f, 1.0f, 0.0f) : Vec3.ZERO, player.unvalidatedTickEnd);
            player.velocity = player.unvalidatedTickEnd.clone();
            player.bestPossibility = Vector.NONE;
        } else if (!player.inLoadingScreen && player.sinceLoadingScreen >= 2 || player.unvalidatedTickEnd.lengthSquared() > 0.0f) {
            new PredictionRunner(player).run();
        } else {
            player.velocity = Vec3.ZERO.clone();
        }
        boolean bl = player.insideUnloadedChunk = !player.compensatedWorld.isChunkLoaded((int)player.position.x, (int)player.position.z);
        if (player.insideUnloadedChunk) {
            player.getTeleportUtil().teleportTo(player.getTeleportUtil().getLastKnowValid());
        }
        this.processQueuedTeleports(player, packet);
        LegacyAuthInputPackets.doPostPrediction(player, packet);
    }

    @Override
    public void onPacketSend(CloudburstPacketEvent event, boolean immediate) {
        ChangeDimensionPacket packet;
        BoarPlayer player = event.getPlayer();
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof ChangeDimensionPacket) {
            packet = (ChangeDimensionPacket)bedrockPacket;
            int dimensionId = packet.getDimension();
            BedrockDimension dimension = DimensionUtil.dimensionFromId(dimensionId);
            player.sendLatencyStack(immediate);
            player.getTeleportUtil().getQueuedTeleports().add(new TeleportCache.DimensionSwitch(player.sentStackId.get(), new Vec3(packet.getPosition().up(EntityDefinitions.PLAYER.offset()))));
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> {
                if (player.compensatedWorld.getDimension() != dimension) {
                    player.currentLoadingScreen = packet.getLoadingScreenId();
                    player.inLoadingScreen = true;
                }
                player.compensatedWorld.getChunks().clear();
                player.compensatedWorld.setDimension(dimension);
                player.getFlagTracker().clear();
                player.getFlagTracker().flying(false);
            });
        }
        if ((bedrockPacket = event.getPacket()) instanceof MovePlayerPacket) {
            packet = (MovePlayerPacket)bedrockPacket;
            if (packet.getMode() == MovePlayerPacket.Mode.HEAD_ROTATION) {
                return;
            }
            if (player.runtimeEntityId != packet.getRuntimeEntityId()) {
                return;
            }
            if (packet.getMode() == MovePlayerPacket.Mode.NORMAL) {
                packet.setMode(MovePlayerPacket.Mode.TELEPORT);
            }
            player.getTeleportUtil().queueTeleport(new Vec3(packet.getPosition()), immediate);
        }
    }
}

