/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.packets.server;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.compensated.world.CompensatedWorldImpl;
import ac.boar.anticheat.compensated.world.base.CompensatedWorld;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.DimensionUtil;
import ac.boar.anticheat.util.geyser.BlockStorage;
import ac.boar.anticheat.util.geyser.BoarChunk;
import ac.boar.anticheat.util.geyser.BoarChunkSection;
import ac.boar.anticheat.util.math.Vec3;
import ac.boar.protocol.event.CloudburstPacketEvent;
import ac.boar.protocol.listener.PacketListener;
import ac.boar.shaded.fastutil.ints.IntArrayList;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.ServerboundLoadingScreenPacketType;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BlockEntityDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelChunkPacket;
import org.cloudburstmc.protocol.bedrock.packet.NetworkChunkPublisherUpdatePacket;
import org.cloudburstmc.protocol.bedrock.packet.ServerboundLoadingScreenPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.cloudburstmc.protocol.common.util.VarInts;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.level.chunk.bitarray.BitArray;
import org.geysermc.geyser.level.chunk.bitarray.BitArrayVersion;
import org.geysermc.geyser.level.chunk.bitarray.SingletonBitArray;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityInfo;

public class ServerChunkPackets
implements PacketListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPacketSend(CloudburstPacketEvent event, boolean immediate) {
        BedrockPacket bedrockPacket;
        BedrockPacket subChunksCount2;
        NetworkChunkPublisherUpdatePacket packet;
        BoarPlayer player = event.getPlayer();
        CompensatedWorldImpl world = player.compensatedWorld;
        BedrockPacket bedrockPacket2 = event.getPacket();
        if (bedrockPacket2 instanceof NetworkChunkPublisherUpdatePacket) {
            packet = (NetworkChunkPublisherUpdatePacket)bedrockPacket2;
            player.sendLatencyStack(immediate);
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> {
                world.setCenterX(packet.getPosition().getX() >> 4);
                world.setCenterZ(packet.getPosition().getZ() >> 4);
                world.setRadius(packet.getRadius());
                world.yeetOutOfRangeChunks();
            });
        }
        if ((bedrockPacket2 = event.getPacket()) instanceof LevelChunkPacket) {
            packet = (LevelChunkPacket)bedrockPacket2;
            int subChunksCount2 = packet.getSubChunksLength();
            if (subChunksCount2 <= -2 || packet.getDimension() < 0 || packet.getDimension() > 2) {
                return;
            }
            int x = packet.getChunkX() << 4;
            int z = packet.getChunkZ() << 4;
            if (Math.abs(player.position.x - (float)x) <= 16.0f || Math.abs(player.position.z - (float)z) <= 16.0f) {
                player.sendLatencyStack(immediate);
            }
            BedrockDimension dimension = DimensionUtil.dimensionFromId(packet.getDimension());
            BoarChunkSection[] sections = new BoarChunkSection[dimension.height() >> 4];
            ByteBuf buf = packet.getData().retainedDuplicate();
            try {
                for (int sectionY = 0; sectionY < subChunksCount2; ++sectionY) {
                    buf.readByte();
                    int layerCount = buf.readUnsignedByte();
                    buf.readUnsignedByte();
                    BlockStorage[] layers = new BlockStorage[layerCount];
                    for (int layer = 0; layer < layerCount; ++layer) {
                        layers[layer] = this.readLayer(buf, player.BEDROCK_AIR);
                    }
                    sections[sectionY] = new BoarChunkSection(layers);
                }
            }
            catch (Exception exception) {
            }
            finally {
                buf.release();
            }
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> ServerChunkPackets.lambda$onPacketSend$1(player, (LevelChunkPacket)packet, dimension, world, sections));
        }
        if ((subChunksCount2 = event.getPacket()) instanceof UpdateBlockPacket) {
            boolean send;
            packet = (UpdateBlockPacket)subChunksCount2;
            if (packet.getDataLayer() == 0 && Boar.getConfig().ignoreGhostBlock() && !player.inLoadingScreen && player.sinceLoadingScreen >= 2) {
                int distance;
                boolean newBlockIsAir = player.AIR_IDS.contains(packet.getDefinition().getRuntimeId());
                boolean oldBlockIsAir = player.AIR_IDS.contains(player.compensatedWorld.getRawBlockAt(packet.getBlockPosition().getX(), packet.getBlockPosition().getY(), packet.getBlockPosition().getZ(), 0));
                if (newBlockIsAir && !oldBlockIsAir && (distance = Math.abs(packet.getBlockPosition().getY() - GenericMath.floor((float)(player.position.y - 1.0f)))) <= 1) {
                    player.tickSinceBlockResync = 5;
                    world.updateBlock(packet.getBlockPosition(), packet.getDataLayer(), packet.getDefinition().getRuntimeId());
                }
            }
            boolean bl = send = player.position.distanceTo(new Vec3(packet.getBlockPosition())) <= 16.0f;
            if (send) {
                player.sendLatencyStack(immediate);
            }
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> ServerChunkPackets.lambda$onPacketSend$2(world, (UpdateBlockPacket)packet));
        }
        if ((bedrockPacket = event.getPacket()) instanceof BlockEntityDataPacket) {
            packet = (BlockEntityDataPacket)bedrockPacket;
            player.sendLatencyStack();
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> ServerChunkPackets.lambda$onPacketSend$4(player, (BlockEntityDataPacket)packet));
        }
    }

    @Override
    public void onPacketReceived(CloudburstPacketEvent event) {
        ServerboundLoadingScreenPacket packet;
        BoarPlayer player = event.getPlayer();
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof ServerboundLoadingScreenPacket && (packet = (ServerboundLoadingScreenPacket)bedrockPacket).getType() == ServerboundLoadingScreenPacketType.END_LOADING_SCREEN && Objects.equals(player.currentLoadingScreen, packet.getLoadingScreenId()) && player.inLoadingScreen) {
            player.currentLoadingScreen = null;
            player.inLoadingScreen = false;
            player.sinceLoadingScreen = 0;
        }
    }

    private BlockStorage readLayer(ByteBuf buf, int initialId) {
        int version = buf.readUnsignedByte() >> 1;
        if (version == 127) {
            return null;
        }
        BitArray bitArray = version == 0 ? BitArrayVersion.get((int)version, (boolean)true).createArray(4096, null) : BitArrayVersion.get((int)version, (boolean)true).createArray(4096);
        if (!(bitArray instanceof SingletonBitArray)) {
            for (int i = 0; i < bitArray.getWords().length; ++i) {
                bitArray.getWords()[i] = buf.readIntLE();
            }
        }
        int size = bitArray instanceof SingletonBitArray ? 1 : VarInts.readInt((ByteBuf)buf);
        IntArrayList palette = new IntArrayList(size);
        for (int i = 0; i < size; ++i) {
            palette.add(VarInts.readInt((ByteBuf)buf));
        }
        if (palette.isEmpty()) {
            palette.add(initialId);
        }
        return new BlockStorage(bitArray, palette);
    }

    private static /* synthetic */ void lambda$onPacketSend$4(BoarPlayer player, BlockEntityDataPacket packet) {
        BoarChunk chunk = player.compensatedWorld.getChunk(packet.getBlockPosition().getX() >> 4, packet.getBlockPosition().getZ() >> 4);
        if (chunk == null) {
            return;
        }
        Vector3i pos = packet.getBlockPosition();
        chunk.blockEntities().removeIf(block -> block.getX() == pos.getX() && block.getY() == pos.getY() && block.getZ() == pos.getZ());
        chunk.blockEntities().add(new BlockEntityInfo(pos.getX(), pos.getY(), pos.getZ(), null, packet.getData()));
    }

    private static /* synthetic */ void lambda$onPacketSend$2(CompensatedWorld world, UpdateBlockPacket packet) {
        world.updateBlock(packet.getBlockPosition(), packet.getDataLayer(), packet.getDefinition().getRuntimeId());
    }

    private static /* synthetic */ void lambda$onPacketSend$1(BoarPlayer player, LevelChunkPacket packet, BedrockDimension dimension, CompensatedWorld world, BoarChunkSection[] sections) {
        if (!player.compensatedWorld.isInLoadDistance(packet.getChunkX(), packet.getChunkZ()) || dimension != player.compensatedWorld.getDimension()) {
            return;
        }
        world.put(packet.getChunkX(), packet.getChunkZ(), sections);
    }
}

