/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.transformer.impl;

import ac.boar.shaded.asm.Type;
import ac.boar.shaded.asm.tree.AbstractInsnNode;
import ac.boar.shaded.asm.tree.ClassNode;
import ac.boar.shaded.asm.tree.FieldInsnNode;
import ac.boar.shaded.asm.tree.InsnList;
import ac.boar.shaded.asm.tree.MethodInsnNode;
import ac.boar.shaded.asm.tree.MethodNode;
import ac.boar.shaded.asm.tree.VarInsnNode;
import ac.boar.shaded.classtransform.TransformerManager;
import ac.boar.shaded.classtransform.annotations.injection.CModifyExpressionValue;
import ac.boar.shaded.classtransform.exceptions.InvalidTargetException;
import ac.boar.shaded.classtransform.exceptions.TransformerException;
import ac.boar.shaded.classtransform.targets.IInjectionTarget;
import ac.boar.shaded.classtransform.transformer.coprocessor.AnnotationCoprocessorList;
import ac.boar.shaded.classtransform.transformer.types.RemovingTargetAnnotationHandler;
import ac.boar.shaded.classtransform.utils.ASMUtils;
import ac.boar.shaded.classtransform.utils.Codifier;
import ac.boar.shaded.classtransform.utils.Types;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CModifyExpressionValueAnnotationHandler
extends RemovingTargetAnnotationHandler<CModifyExpressionValue> {
    public CModifyExpressionValueAnnotationHandler() {
        super(CModifyExpressionValue.class, CModifyExpressionValue::method);
    }

    @Override
    public void transform(CModifyExpressionValue annotation, TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer, MethodNode transformerMethod, MethodNode target) {
        AnnotationCoprocessorList coprocessors = transformerManager.getCoprocessors();
        transformerMethod = coprocessors.preprocess(transformerManager, transformedClass, target, transformer, transformerMethod);
        Map<String, IInjectionTarget> injectionTargets = transformerManager.getInjectionTargets();
        IInjectionTarget injectionTarget = injectionTargets.get(annotation.target().value().toUpperCase(Locale.ROOT));
        if (injectionTarget == null) {
            throw new InvalidTargetException(transformerMethod, transformer, annotation.target().target(), injectionTargets.keySet());
        }
        if (Modifier.isStatic(target.access) != Modifier.isStatic(transformerMethod.access)) {
            throw TransformerException.wrongStaticAccess(transformerMethod, transformer, Modifier.isStatic(target.access));
        }
        List<AbstractInsnNode> injectionInstructions = injectionTarget.getTargets(injectionTargets, target, annotation.target(), annotation.slice());
        if (injectionInstructions == null) {
            throw new TransformerException(transformerMethod, transformer, "has invalid member declaration '" + annotation.target().target() + "'").help("e.g. Ljava/lang/String;toString()V, Ljava/lang/Integer;MAX_VALUE:I");
        }
        if (injectionInstructions.isEmpty() && !annotation.target().optional()) {
            throw new TransformerException(transformerMethod, transformer, "target '" + annotation.target().target() + "' could not be found").help("e.g. Ljava/lang/String;toString()V, Ljava/lang/Integer;MAX_VALUE:I");
        }
        ArrayList<MethodInsnNode> transformerMethodCalls = new ArrayList<MethodInsnNode>();
        MethodNode copiedTransformerMethod = this.renameAndCopy(transformerMethod, target, transformer, transformedClass, "CModifyExpressionValue");
        for (AbstractInsnNode injectionInstruction : injectionInstructions) {
            if (injectionInstruction instanceof MethodInsnNode) {
                MethodInsnNode methodInsnNode = (MethodInsnNode)injectionInstruction;
                if (injectionInstruction.getOpcode() == 183 && ((MethodInsnNode)injectionInstruction).name.equals("<init>")) {
                    this.modifyNew(transformedClass, target, transformer, transformerMethod, methodInsnNode, transformerMethodCalls);
                    continue;
                }
                this.modifyInvoke(transformedClass, target, transformer, transformerMethod, methodInsnNode, transformerMethodCalls);
                continue;
            }
            if (injectionInstruction instanceof FieldInsnNode) {
                this.modifyField(transformedClass, target, transformer, transformerMethod, (FieldInsnNode)injectionInstruction, transformerMethodCalls);
                continue;
            }
            throw new InvalidTargetException(transformerMethod, transformer, annotation.target().value(), Arrays.asList("INVOKE", "FIELD", "NEW"));
        }
        coprocessors.postprocess(transformerManager, transformedClass, target, transformerMethodCalls, transformer, copiedTransformerMethod);
    }

    private void modifyInvoke(ClassNode targetClass, MethodNode targetMethod, ClassNode transformer, MethodNode transformerMethod, MethodInsnNode targetNode, List<MethodInsnNode> transformerMethodCalls) {
        Type wrappedType = Types.returnType(targetNode);
        if (wrappedType.equals(Type.VOID_TYPE)) {
            throw new TransformerException(transformerMethod, transformer, "target method returns void");
        }
        boolean castReturnValue = this.checkDescriptor(transformer, transformerMethod, wrappedType);
        InsnList insns = this.getModifyInstructions(targetClass, targetMethod, transformerMethod, wrappedType, castReturnValue, transformerMethodCalls);
        targetMethod.instructions.insert((AbstractInsnNode)targetNode, insns);
    }

    private void modifyField(ClassNode targetClass, MethodNode targetMethod, ClassNode transformer, MethodNode transformerMethod, FieldInsnNode targetNode, List<MethodInsnNode> transformerMethodCalls) {
        Type wrappedType = Types.type(targetNode.desc);
        boolean castReturnValue = this.checkDescriptor(transformer, transformerMethod, wrappedType);
        InsnList insns = this.getModifyInstructions(targetClass, targetMethod, transformerMethod, wrappedType, castReturnValue, transformerMethodCalls);
        if (targetNode.getOpcode() == 181 || targetNode.getOpcode() == 179) {
            targetMethod.instructions.insertBefore((AbstractInsnNode)targetNode, insns);
        } else {
            targetMethod.instructions.insert((AbstractInsnNode)targetNode, insns);
        }
    }

    private void modifyNew(ClassNode targetClass, MethodNode targetMethod, ClassNode transformer, MethodNode transformerMethod, MethodInsnNode targetNode, List<MethodInsnNode> transformerMethodCalls) {
        Type wrappedType = Types.type(targetNode.owner);
        boolean castReturnValue = this.checkDescriptor(transformer, transformerMethod, wrappedType);
        InsnList insns = this.getModifyInstructions(targetClass, targetMethod, transformerMethod, wrappedType, castReturnValue, transformerMethodCalls);
        targetMethod.instructions.insert((AbstractInsnNode)targetNode, insns);
    }

    private boolean checkDescriptor(ClassNode transformer, MethodNode transformerMethod, Type expectedType) {
        Type returnType = Types.returnType(transformerMethod);
        Type[] argumentTypes = Types.argumentTypes(transformerMethod);
        if (argumentTypes.length != 1) {
            throw new TransformerException(transformerMethod, transformer, "does not have exactly one argument").help(Codifier.of(transformerMethod).returnType(expectedType).params(null, expectedType));
        }
        if (!ASMUtils.compareType(expectedType, argumentTypes[0])) {
            throw new TransformerException(transformerMethod, transformer, "does not have the right argument type").help(Codifier.of(transformerMethod).returnType(expectedType).params(null, expectedType));
        }
        if (!ASMUtils.compareType(expectedType, returnType)) {
            throw new TransformerException(transformerMethod, transformer, "does not have the right return type").help(Codifier.of(transformerMethod).returnType(expectedType).params(null, expectedType));
        }
        return !returnType.equals(expectedType);
    }

    private InsnList getModifyInstructions(ClassNode targetClass, MethodNode targetMethod, MethodNode transformerMethod, Type wrappedType, boolean castReturnValue, List<MethodInsnNode> transformerMethodCalls) {
        MethodInsnNode transformerCall;
        InsnList insns = new InsnList();
        if (Modifier.isStatic(targetMethod.access)) {
            transformerCall = new MethodInsnNode(184, targetClass.name, transformerMethod.name, transformerMethod.desc, Modifier.isInterface(targetClass.access));
        } else {
            insns.add(new VarInsnNode(25, 0));
            insns.add(ASMUtils.swap(wrappedType, Types.T_Object));
            transformerCall = new MethodInsnNode(Modifier.isInterface(targetClass.access) ? 185 : 182, targetClass.name, transformerMethod.name, transformerMethod.desc);
        }
        insns.add(transformerCall);
        transformerMethodCalls.add(transformerCall);
        if (castReturnValue) {
            insns.add(ASMUtils.getCast(wrappedType));
        }
        return insns;
    }
}

