/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.utils.mappings;

import ac.boar.shaded.asm.Type;
import ac.boar.shaded.asm.tree.ClassNode;
import ac.boar.shaded.asm.tree.FieldNode;
import ac.boar.shaded.asm.tree.MethodNode;
import ac.boar.shaded.classtransform.annotations.CTransformer;
import ac.boar.shaded.classtransform.utils.ASMUtils;
import ac.boar.shaded.classtransform.utils.annotations.AnnotationUtils;
import ac.boar.shaded.classtransform.utils.mappings.MapRemapper;
import ac.boar.shaded.classtransform.utils.tree.ClassTree;
import ac.boar.shaded.classtransform.utils.tree.IClassProvider;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SuperMappingFiller {
    public static void fillTransformerSuperMembers(ClassNode transformer, MapRemapper remapper, ClassTree classTree, IClassProvider classProvider) throws ClassNotFoundException {
        List annotation = AnnotationUtils.findAnnotation(transformer, CTransformer.class).map(a -> a.values).orElseThrow(() -> new IllegalStateException("Transformer does not have CTransformer annotation"));
        for (int i = 0; i < annotation.size(); i += 2) {
            List classesList;
            String key = (String)annotation.get(i);
            Object value = annotation.get(i + 1);
            if (key.equals("value")) {
                classesList = (List)value;
                for (Type type : classesList) {
                    SuperMappingFiller.fillSuperMembers(type.getInternalName(), remapper, classTree, classProvider);
                }
                continue;
            }
            if (!key.equals("name")) continue;
            classesList = (List)value;
            for (String className : classesList) {
                SuperMappingFiller.fillSuperMembers(ASMUtils.slash(className), remapper, classTree, classProvider);
            }
        }
    }

    public static void fillSuperMembers(String className, MapRemapper remapper, ClassTree classTree, IClassProvider classProvider) throws ClassNotFoundException {
        ClassTree.TreePart treePart = classTree.getTreePart(classProvider, remapper.mapSafe(className));
        Set<ClassNode> superClasses = treePart.getParsedSuperClasses(classProvider, false).stream().map(ClassTree.TreePart::getNode).collect(Collectors.toSet());
        SuperMappingFiller.fillSuperMembers(treePart.getNode(), superClasses, remapper);
    }

    public static void fillSuperMembers(ClassNode node, Set<ClassNode> superClasses, MapRemapper remapper) {
        MapRemapper reverseRemapper = remapper.reverse();
        HashSet<String> mappedFields = new HashSet<String>();
        HashSet<String> mappedMethods = new HashSet<String>();
        for (ClassNode superClass : superClasses) {
            String mappedDesc;
            String mappedOwner;
            String mappedName;
            for (FieldNode field : superClass.fields) {
                if (Modifier.isPrivate(field.access) || field.name.equals(mappedName = reverseRemapper.mapFieldName(superClass.name, field.name, field.desc))) continue;
                mappedOwner = reverseRemapper.mapSafe(node.name);
                mappedDesc = reverseRemapper.mapDesc(field.desc);
                if (!mappedFields.add(field.name + field.desc)) continue;
                remapper.addFieldMapping(mappedOwner, mappedName, mappedDesc, field.name, true);
            }
            for (MethodNode method : superClass.methods) {
                if (Modifier.isPrivate(method.access) || method.name.startsWith("<") || method.name.equals(mappedName = reverseRemapper.mapMethodName(superClass.name, method.name, method.desc))) continue;
                mappedOwner = reverseRemapper.mapSafe(node.name);
                mappedDesc = reverseRemapper.mapMethodDesc(method.desc);
                if (!mappedMethods.add(method.name + method.desc)) continue;
                remapper.addMethodMapping(mappedOwner, mappedName, mappedDesc, method.name, true);
            }
        }
    }

    public static void fillAllSuperMembers(MapRemapper remapper, ClassTree classTree, IClassProvider classProvider) {
        CachedMapRemapper cachedRemapper = new CachedMapRemapper(remapper);
        for (String clazz : remapper.getMentionedClasses()) {
            String obfClass = remapper.mapSafe(clazz);
            try {
                ClassTree.TreePart treePart = classTree.getTreePart(classProvider, obfClass);
                Set<ClassTree.TreePart> superClassParts = treePart.getParsedSuperClasses(classProvider, false);
                LinkedHashSet<ClassNode> superClasses = new LinkedHashSet<ClassNode>();
                for (ClassTree.TreePart part : superClassParts) {
                    superClasses.add(part.getNode());
                }
                SuperMappingFiller.fillSuperMembers(treePart.getNode(), superClasses, cachedRemapper);
            }
            catch (Throwable throwable) {}
        }
    }

    private static class CachedMapRemapper
    extends MapRemapper {
        private final MapRemapper remapper;
        private final MapRemapper reverse;

        public CachedMapRemapper(MapRemapper remapper) {
            super(Collections.emptyMap());
            this.remapper = remapper;
            this.reverse = new MapRemapper(remapper.reverse().getMappings());
        }

        @Override
        public void addFieldMapping(String owner, String name, String desc, String target, boolean skipIfExists) {
            this.remapper.addFieldMapping(owner, name, desc, target, skipIfExists);
        }

        @Override
        public void addMethodMapping(String owner, String name, String desc, String target, boolean skipIfExists) {
            this.remapper.addMethodMapping(owner, name, desc, target, skipIfExists);
        }

        @Override
        @Nonnull
        public MapRemapper reverse() {
            return this.reverse;
        }
    }
}

