/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.check.api;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.check.api.annotations.CheckInfo;
import ac.boar.anticheat.check.api.annotations.Experimental;
import ac.boar.anticheat.player.BoarPlayer;

public class Check {
    protected final BoarPlayer player;
    private final String name;
    private final String type;
    private final boolean experimental;
    private int vl = 0;

    public Check(BoarPlayer player) {
        this.player = player;
        this.name = this.getClass().getDeclaredAnnotation(CheckInfo.class).name();
        this.type = this.getClass().getDeclaredAnnotation(CheckInfo.class).type();
        this.experimental = this.getClass().getDeclaredAnnotation(Experimental.class) != null;
    }

    public Check(BoarPlayer player, String name, String type, boolean experimental) {
        this.player = player;
        this.name = name;
        this.type = type;
        this.experimental = experimental;
    }

    public void fail() {
        this.fail("");
    }

    public void fail(String verbose) {
        ++this.vl;
        StringBuilder builder = new StringBuilder("\u00a73" + this.getDisplayName() + "\u00a77 failed\u00a76 " + this.name);
        if (!this.type.isBlank()) {
            builder.append(" (").append(this.type).append(")");
        }
        if (this.experimental) {
            builder.append(" \u00a7a(Experimental)");
        }
        builder.append(" \u00a77x").append(this.vl).append(" ").append(verbose);
        Boar.getInstance().getAlertManager().alert(builder.toString());
    }

    protected final String getDisplayName() {
        return this.player.getSession().getPlayerEntity().getDisplayName();
    }
}

