/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.prediction.ticker.impl;

import ac.boar.anticheat.collision.util.CuboidBlockIterator;
import ac.boar.anticheat.compensated.CompensatedInventory;
import ac.boar.anticheat.compensated.cache.entity.EntityCache;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.prediction.engine.base.PredictionEngine;
import ac.boar.anticheat.prediction.engine.impl.GlidingPredictionEngine;
import ac.boar.anticheat.prediction.engine.impl.GroundAndAirPredictionEngine;
import ac.boar.anticheat.prediction.engine.impl.fluid.LavaPredictionEngine;
import ac.boar.anticheat.prediction.engine.impl.fluid.WaterPredictionEngine;
import ac.boar.anticheat.prediction.ticker.base.EntityTicker;
import ac.boar.anticheat.util.math.Box;
import ac.boar.anticheat.util.math.Vec3;
import java.util.List;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.inventory.item.BedrockEnchantment;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;

public class LivingTicker
extends EntityTicker {
    public LivingTicker(BoarPlayer player) {
        super(player);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.player.dirtyRiptide && this.player.getInputData().contains(PlayerAuthInputData.START_SPIN_ATTACK)) {
            this.player.getFlagTracker().set(EntityFlag.DAMAGE_NEARBY_MOBS, true);
            int i = CompensatedInventory.getEnchantments(this.player.riptideItem).get(BedrockEnchantment.RIPTIDE);
            float f = 1.5f + 0.75f * (float)(i - 1);
            float g = this.player.rotation.getY();
            float h = this.player.rotation.getX();
            float k = -TrigMath.sin((double)(g * ((float)Math.PI / 180))) * TrigMath.cos((double)(h * ((float)Math.PI / 180)));
            float l = -TrigMath.sin((double)(h * ((float)Math.PI / 180)));
            float m = TrigMath.cos((double)(g * ((float)Math.PI / 180))) * TrigMath.cos((double)(h * ((float)Math.PI / 180)));
            float n = (float)GenericMath.sqrt((double)(k * k + l * l + m * m));
            this.player.velocity = this.player.velocity.add(k * (f / n), l * (f / n), m * (f / n));
            this.player.autoSpinAttackTicks = 20;
            this.player.thisTickSpinAttack = true;
            this.player.thisTickOnGroundSpinAttack = this.player.onGround;
        }
        this.aiStep();
    }

    public void aiStep() {
        this.player.velocity.x = (double)Math.abs(this.player.velocity.x) < 1.0E-8 ? 0.0f : this.player.velocity.x;
        this.player.velocity.y = (double)Math.abs(this.player.velocity.y) < 1.0E-8 ? 0.0f : this.player.velocity.y;
        this.player.velocity.z = (double)Math.abs(this.player.velocity.z) < 1.0E-8 ? 0.0f : this.player.velocity.z;
        this.applyInput();
        if (this.player.getFlagTracker().has(EntityFlag.GLIDING) && this.player.onGround && this.player.getInputData().contains(PlayerAuthInputData.START_JUMPING)) {
            this.player.getTeleportUtil().rewind(this.player.tick - 1L);
        }
        boolean inScaffolding = false;
        boolean onScaffolding = false;
        CuboidBlockIterator iterator = CuboidBlockIterator.iterator(this.player.boundingBox);
        while (iterator.step()) {
            int x = iterator.getX();
            int y = iterator.getY();
            int z = iterator.getZ();
            if (!this.player.compensatedWorld.isChunkLoaded(x, z)) continue;
            int flooredY = GenericMath.floor((float)this.player.position.y);
            BlockState state = this.player.compensatedWorld.getBlockState(x, y, z, 0).getState();
            if (!state.is(Blocks.SCAFFOLDING)) continue;
            if (y == flooredY && this.player.boundingBox.intersects(x, y, z, x + 1, y + 1, z + 1)) {
                inScaffolding = true;
                continue;
            }
            if (y + 1 != flooredY || !this.player.boundingBox.offset(0.0f, -1.0f, 0.0f).intersects(x, y, z, x + 1, y + 1, z + 1)) continue;
            onScaffolding = true;
        }
        if (inScaffolding && this.player.unvalidatedPosition.subtract((Vec3)this.player.prevUnvalidatedPosition).y > 0.0f) {
            if (this.player.getInputData().contains(PlayerAuthInputData.JUMPING) || this.player.getInputData().contains(PlayerAuthInputData.ASCEND_BLOCK)) {
                this.player.velocity.y = 0.15f;
            }
        } else {
            this.player.velocity = this.player.jump(this.player.velocity);
        }
        boolean descending = this.player.getInputData().contains(PlayerAuthInputData.SNEAKING) || this.player.getInputData().contains(PlayerAuthInputData.DESCEND_BLOCK);
        this.player.scaffoldDescend = false;
        BlockState state = this.player.compensatedWorld.getBlockState(this.player.getOnPos(1.0f), 0).getState();
        if (descending) {
            if (state.is(Blocks.POWDER_SNOW) || this.player.getInBlockState().is(Blocks.POWDER_SNOW)) {
                this.player.velocity.y = -0.15f;
            }
            if (onScaffolding && Math.abs(this.player.unvalidatedTickEnd.y) - 0.15f < 0.01f) {
                this.player.velocity.y = -0.15f;
                this.player.scaffoldDescend = true;
            }
        }
        if (this.player.getFlagTracker().has(EntityFlag.GLIDING) && (this.player.onGround || this.player.vehicleData != null || this.player.hasEffect(Effect.LEVITATION))) {
            this.player.getFlagTracker().set(EntityFlag.GLIDING, false);
        }
        this.player.cachedOnPos = null;
        Box oldBox = this.player.boundingBox.clone();
        this.travelRidden();
        this.applyEffectsFromBlocks();
        if (this.player.autoSpinAttackTicks > 0) {
            --this.player.autoSpinAttackTicks;
            this.checkAutoSpinAttack(oldBox, this.player.boundingBox);
        }
    }

    protected final void checkAutoSpinAttack(Box aABB, Box aABB2) {
        Box aABB3 = aABB.union(aABB2);
        List list = this.player.compensatedWorld.getEntities().values().stream().toList();
        if (!list.isEmpty()) {
            for (EntityCache entity : list) {
                if (entity.getCurrent() == null || !entity.getCurrent().getBoundingBox().intersects(aABB3)) continue;
                this.player.dirtySpinStop = true;
                break;
            }
        } else if (this.player.horizontalCollision) {
            this.player.stopRiptide();
        }
        if (this.player.autoSpinAttackTicks <= 0) {
            this.player.stopRiptide();
        }
    }

    protected void travelRidden() {
        this.travel();
    }

    public void applyInput() {
        this.player.input = this.player.input.multiply(0.98f);
    }

    protected void travel() {
        if (this.player.isInLava() || this.player.touchingWater) {
            this.travelInFluid();
        } else if (this.player.getFlagTracker().has(EntityFlag.GLIDING)) {
            this.player.velocity = new GlidingPredictionEngine(this.player).travel(this.player.velocity);
            this.doSelfMove(this.player.velocity.clone());
        } else {
            this.travelInAir();
        }
    }

    private void travelInAir() {
        GroundAndAirPredictionEngine engine = new GroundAndAirPredictionEngine(this.player);
        this.player.velocity = ((PredictionEngine)engine).travel(this.player.velocity);
        this.doSelfMove(this.player.velocity.clone());
        ((PredictionEngine)engine).finalizeMovement();
    }

    private void travelInFluid() {
        float d = this.player.position.y;
        PredictionEngine engine = this.player.touchingWater ? new WaterPredictionEngine(this.player) : new LavaPredictionEngine(this.player);
        this.player.velocity = engine.travel(this.player.velocity);
        this.doSelfMove(this.player.velocity.clone());
        engine.finalizeMovement();
        Vec3 vec33 = this.player.velocity;
        if (this.player.horizontalCollision && this.player.doesNotCollide(vec33.x, vec33.y + 0.6f - this.player.position.y + d, vec33.z)) {
            this.player.velocity.y = 0.3f;
        }
    }
}

