/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.transformer.impl;

import ac.boar.shaded.asm.Type;
import ac.boar.shaded.asm.tree.AbstractInsnNode;
import ac.boar.shaded.asm.tree.ClassNode;
import ac.boar.shaded.asm.tree.InsnList;
import ac.boar.shaded.asm.tree.InsnNode;
import ac.boar.shaded.asm.tree.JumpInsnNode;
import ac.boar.shaded.asm.tree.LabelNode;
import ac.boar.shaded.asm.tree.MethodInsnNode;
import ac.boar.shaded.asm.tree.MethodNode;
import ac.boar.shaded.asm.tree.TryCatchBlockNode;
import ac.boar.shaded.asm.tree.TypeInsnNode;
import ac.boar.shaded.asm.tree.VarInsnNode;
import ac.boar.shaded.classtransform.TransformerManager;
import ac.boar.shaded.classtransform.annotations.injection.CWrapCatch;
import ac.boar.shaded.classtransform.exceptions.TransformerException;
import ac.boar.shaded.classtransform.targets.IInjectionTarget;
import ac.boar.shaded.classtransform.transformer.coprocessor.AnnotationCoprocessorList;
import ac.boar.shaded.classtransform.transformer.types.RemovingTargetAnnotationHandler;
import ac.boar.shaded.classtransform.utils.ASMUtils;
import ac.boar.shaded.classtransform.utils.CTargetImpl;
import ac.boar.shaded.classtransform.utils.Codifier;
import ac.boar.shaded.classtransform.utils.Types;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CWrapCatchAnnotationHandler
extends RemovingTargetAnnotationHandler<CWrapCatch> {
    public CWrapCatchAnnotationHandler() {
        super(CWrapCatch.class, CWrapCatch::value);
    }

    @Override
    public void transform(CWrapCatch annotation, TransformerManager transformerManager, ClassNode transformedClass, ClassNode transformer, MethodNode transformerMethod, MethodNode target) {
        AnnotationCoprocessorList coprocessors = transformerManager.getCoprocessors();
        transformerMethod = coprocessors.preprocess(transformerManager, transformedClass, target, transformer, transformerMethod);
        if (Modifier.isStatic(target.access) != Modifier.isStatic(transformerMethod.access)) {
            throw TransformerException.wrongStaticAccess(transformerMethod, transformer, Modifier.isStatic(target.access));
        }
        Type[] args = Types.argumentTypes(transformerMethod.desc);
        Type returnType = Types.returnType(transformerMethod.desc);
        if (args.length != 1) {
            throw new TransformerException(transformerMethod, transformer, "must have one argument (Exception to catch)").help(Codifier.of(transformerMethod).params(null, Types.type(Exception.class)));
        }
        MethodNode copiedTransformerMethod = null;
        ArrayList<MethodInsnNode> transformerMethodCalls = new ArrayList<MethodInsnNode>();
        if (annotation.target().isEmpty()) {
            MethodInsnNode transformerCall;
            Type targetReturnType = Types.returnType(target.desc);
            if (!ASMUtils.compareType(targetReturnType, returnType)) {
                throw new TransformerException(transformerMethod, transformer, "must have the same return type as the target method").help(Codifier.of(transformerMethod).returnType(targetReturnType));
            }
            boolean cast = !targetReturnType.equals(returnType);
            Type exceptionType = args[0];
            copiedTransformerMethod = this.renameAndCopy(transformerMethod, target, transformer, transformedClass, "CWrapCatch");
            LabelNode start = new LabelNode();
            LabelNode end_handler = new LabelNode();
            target.instructions.insertBefore(target.instructions.getFirst(), start);
            target.instructions.add(end_handler);
            if (Modifier.isStatic(target.access)) {
                transformerCall = new MethodInsnNode(184, transformedClass.name, transformerMethod.name, transformerMethod.desc, Modifier.isInterface(transformedClass.access));
            } else {
                target.instructions.add(new VarInsnNode(25, 0));
                target.instructions.add(new InsnNode(95));
                transformerCall = new MethodInsnNode(Modifier.isInterface(transformedClass.access) ? 185 : 182, transformedClass.name, transformerMethod.name, transformerMethod.desc);
            }
            target.instructions.add(transformerCall);
            if (cast) {
                target.instructions.add(new TypeInsnNode(192, Types.returnType(target.desc).getInternalName()));
            }
            target.instructions.add(new InsnNode(ASMUtils.getReturnOpcode(returnType)));
            target.tryCatchBlocks.add(new TryCatchBlockNode(start, end_handler, end_handler, exceptionType.getInternalName()));
            transformerMethodCalls.add(transformerCall);
        } else {
            Map<String, IInjectionTarget> injectionTargets = transformerManager.getInjectionTargets();
            List<AbstractInsnNode> targetInstructions = injectionTargets.get("INVOKE").getTargets(injectionTargets, target, CTargetImpl.invoke(annotation.target(), annotation.ordinal()), annotation.slice());
            for (AbstractInsnNode instruction : targetInstructions) {
                MethodInsnNode transformerCall;
                Type instructionReturnType = Types.returnType(((MethodInsnNode)instruction).desc);
                if (!ASMUtils.compareType(instructionReturnType, returnType)) {
                    throw new TransformerException(transformerMethod, transformer, "must have the same return type as the target instruction").help(Codifier.of(transformerMethod).returnType(instructionReturnType));
                }
                boolean cast = !instructionReturnType.equals(returnType);
                Type exceptionType = args[0];
                if (copiedTransformerMethod == null) {
                    copiedTransformerMethod = this.renameAndCopy(transformerMethod, target, transformer, transformedClass, "CWrapCatch");
                }
                InsnList insertAfter = new InsnList();
                LabelNode start = new LabelNode();
                LabelNode endHandler = new LabelNode();
                LabelNode jumpAfter = new LabelNode();
                target.instructions.insertBefore(instruction, start);
                insertAfter.add(new JumpInsnNode(167, jumpAfter));
                insertAfter.add(endHandler);
                if (Modifier.isStatic(target.access)) {
                    transformerCall = new MethodInsnNode(184, transformedClass.name, transformerMethod.name, transformerMethod.desc, Modifier.isInterface(transformedClass.access));
                } else {
                    insertAfter.add(new VarInsnNode(25, 0));
                    insertAfter.add(new InsnNode(95));
                    transformerCall = new MethodInsnNode(Modifier.isInterface(transformedClass.access) ? 185 : 182, transformedClass.name, transformerMethod.name, transformerMethod.desc);
                }
                insertAfter.add(transformerCall);
                if (cast) {
                    insertAfter.add(new TypeInsnNode(192, Types.returnType(target.desc).getInternalName()));
                }
                insertAfter.add(new InsnNode(ASMUtils.getReturnOpcode(returnType)));
                insertAfter.add(jumpAfter);
                target.instructions.insert(instruction, insertAfter);
                target.tryCatchBlocks.add(new TryCatchBlockNode(start, endHandler, endHandler, exceptionType.getInternalName()));
                transformerMethodCalls.add(transformerCall);
            }
        }
        coprocessors.postprocess(transformerManager, transformedClass, target, transformerMethodCalls, transformer, copiedTransformerMethod);
    }
}

