/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.utils.tree;

import ac.boar.shaded.asm.ClassWriter;
import ac.boar.shaded.classtransform.utils.ASMUtils;
import ac.boar.shaded.classtransform.utils.Types;
import ac.boar.shaded.classtransform.utils.tree.ClassTree;
import ac.boar.shaded.classtransform.utils.tree.IClassProvider;
import java.lang.reflect.Modifier;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TreeClassWriter
extends ClassWriter {
    private final ClassTree classTree;
    private final IClassProvider classProvider;

    public TreeClassWriter(ClassTree classTree, IClassProvider classProvider) {
        this(2, classTree, classProvider);
    }

    public TreeClassWriter(int flags, ClassTree classTree, IClassProvider classProvider) {
        super(flags);
        this.classTree = classTree;
        this.classProvider = classProvider;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        if (type1.equals(Types.IN_Object) || type2.equals(Types.IN_Object)) {
            return Types.IN_Object;
        }
        ClassTree.TreePart class1 = this.classTree.getTreePart(this.classProvider, type1);
        ClassTree.TreePart class2 = this.classTree.getTreePart(this.classProvider, type2);
        if (class2.getSuperClasses().contains(class1.getName())) {
            return type1;
        }
        if (class1.getSuperClasses().contains(class2.getName())) {
            return type2;
        }
        if (!Modifier.isInterface(class1.getModifiers()) && !Modifier.isInterface(class2.getModifiers())) {
            do {
                if ((class1 = class1.parseSuperClass(this.classProvider)) != null) continue;
                return Types.IN_Object;
            } while (!class2.getSuperClasses().contains(class1.getName()));
            return ASMUtils.slash(class1.getName());
        }
        return Types.IN_Object;
    }
}

