/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.check.impl.reach;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.check.api.annotations.CheckInfo;
import ac.boar.anticheat.check.api.annotations.Experimental;
import ac.boar.anticheat.check.api.impl.PacketCheck;
import ac.boar.anticheat.compensated.cache.entity.EntityCache;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.MathUtil;
import ac.boar.anticheat.util.math.Box;
import ac.boar.anticheat.util.math.Vec3;
import ac.boar.protocol.event.CloudburstPacketEvent;
import java.util.Optional;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.cloudburstmc.protocol.bedrock.data.InputMode;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.InventoryTransactionType;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.InteractPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventoryTransactionPacket;

@Experimental
@CheckInfo(name="Reach")
public final class Reach
extends PacketCheck {
    public Reach(BoarPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceived(CloudburstPacketEvent event) {
        InteractPacket packet;
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof InteractPacket && (packet = (InteractPacket)bedrockPacket).getAction() == InteractPacket.Action.DAMAGE) {
            event.setCancelled(true);
        }
        if (!((bedrockPacket = event.getPacket()) instanceof InventoryTransactionPacket) || (packet = (InventoryTransactionPacket)bedrockPacket).getActionType() != 1 || packet.getTransactionType() != InventoryTransactionType.ITEM_USE_ON_ENTITY) {
            return;
        }
        EntityCache entity = this.player.compensatedWorld.getEntity(packet.getRuntimeEntityId());
        if (entity == null || entity.isInVehicle()) {
            return;
        }
        if (this.player.gameType == GameType.CREATIVE || this.player.gameType == GameType.SPECTATOR) {
            return;
        }
        ReachResult result = this.calculateReach(entity);
        double distance = result.distance();
        if (distance > (double)Boar.getConfig().toleranceReach()) {
            if (distance != Double.MAX_VALUE) {
                this.fail("d=" + distance);
            }
            event.setCancelled(true);
        }
        if (this.player.inputMode == InputMode.TOUCH && MathUtil.wrapDegrees(Math.abs(this.player.yaw - this.player.interactRotation.getY())) > 110.0f) {
            event.setCancelled(true);
        }
    }

    public ReachResult calculateReach(EntityCache entity) {
        float deltaTicks;
        double distance = Double.MAX_VALUE;
        for (deltaTicks = 0.0f; deltaTicks <= 1.0f; deltaTicks += 0.1f) {
            Vec3 prevHitResult;
            Vec3 rotationVec = this.getRotationVector(this.player, deltaTicks);
            Vec3 min = this.getEyePosition(this.player, deltaTicks);
            Vec3 max = min.add(rotationVec.multiply(7.0f));
            Vec3 hitResult = this.getEntityHitResult(entity.getCurrent().getBoundingBox(deltaTicks), min, max);
            if (hitResult != null) {
                distance = Math.min(distance, (double)hitResult.squaredDistanceTo(min));
            }
            if (entity.getPast() != null && (prevHitResult = this.getEntityHitResult(entity.getPast().getBoundingBox(deltaTicks), min, max)) != null) {
                distance = Math.min(distance, (double)prevHitResult.squaredDistanceTo(min));
            }
            if (distance <= 9.030025) break;
        }
        return new ReachResult(deltaTicks, distance == Double.MAX_VALUE ? distance : Math.sqrt(distance));
    }

    private Vec3 getEntityHitResult(Box box, Vec3 min, Vec3 max) {
        Box lv5 = box.expand(0.1f);
        Optional<Vec3> vec3 = lv5.clip(min, max);
        if (lv5.contains(min)) {
            return min;
        }
        return vec3.orElse(null);
    }

    private Vec3 getRotationVector(BoarPlayer player, float f) {
        float lerpedX = player.inputMode == InputMode.TOUCH ? player.interactRotation.getX() : MathUtil.lerp(f, player.prevPitch, player.pitch);
        float lerpedY = player.inputMode == InputMode.TOUCH ? player.interactRotation.getY() : MathUtil.lerp(f, player.prevYaw, player.yaw);
        return MathUtil.getRotationVector(lerpedX, lerpedY);
    }

    private Vec3 getEyePosition(BoarPlayer player, float f) {
        float d = MathUtil.lerp(f, player.prevPosition.x, player.position.x);
        float e = MathUtil.lerp(f, player.prevPosition.y, player.position.y) + player.dimensions.eyeHeight();
        float g = MathUtil.lerp(f, player.prevPosition.z, player.position.z);
        return new Vec3(d, e, g);
    }

    public record ReachResult(float deltaTicks, double distance) {
    }
}

