/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.packets.server;

import ac.boar.anticheat.compensated.cache.container.ContainerCache;
import ac.boar.anticheat.compensated.cache.entity.EntityCache;
import ac.boar.anticheat.data.EntityDimensions;
import ac.boar.anticheat.data.vanilla.AttributeInstance;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.protocol.event.CloudburstPacketEvent;
import ac.boar.protocol.listener.PacketListener;
import java.util.EnumSet;
import org.cloudburstmc.protocol.bedrock.data.Ability;
import org.cloudburstmc.protocol.bedrock.data.AbilityLayer;
import org.cloudburstmc.protocol.bedrock.data.AttributeData;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.cloudburstmc.protocol.bedrock.data.attribute.AttributeModifierData;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.MovementPredictionSyncPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetPlayerGameTypePacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAbilitiesPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.item.Items;

public class ServerDataPackets
implements PacketListener {
    @Override
    public void onPacketSend(CloudburstPacketEvent event, boolean immediate) {
        SetPlayerGameTypePacket packet;
        BoarPlayer player = event.getPlayer();
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof SetPlayerGameTypePacket) {
            packet = (SetPlayerGameTypePacket)bedrockPacket;
            player.sendLatencyStack();
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> {
                player.gameType = GameType.from((int)packet.getGamemode());
            });
        }
        if ((bedrockPacket = event.getPacket()) instanceof UpdateAbilitiesPacket) {
            packet = (UpdateAbilitiesPacket)bedrockPacket;
            if (packet.getUniqueEntityId() != player.runtimeEntityId) {
                return;
            }
            event.getPostTasks().add(() -> player.sendLatencyStack(immediate));
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get() + 1L, () -> ServerDataPackets.lambda$onPacketSend$2(player, (UpdateAbilitiesPacket)packet));
        }
        if ((bedrockPacket = event.getPacket()) instanceof SetEntityDataPacket) {
            EnumSet<EntityFlag> flagsCopy;
            packet = (SetEntityDataPacket)bedrockPacket;
            if (packet.getRuntimeEntityId() != player.runtimeEntityId) {
                EntityCache cache = player.compensatedWorld.getEntity(player.runtimeEntityId);
                if (cache == null) {
                    return;
                }
                player.sendLatencyStack(immediate);
                player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> ServerDataPackets.lambda$onPacketSend$3(cache, (SetEntityDataPacket)packet));
                return;
            }
            if (player.vehicleData != null) {
                return;
            }
            Float height = (Float)packet.getMetadata().get(EntityDataTypes.HEIGHT);
            Float width = (Float)packet.getMetadata().get(EntityDataTypes.WIDTH);
            EnumSet flags = packet.getMetadata().getFlags();
            if (flags == null && height == null && width == null) {
                return;
            }
            if (flags != null) {
                flagsCopy = EnumSet.noneOf(EntityFlag.class);
                flagsCopy.addAll(flags);
            } else {
                flagsCopy = null;
            }
            player.sendLatencyStack(immediate);
            long id = player.sentStackId.get();
            player.desyncedFlag.set(flagsCopy != null ? id : -1L);
            player.getLatencyUtil().addTaskToQueue(id, () -> {
                if (flagsCopy != null) {
                    player.getFlagTracker().set(flagsCopy);
                }
                if (width != null) {
                    player.dimensions = EntityDimensions.fixed(width.floatValue(), player.dimensions.height()).withEyeHeight(player.dimensions.eyeHeight());
                    player.boundingBox = player.dimensions.getBoxAt(player.position);
                }
                if (height != null) {
                    float eyeHeight = 1.62f;
                    if ((double)Math.abs(height.floatValue() - 0.2f) <= 0.001) {
                        eyeHeight = 0.2f;
                    } else if ((double)Math.abs(height.floatValue() - 0.6f) <= 0.001) {
                        eyeHeight = 0.4f;
                    } else if ((double)Math.abs(height.floatValue() - 1.5f) <= 0.001) {
                        eyeHeight = 1.27f;
                    }
                    player.dimensions = EntityDimensions.fixed(player.dimensions.width(), height.floatValue()).withEyeHeight(eyeHeight);
                    player.boundingBox = player.dimensions.getBoxAt(player.position);
                }
                if (player.desyncedFlag.get() == id) {
                    player.desyncedFlag.set(-1L);
                }
            });
        }
        if ((bedrockPacket = event.getPacket()) instanceof UpdateAttributesPacket) {
            packet = (UpdateAttributesPacket)bedrockPacket;
            if (packet.getRuntimeEntityId() != player.runtimeEntityId) {
                return;
            }
            player.sendLatencyStack(immediate);
            player.getLatencyUtil().addTaskToQueue(player.sentStackId.get(), () -> ServerDataPackets.lambda$onPacketSend$5(player, (UpdateAttributesPacket)packet));
        }
    }

    @Override
    public void onPacketReceived(CloudburstPacketEvent event) {
        BoarPlayer player = event.getPlayer();
        BedrockPacket bedrockPacket = event.getPacket();
        if (bedrockPacket instanceof MovementPredictionSyncPacket) {
            MovementPredictionSyncPacket packet = (MovementPredictionSyncPacket)bedrockPacket;
            if (packet.getRuntimeEntityId() != player.runtimeEntityId) {
                return;
            }
            player.getFlagTracker().set(EntityFlag.SNEAKING, packet.getFlags().contains(EntityFlag.SNEAKING));
            player.getFlagTracker().set(EntityFlag.SWIMMING, packet.getFlags().contains(EntityFlag.SWIMMING) && player.touchingWater);
            player.setSprinting(packet.getFlags().contains(EntityFlag.SPRINTING));
            boolean using = packet.getFlags().contains(EntityFlag.USING_ITEM);
            if (!using) {
                player.getSession().releaseItem();
            }
            player.getFlagTracker().set(EntityFlag.USING_ITEM, using);
            ContainerCache cache = player.compensatedInventory.armorContainer;
            player.getFlagTracker().set(EntityFlag.GLIDING, player.compensatedInventory.translate(cache.get(1).getData()).getId() == Items.ELYTRA.javaId() && packet.getFlags().contains(EntityFlag.GLIDING));
        }
    }

    private static /* synthetic */ void lambda$onPacketSend$5(BoarPlayer player, UpdateAttributesPacket packet) {
        if (player.vehicleData != null) {
            return;
        }
        for (AttributeData data : packet.getAttributes()) {
            AttributeInstance attribute = (AttributeInstance)player.attributes.get(data.getName());
            if (attribute == null) {
                return;
            }
            attribute.clearModifiers();
            attribute.setBaseValue(data.getDefaultValue());
            attribute.setValue(data.getValue());
            for (AttributeModifierData lv5 : data.getModifiers()) {
                attribute.addTemporaryModifier(lv5);
            }
        }
    }

    private static /* synthetic */ void lambda$onPacketSend$3(EntityCache cache, SetEntityDataPacket packet) {
        cache.setMetadata(packet.getMetadata());
    }

    private static /* synthetic */ void lambda$onPacketSend$2(BoarPlayer player, UpdateAbilitiesPacket packet) {
        player.abilities.clear();
        for (AbilityLayer layer : packet.getAbilityLayers()) {
            player.abilities.addAll(layer.getAbilityValues());
        }
        player.getFlagTracker().setFlying(player.abilities.contains(Ability.FLYING) || player.abilities.contains(Ability.MAY_FLY) && player.getFlagTracker().isFlying());
    }
}

