/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.check.impl.timer;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.check.api.annotations.CheckInfo;
import ac.boar.anticheat.check.api.annotations.Experimental;
import ac.boar.anticheat.check.api.impl.PingBasedCheck;
import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.LatencyUtil;

@Experimental
@CheckInfo(name="Timer")
public final class Timer
extends PingBasedCheck {
    private static final long AVERAGE_DISTANCE = 50000000L;
    private long lastNS;
    private long balance;
    private long prevTick;
    private long loseBalance;
    private boolean beforeAuthInput;

    public Timer(BoarPlayer player) {
        super(player);
    }

    @Override
    public void onLatencyAccepted(long id, LatencyUtil.Time time) {
        if (!this.beforeAuthInput) {
            return;
        }
        this.beforeAuthInput = false;
        if (time.ns() > System.nanoTime() + this.balance) {
            long distance = time.ns() - (System.nanoTime() + this.balance) - 25000000L;
            this.balance += distance;
            this.loseBalance = Math.max(0L, this.loseBalance - distance);
        }
    }

    public boolean isInvalid() {
        if (this.lastNS == 0L || this.player.inLoadingScreen || this.player.sinceLoadingScreen < 20) {
            this.lastNS = System.nanoTime();
            this.prevTick = this.player.tick;
            this.balance = 0L;
            return false;
        }
        boolean valid = true;
        long distance = System.nanoTime() - this.lastNS;
        long neededDistance = (this.player.tick - this.prevTick) * 50000000L;
        long limit = 63000000L;
        if (this.balance > 63000000L) {
            if (this.balance - this.loseBalance <= 63000000L) {
                this.loseBalance -= 50000000L;
                Boar.debug(this.getDisplayName() + " failed timer check due to balance limiter, but won't flag since player could actually be lagging.", Boar.DebugMessage.INFO);
            } else {
                this.fail("balance=" + this.balance + ", player is ahead!");
            }
            this.player.getTeleportUtil().teleportTo(this.player.getTeleportUtil().getLastKnowValid());
            this.balance -= 50000000L;
            valid = false;
        } else {
            long maxBalanceAdvantage = (long)Math.max(0.0, (double)Boar.getConfig().maxBalanceAdvantage() * 1000000.0);
            if (this.balance <= -Math.abs(maxBalanceAdvantage + 50000000L) && Boar.getConfig().maxBalanceAdvantage() > 0L) {
                this.loseBalance = Math.abs(this.balance);
                this.balance = -50000000L;
            }
        }
        this.balance -= distance - neededDistance;
        this.lastNS = Math.max(this.lastNS, System.nanoTime());
        this.prevTick = this.player.tick;
        this.beforeAuthInput = true;
        return !valid;
    }
}

