/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.collision;

import ac.boar.anticheat.player.BoarPlayer;
import ac.boar.anticheat.util.MathUtil;
import ac.boar.anticheat.util.math.Box;
import ac.boar.anticheat.util.math.Vec3;
import java.util.List;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.level.physics.Axis;

public class Collider {
    public static boolean canFallAtLeast(BoarPlayer player, float offsetX, float offsetZ, float f) {
        Box lv = player.boundingBox.expand(-0.025f, 0.0f, -0.025f);
        return player.compensatedWorld.noCollision(new Box(lv.minX + offsetX, lv.minY - f, lv.minZ + offsetZ, lv.maxX + offsetX, lv.minY, lv.maxZ + offsetZ));
    }

    private static boolean isAboveGround(BoarPlayer player) {
        return player.onGround || player.fallDistance < 0.6f && !Collider.canFallAtLeast(player, 0.0f, 0.0f, 0.6f - player.fallDistance);
    }

    public static Vec3 maybeBackOffFromEdge(BoarPlayer player, Vec3 movement) {
        float f = 0.606f;
        if ((double)movement.y <= 0.0 && player.getFlagTracker().has(EntityFlag.SNEAKING) && Collider.isAboveGround(player)) {
            float d;
            float e = movement.z;
            float h = (float)MathUtil.sign(d) * 0.05f;
            float i = (float)MathUtil.sign(e) * 0.05f;
            for (d = movement.x; d != 0.0f && Collider.canFallAtLeast(player, d, 0.0f, 0.606f); d -= h) {
                if (!((double)Math.abs(d) <= 0.05)) continue;
                d = 0.0f;
                break;
            }
            while ((double)e != 0.0 && Collider.canFallAtLeast(player, 0.0f, e, 0.606f)) {
                if ((double)Math.abs(e) <= 0.05) {
                    e = 0.0f;
                    break;
                }
                e -= i;
            }
            while ((double)d != 0.0 && (double)e != 0.0 && Collider.canFallAtLeast(player, d, e, 0.606f)) {
                d = (double)Math.abs(d) <= 0.05 ? 0.0f : (d -= h);
                if ((double)Math.abs(e) <= 0.05) {
                    e = 0.0f;
                    continue;
                }
                e -= i;
            }
            return new Vec3(d, movement.y, e);
        }
        return movement;
    }

    public static Vec3 collide(BoarPlayer player, Vec3 movement) {
        boolean onGround;
        Box box = player.boundingBox.clone();
        List<Box> collisions = player.compensatedWorld.getEntityCollisions(box.stretch(movement));
        Vec3 lv2 = (double)movement.lengthSquared() == 0.0 ? movement : Collider.collideBoundingBox(player, movement, box, collisions);
        boolean collisionX = movement.x != lv2.x;
        boolean collisionZ = movement.z != lv2.z;
        boolean verticalCollision = movement.y != lv2.y;
        boolean bl = onGround = verticalCollision && (double)movement.y < 0.0;
        if ((onGround || player.onGround) && (collisionX || collisionZ)) {
            Vec3 vec34;
            Vec3 vec32 = Collider.collideBoundingBox(player, new Vec3(movement.x, 0.6f, movement.z), box, collisions);
            Vec3 vec33 = Collider.collideBoundingBox(player, new Vec3(0.0f, 0.6f, 0.0f), box.stretch(movement.x, 0.0f, movement.z), collisions);
            if (vec33.y < 0.6f && (vec34 = Collider.collideBoundingBox(player, new Vec3(movement.x, 0.0f, movement.z), box.offset(vec33), collisions).add(vec33)).horizontalLengthSquared() > vec32.horizontalLengthSquared()) {
                vec32 = vec34;
            }
            if (vec32.horizontalLengthSquared() > lv2.horizontalLengthSquared()) {
                lv2 = vec32.add(Collider.collideBoundingBox(player, new Vec3(0.0f, -vec32.y, 0.0f), box.offset(vec32), collisions));
            }
        }
        return lv2;
    }

    private static Vec3 collideBoundingBox(BoarPlayer player, Vec3 movement, Box box, List<Box> collisions) {
        collisions.addAll(player.compensatedWorld.collectColliders(collisions, box.stretch(movement)));
        return Collider.collideWithShapes(movement, box, collisions);
    }

    private static Vec3 collideWithShapes(Vec3 movement, Box box, List<Box> collisions) {
        if (!collisions.isEmpty()) {
            float x = movement.x;
            float y = movement.y;
            float z = movement.z;
            if ((double)y != 0.0 && (double)(y = Collider.calculateMaxOffset(Axis.Y, box, collisions, y)) != 0.0) {
                box = box.offset(0.0f, y, 0.0f);
            }
            if ((double)x != 0.0 && (double)(x = Collider.calculateMaxOffset(Axis.X, box, collisions, x)) != 0.0) {
                box = box.offset(x, 0.0f, 0.0f);
            }
            if ((double)z != 0.0) {
                z = Collider.calculateMaxOffset(Axis.Z, box, collisions, z);
            }
            return new Vec3(x, y, z);
        }
        return movement;
    }

    private static float calculateMaxOffset(Axis axis, Box boundingBox, List<Box> collision, float maxDist) {
        Box box = boundingBox.clone();
        for (Box bb : collision) {
            if (Math.abs(maxDist) < 1.0E-7f) {
                return 0.0f;
            }
            maxDist = bb.calculateMaxDistance(axis, box, maxDist);
        }
        return maxDist;
    }
}

