/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.reflect.localcapture;

import ac.boar.shaded.reflect.Classes;
import ac.boar.shaded.reflect.JavaBypass;
import ac.boar.shaded.reflect.exceptions.MethodNotFoundException;
import ac.boar.shaded.reflect.localcapture.LocalStackFrame;
import ac.boar.shaded.reflect.localcapture.LocalStackFrameImpl;
import ac.boar.shaded.reflect.utils.FieldInitializer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class LocalCapturer {
    private static final Class<?> liveStackFrame = Classes.forName("java.lang.LiveStackFrame");
    private static final StackWalker stackWalker = FieldInitializer.reqInit(() -> {
        MethodHandle getStackWalker = JavaBypass.TRUSTED_LOOKUP.findStatic(liveStackFrame, "getStackWalker", MethodType.methodType(StackWalker.class, Set.class));
        return getStackWalker.invokeExact(Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE));
    }, () -> new MethodNotFoundException(liveStackFrame.getName(), "getStackWalker", StackWalker.class));

    public static void forEach(Consumer<LocalStackFrame> consumer) {
        LocalCapturer.walk(s -> {
            s.skip(1L).forEach(consumer);
            return null;
        });
    }

    public static <T> T walk(Function<Stream<LocalStackFrame>, T> function) {
        return (T)stackWalker.walk(s -> function.apply(s.skip(1L).map(LocalStackFrameImpl::new)));
    }

    public static LocalStackFrame[] getStackFrames() {
        return LocalCapturer.walk(s -> (LocalStackFrame[])s.toArray(LocalStackFrame[]::new));
    }
}

