/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.data.inventory;

import ac.boar.anticheat.compensated.CompensatedInventory;
import ac.boar.anticheat.data.inventory.BundleData;
import java.util.Objects;
import lombok.Generated;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class ItemCache {
    public static final ItemCache AIR = new ItemCache(ItemData.AIR);
    private ItemData data;
    private BundleData bundle = null;

    private ItemCache(ItemData data) {
        this.data = data;
    }

    public ItemCache count(int count) {
        ItemData.Builder builder = this.data.toBuilder();
        builder.count(count);
        this.data = builder.build();
        return this;
    }

    public int count() {
        return this.data.getCount();
    }

    public boolean isEmpty() {
        return this.data.getCount() <= 0 || this.data.getDefinition().getRuntimeId() == 0 || this.data.getDefinition().getRuntimeId() == -1;
    }

    public ItemCache clone() {
        ItemCache cache = new ItemCache(this.data);
        cache.setBundle(this.bundle);
        return cache;
    }

    public static ItemCache build(CompensatedInventory inventory, ItemData data) {
        ItemCache cache = new ItemCache(data);
        ItemStack itemStack = inventory.translate(data);
        if (GeyserItemStack.from((ItemStack)itemStack).is(inventory.getPlayer().getSession(), ItemTag.BUNDLES)) {
            int id = -1;
            try {
                id = Objects.requireNonNull(data.getTag()).getInt("bundle_id");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (id == -1 || inventory.getBundleCache().containsKey(id)) {
                return cache;
            }
            BundleData bundle = new BundleData();
            bundle.setBundleId(id);
            cache.setBundle(bundle);
            inventory.getBundleCache().put(bundle.getBundleId(), cache);
        }
        return cache;
    }

    @Generated
    public ItemData getData() {
        return this.data;
    }

    @Generated
    public BundleData getBundle() {
        return this.bundle;
    }

    @Generated
    public void setData(ItemData data) {
        this.data = data;
    }

    @Generated
    public void setBundle(BundleData bundle) {
        this.bundle = bundle;
    }
}

