/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.anticheat.util;

import ac.boar.anticheat.Boar;
import ac.boar.anticheat.check.api.Check;
import ac.boar.anticheat.check.api.impl.PingBasedCheck;
import ac.boar.anticheat.player.BoarPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import lombok.Generated;

public final class LatencyUtil {
    private final BoarPlayer player;
    private final Queue<Long> sentQueue = new ConcurrentLinkedQueue<Long>();
    private final Map<Long, Time> idToSentTime = new ConcurrentHashMap<Long, Time>();
    private final Map<Long, List<Runnable>> idToTasks = new ConcurrentHashMap<Long, List<Runnable>>();
    private long lastRespondTime = System.currentTimeMillis() + Boar.getConfig().maxLatencyWait();
    private long prevSentTime = System.currentTimeMillis();
    private Time prevReceivedSentTime = new Time(-1L, -1L);
    private Time nextRecivedSentTime = new Time(-1L, -1L);

    public Time getLastSentTime() {
        return this.prevReceivedSentTime;
    }

    public Time getNextSentTime() {
        return this.nextRecivedSentTime;
    }

    public boolean hasId(long id) {
        return this.sentQueue.contains(id);
    }

    public void addLatencyToQueue(long id) {
        Time time = new Time(System.currentTimeMillis(), System.nanoTime());
        this.sentQueue.add(id);
        this.idToSentTime.put(id, time);
        this.onLatencySend();
        this.prevSentTime = System.currentTimeMillis();
        if (this.prevReceivedSentTime == this.nextRecivedSentTime) {
            this.nextRecivedSentTime = time;
        }
    }

    public void addTaskToQueue(long id, Runnable runnable) {
        if (id <= this.player.receivedStackId.get()) {
            runnable.run();
            return;
        }
        this.idToTasks.computeIfAbsent(id, k -> new ArrayList()).add(runnable);
    }

    public void confirmByTime(long time) {
        long distance;
        Time sentTime;
        Long next;
        if (time < this.prevReceivedSentTime.ms()) {
            return;
        }
        long lastId = -1L;
        while ((next = this.sentQueue.peek()) != null && (sentTime = this.idToSentTime.get(next)).ms() <= time) {
            List<Runnable> tasks;
            this.idToSentTime.remove(next);
            if (sentTime.ms() > this.prevReceivedSentTime.ms()) {
                this.prevReceivedSentTime = sentTime;
            }
            if ((tasks = this.idToTasks.remove(next)) != null) {
                tasks.forEach(Runnable::run);
            }
            this.onLatencyAccepted(next, sentTime);
            this.sentQueue.poll();
            lastId = next;
        }
        if (lastId == -1L || lastId < this.player.receivedStackId.get()) {
            return;
        }
        this.nextRecivedSentTime = this.prevReceivedSentTime;
        next = this.sentQueue.peek();
        if (next != null && (sentTime = this.idToSentTime.get(next)) != null) {
            this.nextRecivedSentTime = sentTime;
        }
        if ((distance = System.currentTimeMillis() - this.prevReceivedSentTime.ms()) >= Boar.getConfig().maxLatencyWait()) {
            this.player.kick("Timed out.");
            return;
        }
        this.lastRespondTime = System.currentTimeMillis();
        this.player.receivedStackId.set(lastId);
    }

    public boolean confirmStackId(long id) {
        long distance;
        Time sentTime;
        Long next;
        if (!this.hasId(id) || id <= this.player.receivedStackId.get()) {
            return false;
        }
        while ((next = this.sentQueue.peek()) != null && next <= id) {
            Time sentTime2;
            List<Runnable> tasks = this.idToTasks.remove(next);
            if (tasks != null) {
                tasks.forEach(Runnable::run);
            }
            if ((sentTime2 = this.idToSentTime.remove(next)) != null) {
                if (sentTime2.ms() > this.prevReceivedSentTime.ms()) {
                    this.prevReceivedSentTime = sentTime2;
                }
                this.onLatencyAccepted(next, sentTime2);
            }
            this.sentQueue.poll();
        }
        this.nextRecivedSentTime = this.prevReceivedSentTime;
        next = this.sentQueue.peek();
        if (next != null && (sentTime = this.idToSentTime.get(next)) != null) {
            this.nextRecivedSentTime = sentTime;
        }
        if ((distance = System.currentTimeMillis() - this.prevReceivedSentTime.ms()) >= Boar.getConfig().maxLatencyWait()) {
            this.player.kick("Timed out.");
            return true;
        }
        this.lastRespondTime = System.currentTimeMillis();
        this.player.receivedStackId.set(id);
        return true;
    }

    private void onLatencySend() {
        for (Check check : this.player.getCheckHolder().values()) {
            if (!(check instanceof PingBasedCheck)) continue;
            PingBasedCheck pingBasedCheck = (PingBasedCheck)check;
            pingBasedCheck.onLatencySend(this.player.sentStackId.get());
        }
    }

    private void onLatencyAccepted(long id, Time time) {
        for (Check check : this.player.getCheckHolder().values()) {
            if (!(check instanceof PingBasedCheck)) continue;
            PingBasedCheck pingBasedCheck = (PingBasedCheck)check;
            pingBasedCheck.onLatencyAccepted(id, time);
        }
    }

    @Generated
    public LatencyUtil(BoarPlayer player) {
        this.player = player;
    }

    @Generated
    public long getLastRespondTime() {
        return this.lastRespondTime;
    }

    @Generated
    public long getPrevSentTime() {
        return this.prevSentTime;
    }

    public record Time(long ms, long ns) {
    }
}

