/*
 * Decompiled with CFR 0.152.
 */
package ac.boar.shaded.classtransform.transformer;

import ac.boar.shaded.classtransform.transformer.AnnotationHandler;
import ac.boar.shaded.classtransform.transformer.impl.CInlineAnnotationHandler;
import ac.boar.shaded.classtransform.transformer.impl.general.SyntheticMethodGeneralHandler;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum HandlerPosition {
    PRE(SyntheticMethodGeneralHandler.class, InsertPosition.AFTER),
    POST(CInlineAnnotationHandler.class, InsertPosition.BEFORE);

    private final Class<? extends AnnotationHandler> target;
    private final InsertPosition insertPosition;

    private HandlerPosition(Class<? extends AnnotationHandler> target, InsertPosition insertPosition) {
        this.target = target;
        this.insertPosition = insertPosition;
    }

    public void add(List<AnnotationHandler> handler, AnnotationHandler newHandler) {
        for (int i = 0; i < handler.size(); ++i) {
            if (!handler.get(i).getClass().equals(this.target)) continue;
            if (InsertPosition.BEFORE.equals((Object)this.insertPosition)) {
                handler.add(i, newHandler);
            } else if (InsertPosition.AFTER.equals((Object)this.insertPosition)) {
                handler.add(i + 1, newHandler);
            }
            return;
        }
        throw new RuntimeException("Unable to find target handler '" + this.target.getName() + "'");
    }

    private static enum InsertPosition {
        BEFORE,
        AFTER;

    }
}

